/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.importexport;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.jmsadmin.core.internal.base.JmsAdminDataModel;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.ui.extensions.IExplorerRuntimeImportExport;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ImportExport
implements IExplorerRuntimeImportExport {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/importexport/ImportExport.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SUBCATEGORY_ID_JMS_CONTEXTS = "com.ibm.mq.explorer.jmsadmin.contexts";

    public boolean importData(String categoryId, String subcategoryId, IMemento rootRead) {
        XMLMemento childNode;
        Trace t = Trace.getDefault();
        boolean result = true;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.conn.info") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_JMS_CONTEXTS) == 0 && (childNode = (XMLMemento)this.getIfValidJmsMemento(t, rootRead)) != null) {
            try {
                result = false;
                JmsAdminDataModel jmsDm = JmsAdminDataModel.getDataModel();
                result = jmsDm.mergeDm(t, childNode);
                if (result) {
                    JmsAdminPlugin.loadJmsInitialContextsFromDataModel(t, true);
                }
            }
            catch (DmCoreException e) {
                t.FFST(66, "ImportExport.importData", 10, -1, 0, 0, e.getMessage(), null, null);
            }
        }
        return result;
    }

    private IMemento getIfValidJmsMemento(Trace t, IMemento memento) {
        IMemento validMemento = null;
        validMemento = memento.getChild("JndiInitialContexts");
        if (validMemento == null && memento.getType().equals("JndiInitialContexts")) {
            validMemento = memento;
        }
        return validMemento;
    }

    public IMemento exportData(String categoryId, String subcategoryId) {
        Trace t = Trace.getDefault();
        XMLMemento jmsRoot = null;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.conn.info") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_JMS_CONTEXTS) == 0) {
            jmsRoot = XMLMemento.createWriteRoot((String)"ROOTNODE");
            JmsAdminDataModel jmsDm = JmsAdminDataModel.getDataModel();
            if (jmsDm != null) {
                jmsRoot.copyChild((IMemento)jmsDm.getDmAsXMLMemento(t));
            }
        }
        return jmsRoot;
    }

    public boolean persistData() {
        return false;
    }

    public boolean isDestructiveImport() {
        return false;
    }
}

