/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.params;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.AbstractJmsParameter;
import com.ibm.mq.jms.MQDestination;
import javax.jms.JMSException;

public class JmsPutAsyncAllowed
extends AbstractJmsParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/params/JmsPutAsyncAllowed.java";

    public JmsPutAsyncAllowed() {
        super(13076, "Asyncronous puts allowed");
    }

    @Override
    public void createAttribute(Trace t, DmJmsObject dmObject) throws DmCoreException {
        int value;
        Object object = dmObject.getObject();
        try {
            if (!(object instanceof MQDestination)) {
                String insert0 = Integer.toString(this.PCFID);
                String insert1 = this.getLongName();
                String insert2 = object.getClass().toString();
                String[] inserts = new String[]{insert0, insert1, insert2};
                String msgId = "AMQ4441";
                String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
                DmCoreException e = new DmCoreException(t, message, msgId, 50024, 0, 30);
                t.FFST(66, "JmsPutAsyncAllowed.createAttribute", 0, 50024, 0, 0, insert0, insert1, insert2);
                throw e;
            }
            value = ((MQDestination)object).getPutAsyncAllowed();
        }
        catch (JMSException e) {
            String insert0 = Integer.toString(this.PCFID);
            String insert1 = this.getLongName();
            String insert2 = object.getClass().toString();
            String insert3 = e.getErrorCode();
            String insert4 = e.getMessage();
            String[] inserts = new String[]{insert0, insert1, insert2, insert3, insert4};
            String msgId = "AMQ4442";
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
            DmCoreException e2 = new DmCoreException(t, message, (Throwable)e, msgId, 50024, 0, 30);
            t.FFST(66, "JmsPutAsyncAllowed.createAttribute", 1, 50024, 0, 0, insert0, insert1, insert2);
            throw e2;
        }
        catch (Exception e) {
            boolean value2 = true;
            String msgId = "AMQ4458";
            String insert0 = this.getLongName();
            String insert1 = dmObject.getTitle();
            String[] inserts = new String[]{insert0, insert1};
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
            DmCoreException e2 = new DmCoreException(t, message, (Throwable)e, msgId, 50024, 0, 30);
            t.FFST(66, "JmsPutAsyncAllowed.createAttribute", 2, 50024, "Failed to get the JMS property 'PUTASYNCALLOWED': " + e.toString());
            throw e2;
        }
        dmObject.createAttribute(t, null, this.PCFID, 0, value);
    }

    @Override
    public void update(Trace t, DmJmsObject dmObject, Object newValue) throws DmCoreException {
        Object object = dmObject.getObject();
        int value = (Integer)newValue;
        try {
            if (!(object instanceof MQDestination)) {
                String insert0 = Integer.toString(this.PCFID);
                String insert1 = this.getLongName();
                String insert2 = object.getClass().toString();
                String[] inserts = new String[]{insert0, insert1, insert2};
                String msgId = "AMQ4441";
                String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
                DmCoreException e = new DmCoreException(t, message, msgId, 50024, 0, 30);
                t.FFST(66, "JmsPutAsyncAllowed.update", 0, 50024, 0, 0, insert0, insert1, insert2);
                throw e;
            }
            ((MQDestination)object).setPutAsyncAllowed(value);
        }
        catch (JMSException e) {
            String insert0 = Integer.toString(this.PCFID);
            String insert1 = this.getLongName();
            String insert2 = object.getClass().toString();
            String insert3 = e.getErrorCode();
            String insert4 = e.getMessage();
            String[] inserts = new String[]{insert0, insert1, insert2, insert3, insert4};
            String msgId = "AMQ4442";
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
            DmCoreException e2 = new DmCoreException(t, message, (Throwable)e, msgId, 50024, 0, 30);
            t.FFST(66, "JmsPutAsyncAllowed.update", 1, 50024, 0, 0, insert0, insert1, insert2);
            throw e2;
        }
        catch (Exception e) {
            value = 1;
            String msgId = "AMQ4458";
            String insert0 = this.getLongName();
            String insert1 = dmObject.getTitle();
            String[] inserts = new String[]{insert0, insert1};
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
            DmCoreException e2 = new DmCoreException(t, message, (Throwable)e, msgId, 50024, 0, 30);
            t.FFST(66, "JmsPutAsyncAllowed.update", 2, 50024, "Failed to set the JMS property 'PUTASYNCALLOWED': " + e.toString());
            throw e2;
        }
    }
}

