/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.params;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnumRange;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.AbstractJmsParameter;
import com.ibm.mq.jms.MQConnectionFactory;
import java.util.regex.Pattern;
import javax.jms.JMSException;

public class JmsProviderVersion
extends AbstractJmsParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/params/JmsProviderVersion.java";
    private static final String VALID_FORMS = "unspecified|[0-9]+|[0-9]+[.][0-9]+|[0-9]+[.][0-9]+[.][0-9]+|[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+";

    public JmsProviderVersion() {
        super(13072, "Provider version");
    }

    @Override
    public void createAttribute(Trace t, DmJmsObject dmObject) throws DmCoreException {
        String value;
        block3: {
            Object object = dmObject.getObject();
            try {
                if (object instanceof MQConnectionFactory) {
                    value = ((MQConnectionFactory)object).getProviderVersion();
                    value = value == null ? new String() : this.getVersion(t, value);
                    break block3;
                }
                String insert0 = Integer.toString(this.PCFID);
                String insert1 = this.getLongName();
                String insert2 = object.getClass().toString();
                String[] inserts = new String[]{insert0, insert1, insert2};
                String msgId = "AMQ4441";
                String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
                DmCoreException e = new DmCoreException(t, message, msgId, 50024, 0, 30);
                t.FFST(66, "JmsProviderVersion.createAttribute", 0, 50024, 0, 0, insert0, insert1, insert2);
                throw e;
            }
            catch (JMSException e) {
                String insert0 = Integer.toString(this.PCFID);
                String insert1 = this.getLongName();
                String insert2 = object.getClass().toString();
                String insert3 = e.getErrorCode();
                String insert4 = e.getMessage();
                String[] inserts = new String[]{insert0, insert1, insert2, insert3, insert4};
                String msgId = "AMQ4442";
                String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
                DmCoreException e2 = new DmCoreException(t, message, (Throwable)e, msgId, 50024, 0, 30);
                t.FFST(66, "JmsProviderVersion.createAttribute", 1, 50024, 0, 0, insert0, insert1, insert2);
                throw e2;
            }
        }
        dmObject.createAttribute(t, null, this.PCFID, 0, value);
    }

    @Override
    public void update(Trace t, DmJmsObject dmObject, Object newValue) throws DmCoreException {
        Object object = dmObject.getObject();
        String value = (String)newValue;
        try {
            if (!(object instanceof MQConnectionFactory)) {
                String insert0 = Integer.toString(this.PCFID);
                String insert1 = this.getLongName();
                String insert2 = object.getClass().toString();
                String[] inserts = new String[]{insert0, insert1, insert2};
                String msgId = "AMQ4441";
                String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
                DmCoreException e = new DmCoreException(t, message, msgId, 50024, 0, 30);
                t.FFST(66, "JmsProviderVersion.update", 0, 50024, 0, 0, insert0, insert1, insert2);
                throw e;
            }
            ((MQConnectionFactory)object).setProviderVersion(value);
        }
        catch (JMSException e) {
            String insert0 = Integer.toString(this.PCFID);
            String insert1 = this.getLongName();
            String insert2 = object.getClass().toString();
            String insert3 = e.getErrorCode();
            String insert4 = e.getMessage();
            String[] inserts = new String[]{insert0, insert1, insert2, insert3, insert4};
            String msgId = "AMQ4442";
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
            DmCoreException e2 = new DmCoreException(t, message, (Throwable)e, msgId, 50024, 0, 30);
            t.FFST(66, "JmsProviderVersion.update", 1, 50024, 0, 0, insert0, insert1, insert2);
            throw e2;
        }
    }

    @Override
    public void validate(Trace t, DmJmsObject dmObject) throws DmCoreException {
        String value;
        Attr attr = dmObject.getAttributeInternal(t, this.PCFID, 0);
        Object newValue = attr.getNewValue(t);
        if (!(newValue == null || (value = (String)newValue).length() != 0 && Pattern.matches(VALID_FORMS, value))) {
            String msgId = "AMQ4470";
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId);
            DmCoreException e = new DmCoreException(t, message, msgId, 50024, 0, 30);
            throw e;
        }
    }

    private String getVersion(Trace t, String key) {
        String returnValue = key;
        AttrType at = DmJmsConnectionFactory.getAttributeType(t, 13072);
        if (at instanceof AttrTypeFixedLengthStringEnumRange) {
            returnValue = ((AttrTypeFixedLengthStringEnumRange)at).getEnumeratedValue(t, key);
        }
        return returnValue;
    }
}

