/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.params;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnum;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.AbstractJmsParameter;
import com.ibm.mq.jms.MQConnectionFactory;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.JMSException;

public class JmsCompressionMessage
extends AbstractJmsParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/params/JmsCompressionMessage.java";

    public JmsCompressionMessage() {
        super(13018, "CompMsg");
    }

    @Override
    public void createAttribute(Trace t, DmJmsObject dmObject) throws DmCoreException {
        Object object = dmObject.getObject();
        Collection list = null;
        if (!(object instanceof MQConnectionFactory)) {
            String insert0 = Integer.toString(this.PCFID);
            String insert1 = this.getLongName();
            String insert2 = object.getClass().toString();
            String[] inserts = new String[]{insert0, insert1, insert2};
            String msgId = "AMQ4441";
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
            DmCoreException e = new DmCoreException(t, message, msgId, 50024, 0, 30);
            t.FFST(66, "JmsCompressionMessage.createAttribute", 0, 50024, 0, 0, insert0, insert1, insert2);
            throw e;
        }
        list = ((MQConnectionFactory)object).getMsgCompList();
        int[] array = this.convertToPaddedArray(t, list);
        dmObject.createAttribute(t, null, this.PCFID, 0, array);
    }

    @Override
    public void update(Trace t, DmJmsObject dmObject, Object newValue) throws DmCoreException {
        Object object = dmObject.getObject();
        Collection newValueCollection = (Collection)newValue;
        try {
            if (!(object instanceof MQConnectionFactory)) {
                String insert0 = Integer.toString(this.PCFID);
                String insert1 = this.getLongName();
                String insert2 = object.getClass().toString();
                String[] inserts = new String[]{insert0, insert1, insert2};
                String msgId = "AMQ4441";
                String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
                DmCoreException e = new DmCoreException(t, message, msgId, 50024, 0, 30);
                t.FFST(66, "JmsCompressionMessage.update", 0, 50024, 0, 0, insert0, insert1, insert2);
                throw e;
            }
            ((MQConnectionFactory)object).setMsgCompList(newValueCollection);
        }
        catch (JMSException e) {
            String insert0 = Integer.toString(this.PCFID);
            String insert1 = this.getLongName();
            String insert2 = object.getClass().toString();
            String insert3 = e.getErrorCode();
            String insert4 = e.getMessage();
            String[] inserts = new String[]{insert0, insert1, insert2, insert3, insert4};
            String msgId = "AMQ4442";
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
            DmCoreException e2 = new DmCoreException(t, message, (Throwable)e, msgId, 50024, 0, 30);
            t.FFST(66, "JmsCompressionMessage.update", 1, 50024, 0, 0, insert0, insert1, insert2);
            throw e2;
        }
    }

    @Override
    public void replaceValue(Trace t, DmJmsObject dmObject) {
        Attr attr = dmObject.getAttributeInternal(t, this.PCFID, 0);
        Object newValue = attr.getNewValue(t);
        Collection newValueCollection = (Collection)newValue;
        ArrayList newValue2 = this.convertToPaddedList(t, newValueCollection);
        attr.replaceValue(t, (Object)newValue2);
    }

    private int[] convertToPaddedArray(Trace t, Collection list) {
        AttrType at = DmJmsAbstractConnectionFactory.getAttributeType(t, this.PCFID);
        AttrTypeIntArrayEnum at2 = (AttrTypeIntArrayEnum)at;
        int size = at2.getItemCount(t);
        if (list != null && list.size() > size) {
            size = list.size();
        }
        int[] array = (int[])Array.newInstance(Integer.TYPE, size);
        int i = 0;
        if (list != null) {
            for (Integer item : list) {
                array[i++] = item;
            }
        }
        while (i < size) {
            array[i++] = -1;
        }
        return array;
    }

    private ArrayList convertToPaddedList(Trace t, Collection list) {
        int[] array = this.convertToPaddedArray(t, list);
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            Integer number = array[i];
            result.add(number);
            ++i;
        }
        return result;
    }
}

