/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.params;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.IJmsParameter;
import java.util.Hashtable;

public abstract class AbstractJmsParameter
implements IJmsParameter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/params/AbstractJmsParameter.java";
    protected int PCFID;
    protected String longName;

    public AbstractJmsParameter(int id, String longName) {
        this.PCFID = id;
        this.longName = longName;
    }

    @Override
    public void actionChange(Trace t, DmJmsObject dmObject) throws DmCoreException {
        Attr attr = dmObject.getAttributeInternal(t, this.PCFID, 0);
        Object newValue = attr.getNewValue(t);
        if (newValue != null) {
            this.update(t, dmObject, newValue);
        }
    }

    @Override
    public void actionRestore(Trace t, DmJmsObject dmObject) throws DmCoreException {
        Attr attr = dmObject.getAttributeInternal(t, this.PCFID, 0);
        Object value = attr.getValue(t);
        this.update(t, dmObject, value);
    }

    @Override
    public void replaceValue(Trace t, DmJmsObject dmObject) {
        Attr attr = dmObject.getAttributeInternal(t, this.PCFID, 0);
        Object newValue = attr.getNewValue(t);
        attr.replaceValue(t, newValue);
    }

    public abstract void update(Trace var1, DmJmsObject var2, Object var3) throws DmCoreException;

    @Override
    public void validate(Trace t, DmJmsObject dmObject) throws DmCoreException {
    }

    @Override
    public void addToHashtable(Hashtable table) {
        table.put(this.getId(), this);
    }

    @Override
    public int getId() {
        return this.PCFID;
    }

    @Override
    public String getLongName() {
        return this.longName;
    }

    @Override
    public String getFieldName(Trace t) {
        String stem = this.getLabelResourceStem();
        String name = CoreServices.message.getMessage(t, String.valueOf(stem) + ".title");
        String propTitle = CoreServices.message.getMessage(t, String.valueOf(stem) + Message.PROP_TITLE);
        if (propTitle.indexOf(Message.PROP_TITLE) == -1) {
            name = propTitle;
        }
        return name;
    }

    @Override
    public String getLabelResourceStem() {
        return "JMS_" + this.longName.toUpperCase();
    }

    @Override
    public String getSelectTitleId() {
        return "JmsAdmin.SelectObject.title";
    }

    @Override
    public String getSelectDescriptionId() {
        return "JmsAdmin.SelectObject." + this.longName + ".description";
    }
}

