/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.AbstractAttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NamingSecurityException;
import javax.naming.NoInitialContextException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;

public class JndiErrorHandler {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/objects/JndiErrorHandler.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final JndiErrorHandler singleton = new JndiErrorHandler();
    public static final int OPERATION_BIND = 0;
    public static final int OPERATION_REBIND = 1;
    public static final int OPERATION_UNBIND = 2;
    public static final int OPERATION_RENAME = 3;
    public static final int OPERATION_LIST = 4;
    public static final int OPERATION_CLOSE = 5;
    public static final int OPERATION_CREATE_SUBCONTEXT = 6;
    public static final int OPERATION_DESTROY_SUBCONTEXT = 7;
    public static final int OPERATION_CREATE_INITIAL_CONTEXT = 8;
    private static final String[] operationNames = new String[]{"bind", "rebind", "unbind", "rename", "list", "close", "createSubcontext", "destroySubcontext", "createInitialContext"};

    private JndiErrorHandler() {
    }

    public static JndiErrorHandler getHandler() {
        return singleton;
    }

    public void handleException(Trace t, Exception e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        this.traceError(t, e, "JndiErrorHandler.handleException");
        if (e instanceof NoPermissionException) {
            this.handleNoPermissionException(t, (NoPermissionException)e, alias, dmJmsContext, operation);
        } else if (e instanceof AuthenticationNotSupportedException) {
            this.handleAuthenticationNotSupportedException(t, (AuthenticationNotSupportedException)e, alias, dmJmsContext, operation);
        } else if (e instanceof AuthenticationException) {
            this.handleAuthenticationException(t, (AuthenticationException)e, alias, dmJmsContext, operation);
        } else if (e instanceof NameNotFoundException) {
            this.handleNameNotFoundException(t, (NameNotFoundException)e, alias, dmJmsContext, operation);
        } else if (e instanceof InvalidNameException) {
            this.handleInvalidNameException(t, (InvalidNameException)e, alias, dmJmsContext, operation);
        } else if (e instanceof NameAlreadyBoundException) {
            this.handleNameAlreadyBoundException(t, (NameAlreadyBoundException)e, alias, dmJmsContext, operation);
        } else if (e instanceof NoInitialContextException) {
            this.handleNoInitialContextException(t, (NoInitialContextException)e, alias, dmJmsContext, operation);
        } else if (e instanceof CommunicationException) {
            this.handleCommunicationException(t, (CommunicationException)e, alias, dmJmsContext, operation);
        } else if (e instanceof ContextNotEmptyException) {
            this.handleContextNotEmptyException(t, (ContextNotEmptyException)e, alias, dmJmsContext, operation);
        } else if (e instanceof OperationNotSupportedException) {
            this.handleOperationNotSupportedException(t, (OperationNotSupportedException)e, alias, dmJmsContext, operation);
        } else if (e instanceof NamingException) {
            this.handleNamingException(t, (NamingException)e, alias, dmJmsContext, operation);
        } else {
            this.handleUnexpected(t, e, alias, dmJmsContext, operation, false);
        }
    }

    private void handleFailedAuthentications(Trace t, NamingSecurityException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        String msgId = null;
        switch (operation) {
            case 0: 
            case 6: {
                msgId = "AMQ4416";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                msgId = "AMQ4431";
                break;
            }
            case 2: 
            case 7: {
                msgId = "AMQ4423";
                break;
            }
            case 3: {
                msgId = "AMQ4433";
                break;
            }
            case 8: {
                msgId = "AMQ4424";
                this.throwException(t, e, msgId);
                break;
            }
            default: {
                t.FFST(66, "JndiErrorHandler.handleFailedAuthentications", 0, 50017, 0, 0);
            }
        }
        String insert = dmJmsContext.getObjectName(t, alias);
        this.throwException(t, (Throwable)e, msgId, insert);
    }

    private void handleNoPermissionException(Trace t, NoPermissionException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        this.handleFailedAuthentications(t, e, alias, dmJmsContext, operation);
    }

    private void handleAuthenticationNotSupportedException(Trace t, AuthenticationNotSupportedException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        this.handleFailedAuthentications(t, e, alias, dmJmsContext, operation);
    }

    private void handleAuthenticationException(Trace t, AuthenticationException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        this.throwException(t, e, "AMQ4406");
    }

    private void handleNameNotFoundException(Trace t, NameNotFoundException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        String insert = dmJmsContext.getFullName(t);
        this.throwException(t, (Throwable)e, "AMQ4426", insert);
    }

    private void handleNoInitialContextException(Trace t, NoInitialContextException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        this.throwException(t, e, "AMQ4427");
    }

    private void handleInvalidNameException(Trace t, InvalidNameException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        this.throwException(t, e, "AMQ4421");
    }

    private void handleNameAlreadyBoundException(Trace t, NameAlreadyBoundException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        String insert = dmJmsContext.getObjectName(t, alias);
        this.throwException(t, (Throwable)e, "AMQ4415", insert);
    }

    private void handleCommunicationException(Trace t, CommunicationException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        String msgId = null;
        if (dmJmsContext instanceof DmJmsInitialContext) {
            String insert = ((DmJmsInitialContext)dmJmsContext).getFullName(t);
            msgId = "AMQ4422";
            Throwable rootCause = e.getRootCause();
            if (rootCause != null) {
                if (rootCause instanceof UnknownHostException) {
                    msgId = "AMQ4428";
                }
                if (rootCause instanceof ConnectException) {
                    msgId = "AMQ4429";
                }
                if (rootCause instanceof NoRouteToHostException) {
                    msgId = "AMQ4430";
                }
            }
            this.throwException(t, (Throwable)e, msgId, insert);
        } else {
            msgId = "AMQ4432";
            this.throwException(t, e, msgId);
        }
    }

    private void handleContextNotEmptyException(Trace t, ContextNotEmptyException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        String insert = dmJmsContext.getObjectName(t, alias);
        this.throwException(t, (Throwable)e, "AMQ4413", insert);
    }

    private void handleOperationNotSupportedException(Trace t, OperationNotSupportedException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        String insert = e.getMessage();
        this.throwException(t, (Throwable)e, "AMQ4450", insert);
    }

    private void handleNamingException(Trace t, NamingException e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        this.handleUnexpected(t, e, alias, dmJmsContext, operation);
    }

    public void handleUnexpected(Trace t, Throwable e, String alias, DmJmsAbstractContext dmJmsContext, int operation) throws DmCoreException {
        this.handleUnexpected(t, e, alias, dmJmsContext, operation, true);
    }

    private void handleUnexpected(Trace t, Throwable e, String alias, DmJmsAbstractContext dmJmsContext, int operation, boolean traceError) throws DmCoreException {
        if (traceError) {
            this.traceError(t, e, "JndiErrorHandler.handleUnexpected");
        }
        String insert0 = e.toString();
        String insert1 = operationNames[operation];
        String insert2 = dmJmsContext.getObjectName(t, alias);
        String[] inserts = new String[]{insert0, insert1, insert2};
        this.throwException(t, e, "AMQ4405", inserts);
    }

    private void throwException(Trace t, Throwable cause, String msgId) throws DmCoreException {
        DmCoreException dmCoreException = this.generateException(t, cause, msgId);
        throw dmCoreException;
    }

    private void throwException(Trace t, Throwable cause, String msgId, String insert) throws DmCoreException {
        String[] inserts = new String[]{insert};
        this.throwException(t, cause, msgId, inserts);
    }

    private void throwException(Trace t, Throwable cause, String msgId, String[] inserts) throws DmCoreException {
        DmCoreException dmCoreException = this.generateException(t, cause, msgId, inserts);
        throw dmCoreException;
    }

    private DmCoreException generateException(Trace t, Throwable cause, String msgId) {
        String message = CommonServices.getSystemMessage((Trace)t, (String)msgId);
        DmCoreException dmCoreException = this.generateException(t, cause, msgId, message);
        return dmCoreException;
    }

    private DmCoreException generateException(Trace t, Throwable cause, String msgId, String[] inserts) {
        String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
        DmCoreException dmCoreException = this.generateException(t, cause, msgId, message);
        return dmCoreException;
    }

    private DmCoreException generateException(Trace t, Throwable cause, String msgId, String message) {
        DmCoreException dmCoreException = null;
        dmCoreException = cause == null ? new DmCoreException(t, message, msgId, 50042, 0, 30) : new DmCoreException(t, message, cause, msgId, 50042, 0, 30);
        return dmCoreException;
    }

    public DmCoreException generateDamagedObjectException(Trace t, Throwable e, String alias, DmJmsAbstractContext dmJmsContext) {
        this.traceError(t, e, "JndiErrorHandler.generateDamagedObjectException");
        String insert0 = e.toString();
        String insert1 = dmJmsContext.getObjectName(t, alias);
        String insert2 = null;
        String msgId = null;
        Throwable rootCause = null;
        if (e instanceof NamingException) {
            rootCause = ((NamingException)e).getRootCause();
        }
        if (rootCause == null) {
            msgId = "AMQ4443";
        } else {
            insert2 = rootCause.getMessage();
            msgId = "AMQ4444";
        }
        String[] inserts = new String[]{insert0, insert1, insert2};
        DmCoreException dmCoreException = this.generateException(t, e, msgId, inserts);
        return dmCoreException;
    }

    public void throwInconsistentAttributesException(Trace t, Attr changingAttr, Attr conflictingAttr) throws DmCoreException {
        String msgId = "AMQ4436";
        AttrType changingAttrType = changingAttr.getAttrType();
        AttrType conflictingAttrType = conflictingAttr.getAttrType();
        Object changingValue = changingAttr.getNewValue(t);
        Object conflictingValue = conflictingAttr.getValue(t);
        String insert0 = changingAttrType.getDisplayTitle();
        String insert1 = changingAttrType.getDisplayGroup().toString(t);
        String insert2 = ((AbstractAttrTypeEnum)changingAttrType).getEnumeratedValue(t, (Number)changingValue);
        String insert3 = conflictingAttrType.getDisplayTitle();
        String insert4 = conflictingAttrType.getDisplayGroup().toString(t);
        String insert5 = ((AbstractAttrTypeEnum)conflictingAttrType).getEnumeratedValue(t, (Number)conflictingValue);
        String[] inserts = new String[]{insert0, insert1, insert2, insert3, insert4, insert5};
        this.throwException(t, null, msgId, inserts);
    }

    private void traceError(Trace t, Throwable throwable, String fid) {
        if (Trace.isTracing && t != null && throwable != null) {
            String stackTrace = t.getJavaStack(throwable);
            StringBuffer errorMessage = new StringBuffer("Exception caught in JMS Admin:\n" + throwable.toString() + "\n" + stackTrace);
            Throwable cause = throwable.getCause();
            if (cause != null) {
                String causeStackTrace = t.getJavaStack(cause);
                errorMessage.append("Caused by:\n" + cause.toString() + "\n" + causeStackTrace);
            }
            t.data(66, fid, errorMessage.toString());
        }
    }
}

