/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AbstractAttrTypeNumber;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrBoolean;
import com.ibm.mq.explorer.core.internal.attrs.AttrByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArrayEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.attrs.AttrStringArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeBitEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeBoolean;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeDateTime;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthWMQNameListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIPAddress;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeObject;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeURL;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeUnsignedInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeWMQName;
import com.ibm.mq.explorer.core.internal.attrs.AttrURL;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.TableFactory;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.jmsadmin.core.internal.base.JmsAdminDataModel;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsChangedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsChangingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsChildAddedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsDeletedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsDeletingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsRenameEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsRenamingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.handler.IObjectHandler;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.JndiErrorHandler;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.IJmsParameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Set;
import javax.naming.Context;
import org.osgi.framework.Bundle;

public abstract class DmJmsObject
extends Observable
implements IDmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/objects/DmJmsObject.java";
    public static final String NOT_FOUND = "[not_found]";
    public static final String NOT_DEFINED = "[not_defined]";
    public static final int TYPE_ALL = 2000;
    public static final int TYPE_NONE = 2001;
    public static final int TYPE_ABSTRACT_DESTINATION = 2002;
    public static final int TYPE_INITIAL_CONTEXT = 2003;
    public static final int TYPE_CONTEXT = 2004;
    public static final int TYPE_ABSTRACT_CONNECTION_FACTORY = 2005;
    public static final int TYPE_UNKNOWN = 2006;
    public static final int SUBTYPE_QUEUE = 2007;
    public static final int SUBTYPE_TOPIC = 2008;
    public static final int SUBTYPE_CONNECTION_FACTORY = 2009;
    public static final int SUBTYPE_QUEUE_CONNECTION_FACTORY = 2010;
    public static final int SUBTYPE_TOPIC_CONNECTION_FACTORY = 2011;
    public static final int SUBTYPE_XA_CONNECTION_FACTORY = 2012;
    public static final int SUBTYPE_XA_QUEUE_CONNECTION_FACTORY = 2013;
    public static final int SUBTYPE_XA_TOPIC_CONNECTION_FACTORY = 2014;
    public static final int SUBTYPE_NONE = 2015;
    public static final int SUBTYPE_ALL = 2016;
    public static final int SUBTYPE_CONTEXT = 2017;
    public static final int SUBTYPE_UNKNOWN = 2018;
    public static final int[] DESTINATION_SUBTYPES = new int[]{2007, 2008};
    public static final int[] CONNECTION_FACTORY_SUBTYPES = new int[]{2009, 2010, 2011, 2012, 2013, 2014};
    public static final int[] CONTEXT_SUBTYPES = new int[]{2017};
    public static final int[] UNKNOWN_SUBTYPES = new int[]{2018};
    public static final int MESSAGING_PROVIDER_UNKNOWN = -1;
    public static final int MESSAGING_PROVIDER_ALL = 0;
    public static final int MESSAGING_PROVIDER_MQ = 1;
    public static final int MESSAGING_PROVIDER_REALTIME = 2;
    public static final int MESSAGING_PROVIDER_MQ_AND_REALTIME = 3;
    private static final int SHIFT_BITS = 32;
    protected Object baseObject;
    private int objectType;
    private Hashtable attributes;
    protected HashMap attributesByType;
    protected Hashtable jmsParameters;
    protected DmJmsAbstractContext dmContext;

    public DmJmsObject(Trace t, Object aObject, int aObjectType, DmJmsAbstractContext aDmContext) {
        this.baseObject = aObject;
        this.objectType = aObjectType;
        this.dmContext = aDmContext;
        this.attributes = new Hashtable();
    }

    protected void createExtraAttributes(Trace t, String name, String alias, int type, int subtype) {
        this.createAttribute(t, null, 13100, 0, name);
        this.createAttribute(t, null, 13101, 0, alias);
        this.createAttribute(t, null, 13102, 0, type);
        this.createAttribute(t, null, 13103, 0, subtype);
        this.createAttribute(t, null, 13110, 0, this.getMessagingProviderName(t));
        if (this.baseObject != null) {
            this.createAttribute(t, null, 13107, 0, this.getClassName(t));
            this.createAttribute(t, null, 13108, 0, this.getFullClassName(t));
            this.createAttribute(t, null, 13109, 0, this.baseObject.toString());
        }
    }

    public abstract int getMessagingProvider(Trace var1);

    public String getMessagingProviderName(Trace t) {
        int provider = this.getMessagingProvider(t);
        String key = "JMS_MESSAGING_PROVIDER_UNKNOWN.title";
        switch (provider) {
            case 1: {
                key = "JMS_MESSAGING_PROVIDER_MQ.title";
                break;
            }
            case 2: {
                key = "JMS_MESSAGING_PROVIDER_REALTIME.title";
                break;
            }
            case 3: {
                key = "JMS_MESSAGING_PROVIDER_MQ_AND_REALTIME.title";
            }
        }
        return CoreServices.message.getMessage(t, key);
    }

    protected String getClassName(Trace t) {
        String fullClassName = this.getFullClassName(t);
        int index = fullClassName.lastIndexOf(46);
        if (index < 0) {
            return fullClassName;
        }
        return fullClassName.substring(index + 1);
    }

    protected String getFullClassName(Trace t) {
        return this.baseObject.getClass().getName();
    }

    public DmJmsInitialContext getDmInitialContext(Trace t) {
        DmJmsInitialContext result = null;
        DmJmsObject initial = this;
        DmJmsAbstractContext parent = this.dmContext;
        while (parent != null) {
            initial = parent;
            parent = parent.dmContext;
        }
        if (initial instanceof DmJmsInitialContext) {
            result = (DmJmsInitialContext)initial;
        } else {
            t.FFST(66, "DmJmsObject.getDmInitialContext", 0, 0, initial.getClass().toString());
        }
        return result;
    }

    public DmJmsAbstractContext getParent() {
        return this.dmContext;
    }

    public String getObjectName(Trace t, String name) {
        return this.getDmInitialContext(t).getObjectName(t, name);
    }

    public String getFullName(Trace t) {
        DmJmsAbstractContext parent = this.dmContext;
        String parentFullName = parent.getFullName(t);
        String name = this.getAttributeValue(t, 13100, 0);
        String seperator = "/";
        String fullName = null;
        fullName = parentFullName.endsWith(seperator) || name.startsWith(seperator) ? String.valueOf(parentFullName) + name : String.valueOf(parentFullName) + seperator + name;
        return fullName;
    }

    public String getAliasName(Trace t) {
        String alias = this.getAttributeValue(t, 13101, 0);
        return this.getAliasName(t, alias);
    }

    public String getAliasName(Trace t, String name) {
        return this.getDmInitialContext(t).getAliasName(t, name);
    }

    public Attr getAttributeInternal(Trace t, int id, int index) {
        return (Attr)this.attributes.get(new AttrKey(id, index));
    }

    public Attr getAttribute(Trace t, int id, int index) {
        return this.getAttributeInternal(t, id, index);
    }

    public String getAttributeValue(Trace t, int id, int index) {
        String retValue = NOT_FOUND;
        Attr a = this.getAttributeInternal(t, id, index);
        if (a != null) {
            retValue = a.toString(t);
        }
        if (Trace.isTracing) {
            t.data(66, "DmJmsObject.getAttributeValue", 300, "Attribute id = " + id + "." + index + ", value = " + retValue);
        }
        return retValue;
    }

    protected static AttrType getAttributeType(Trace t, HashMap hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsObject.getAttributeType", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return null;
        }
        AttrType at = (AttrType)hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsObject.getAttributeType", 900, "No attribute type in table for attribute id " + id);
            }
            return null;
        }
        int type = at.getAttributeType();
        if (Trace.isTracing) {
            t.data(66, "DmJmsObject.getAttributeType", 300, "Attribute id = " + id + ", type = " + type);
        }
        return at;
    }

    public int getRepeatingIndexes(Trace t, int id) {
        Attr a;
        int index = 1;
        while ((a = (Attr)this.attributes.get(new AttrKey(id, index))) != null) {
            ++index;
        }
        if (Trace.isTracing) {
            t.data(66, "DmJmsObject.getRepeatingIndexes", 300, "Attribute id = " + id + ", repeating indexes = " + (index - 1));
        }
        return index;
    }

    public int[] getAllAttributes(Trace t) {
        return this.getAllAttributes(t, false);
    }

    public int[] getAllAttributes(Trace t, boolean update) {
        int[] ids = this.getKnownAttributes(t);
        return ids;
    }

    protected int[] getKnownAttributes(Trace t) {
        int count = 0;
        Set k = this.attributes.keySet();
        for (AttrKey ak : k) {
            if (ak.getRepeatingIndex() != 0) continue;
            ++count;
        }
        int[] ids = new int[count];
        int index = 0;
        k = this.attributes.keySet();
        for (AttrKey ak : k) {
            if (ak.getRepeatingIndex() != 0) continue;
            ids[index] = ak.getAttributeID();
            ++index;
        }
        return ids;
    }

    public DmQueueManager getQueueManager() {
        return null;
    }

    protected static int[] getAllAttributesByType(Trace t, HashMap hm) {
        if (hm == null) {
            String message = "objectType not initialised";
            t.FFST(66, "DmJmsObject.getAllAttributesByType", 2, 0, message);
            return new int[0];
        }
        int[] ids = new int[hm.size()];
        int index = 0;
        Set k = hm.keySet();
        Iterator i = k.iterator();
        while (i.hasNext()) {
            ids[index] = (Integer)i.next();
            ++index;
        }
        return ids;
    }

    public void debug(Trace t) {
        Set k = this.attributes.keySet();
        for (AttrKey ak : k) {
            Attr a = (Attr)this.attributes.get(ak);
            a.debug(t);
        }
    }

    public boolean setAttributeValue(Trace t, Object job, int id, int index, Object value) {
        boolean result = true;
        AttrKey key = new AttrKey(id, index);
        Attr a = (Attr)this.attributes.get(key);
        if (a == null) {
            this.createAttribute(t, job, id, index, value);
        } else {
            a.setNewValue(t, value);
        }
        ArrayList list = (ArrayList)job;
        IJmsParameter parameter = (IJmsParameter)this.jmsParameters.get(id);
        list.add(parameter);
        return result;
    }

    public IJmsParameter getParameter(int id) {
        return (IJmsParameter)this.jmsParameters.get(id);
    }

    public boolean replaceAttributeValue(Trace t, int id, int index, Object value) {
        boolean result = true;
        AttrKey key = new AttrKey(id, index);
        Attr a = (Attr)this.attributes.get(key);
        if (a == null) {
            result = false;
        } else {
            a.setNewValue(t, value);
            IJmsParameter parameter = (IJmsParameter)this.jmsParameters.get(id);
            parameter.replaceValue(t, this);
            try {
                parameter.actionChange(t, this);
            }
            catch (DmCoreException dmCoreException) {
                result = false;
            }
        }
        return result;
    }

    public Attr createAttribute(Trace t, Object job, int id, int repeatIndex, Object value) {
        AttrString attr = null;
        AttrKey key = new AttrKey(id, repeatIndex);
        AttrType aType = (AttrType)this.attributesByType.get(id);
        if (aType == null) {
            String message = "Attribute type " + id + " has not been initialised for " + this.getClass().toString();
            t.FFST(66, "DmJmsObject.createAttribute", 2, 0, message);
            return null;
        }
        int type = aType.getAttributeType();
        switch (type) {
            case 1: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeInt)aType), (IDmObject)this);
                break;
            }
            case 2: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)aType, (IDmObject)this);
                break;
            }
            case 6: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeFixedLengthString)aType), (IDmObject)this);
                break;
            }
            case 4: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeRange)aType), (IDmObject)this);
                break;
            }
            case 29: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLong)aType), (IDmObject)this);
                break;
            }
            case 3: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeEnum)aType), (IDmObject)this);
                break;
            }
            case 5: {
                attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeIPAddress)aType), (IDmObject)this);
                break;
            }
            case 7: {
                attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeWMQName)aType), (IDmObject)this);
                break;
            }
            case 9: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeFixedLengthStringEnum)aType), (IDmObject)this);
                break;
            }
            case 11: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeEnumRange)aType), (IDmObject)this);
                break;
            }
            case 12: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLong)aType), (IDmObject)this);
                break;
            }
            case 10: {
                long l = ((Integer)value).intValue();
                l <<= 32;
                attr = new AttrLong(t, id, repeatIndex, l >>= 32, (AbstractAttrTypeNumber)((AttrTypeUnsignedInt)aType), (IDmObject)this);
                break;
            }
            case 13: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeFixedLengthStringEnumRange)aType), (IDmObject)this);
                break;
            }
            case 14: {
                attr = new AttrIntArray(t, id, repeatIndex, (int[])value, (AttrTypeIntArray)aType, (IDmObject)this);
                break;
            }
            case 18: {
                attr = new AttrIntArrayEnum(t, id, repeatIndex, (int[])value, (AttrTypeIntArrayEnum)aType, (IDmObject)this);
                break;
            }
            case 22: {
                attr = new AttrIntArrayEnumRange(t, id, repeatIndex, (int[])value, (AttrTypeIntArrayEnumRange)aType, (IDmObject)this);
                break;
            }
            case 15: {
                attr = new AttrStringArray(t, id, repeatIndex, (String[])value, (AttrTypeStringArray)aType, (IDmObject)this);
                break;
            }
            case 8: {
                attr = new AttrStringArray(t, id, repeatIndex, (String[])value, (AttrTypeStringArray)((AttrTypeFixedLengthStringListItem)aType), (IDmObject)this);
                break;
            }
            case 21: {
                attr = new AttrStringArray(t, id, repeatIndex, (String[])value, (AttrTypeStringArray)((AttrTypeFixedLengthWMQNameListItem)aType), (IDmObject)this);
                break;
            }
            case 16: {
                attr = new AttrByteArray(t, id, repeatIndex, (byte[])value, (AttrTypeByteArray)aType, (IDmObject)this);
                break;
            }
            case 19: {
                attr = new AttrByteArray(t, id, repeatIndex, (byte[])value, (AttrTypeByteArray)aType, (IDmObject)this);
                break;
            }
            case 20: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeBitEnum)aType), (IDmObject)this);
                break;
            }
            case 23: {
                attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeDateTime)aType), (IDmObject)this);
                break;
            }
            case 24: {
                attr = new AttrURL(t, id, repeatIndex, (URL)value, (AttrTypeURL)aType, (IDmObject)this);
                break;
            }
            case 25: {
                attr = new AttrBoolean(t, id, repeatIndex, ((Boolean)value).booleanValue(), (AttrTypeBoolean)aType, (IDmObject)this);
                break;
            }
            case 26: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeObject)aType), (IDmObject)this);
                break;
            }
            case 27: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLongEnum)aType), (IDmObject)this);
                break;
            }
            case 28: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLongEnumRange)aType), (IDmObject)this);
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(66, "DmJmsObject.createAttribute", 900, "Error - unknown attribute type (" + aType.getAttributeType() + ")");
                }
                t.FFST(66, "DmJmsObject.createAttribute", 0, 0, "Missing AttrType in switch statement");
            }
        }
        this.attributes.put(key, attr);
        return attr;
    }

    public boolean deleteAttribute(Trace t, Object job, int id, int index) {
        AttrKey key = new AttrKey(id, index);
        Object oldAttr = this.attributes.remove(key);
        return oldAttr != null;
    }

    public Object beginUpdate(Trace t) {
        return new ArrayList();
    }

    public void endUpdate(Trace t, Object job) {
    }

    public boolean isSystemObject(Trace t) {
        return false;
    }

    public boolean isSystemDefault(Trace t) {
        return false;
    }

    public boolean isEnumerationIdValid(Trace t, int attrId, int enumId) {
        return true;
    }

    public boolean isFilteringSupported(Trace t) {
        return false;
    }

    public int getObjectType(Trace t) {
        return this.objectType;
    }

    public int getObjectSubType(Trace t) {
        return 0;
    }

    public int[] getObjectSubTypes(Trace t) {
        return null;
    }

    public int getStatusType(Trace t) {
        return 0;
    }

    public String getParentName(Trace t) {
        return NOT_DEFINED;
    }

    public void initialize(Trace t) {
    }

    public void createParameterAttributes(Trace t) {
        IJmsParameter parameter = null;
        try {
            Enumeration en = this.jmsParameters.elements();
            while (en.hasMoreElements()) {
                parameter = (IJmsParameter)en.nextElement();
                parameter.createAttribute(t, this);
            }
        }
        catch (Throwable e) {
            String insert1 = e.getMessage();
            String insert2 = this.getClass().toString();
            String insert3 = parameter.getLongName();
            if (insert1 != null) {
                t.data(66, "DmJmsObject.createParameterAttributes", 800, insert1);
            }
            t.data(66, "DmJmsObject.createParameterAttributes", 800, insert2);
            t.data(66, "DmJmsObject.createParameterAttributes", 800, insert3);
            t.FFST(66, "DmJmsObject.createParameterAttributes", 1, 50010, parameter.getId(), 0, insert1, insert2, insert3);
        }
    }

    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        return this.updateObject(t, listener, (ArrayList)job, false);
    }

    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        return this.updateObject(t, listener, (ArrayList)job, true);
    }

    private int updateObject(Trace t, DmActionListener listener, ArrayList parameters, boolean changing) {
        int rc = 0;
        DmCoreException error = null;
        boolean change = changing;
        Collection jmsObjects = this.dmContext.getObjects(t);
        if (change && !jmsObjects.contains(this)) {
            rc = 2085;
            error = DmCoreException.create((Trace)t, (DmObject)this.getQueueManager(), (int)0, (int)rc, (int)2);
            change = false;
        }
        if (change) {
            DmJmsChangingEvent changingAddedEvent = new DmJmsChangingEvent(this);
            this.setChanged();
            this.notifyObservers(changingAddedEvent);
        }
        try {
            try {
                if (error == null) {
                    this.validateParameters(t, parameters);
                    this.changeParameters(t, parameters);
                    if (change) {
                        this.dmContext.rebind(t, this);
                    } else {
                        this.dmContext.bind(t, this);
                    }
                    this.replaceValues(t, parameters);
                }
            }
            catch (DmCoreException e) {
                Object event;
                rc = e.getReasonCode();
                error = e;
                this.restoreValues(t, parameters);
                if (listener != null) {
                    event = new DmActionEvent((Object)this, 0, rc, error);
                    listener.dmActionDone((DmActionEvent)event);
                }
                event = null;
                if (change) {
                    event = new DmJmsChangedEvent(this);
                    ((DmJmsEvent)event).setError((Exception)((Object)error));
                    this.setChanged();
                    this.notifyObservers(event);
                } else if (error == null) {
                    event = new DmJmsChildAddedEvent(this.dmContext, this);
                    this.dmContext.setChanged();
                    this.dmContext.notifyObservers(event);
                }
            }
        }
        finally {
            Object event;
            if (listener != null) {
                event = new DmActionEvent((Object)this, 0, rc, error);
                listener.dmActionDone((DmActionEvent)event);
            }
            event = null;
            if (change) {
                event = new DmJmsChangedEvent(this);
                ((DmJmsEvent)event).setError((Exception)((Object)error));
                this.setChanged();
                this.notifyObservers(event);
            } else if (error == null) {
                event = new DmJmsChildAddedEvent(this.dmContext, this);
                this.dmContext.setChanged();
                this.dmContext.notifyObservers(event);
            }
        }
        return 0;
    }

    private void validateParameters(Trace t, ArrayList parameters) throws DmCoreException {
        for (IJmsParameter parameter : parameters) {
            parameter.validate(t, this);
        }
        this.performCrossAttributeValidation(t, parameters);
    }

    private void changeParameters(Trace t, ArrayList parameters) throws DmCoreException {
        for (IJmsParameter parameter : parameters) {
            parameter.actionChange(t, this);
        }
    }

    private void restoreValues(Trace t, Object job) {
        ArrayList list = (ArrayList)job;
        for (IJmsParameter parameter : list) {
            try {
                parameter.actionRestore(t, this);
            }
            catch (DmCoreException e2) {
                t.data(66, "DmJmsObject.restoreValues", Integer.MIN_VALUE, e2.getMessage());
            }
        }
    }

    private void replaceValues(Trace t, Object job) {
        ArrayList list = (ArrayList)job;
        for (IJmsParameter parameter : list) {
            parameter.replaceValue(t, this);
        }
    }

    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        DmCoreException dmCoreException = null;
        DmJmsDeletingEvent deletingEvent = new DmJmsDeletingEvent(this);
        this.setChanged();
        this.notifyObservers(deletingEvent);
        try {
            try {
                this.remove(t);
            }
            catch (DmCoreException e) {
                rc = e.getReasonCode();
                dmCoreException = e;
                if (listener != null) {
                    new DmActionEvent((Object)this, 0, rc, dmCoreException);
                }
                DmJmsDeletedEvent deletedEvent = new DmJmsDeletedEvent(this);
                deletedEvent.setError((Exception)((Object)dmCoreException));
                this.setChanged();
                this.notifyObservers(deletedEvent);
            }
        }
        finally {
            if (listener != null) {
                new DmActionEvent((Object)this, 0, rc, dmCoreException);
            }
            DmJmsDeletedEvent deletedEvent = new DmJmsDeletedEvent(this);
            deletedEvent.setError((Exception)((Object)dmCoreException));
            this.setChanged();
            this.notifyObservers(deletedEvent);
        }
        return 0;
    }

    protected static String getClassName(String className) {
        if (className.lastIndexOf(46) > 0) {
            return className.substring(className.lastIndexOf(46) + 1);
        }
        return className;
    }

    protected static HashMap initAllAttrTypeTable(Trace t, String name, HashMap hm, Bundle bund) {
        if (hm != null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsObject.initAllAttrTypeTable", 300, "allAttributesByType table already initialized");
            }
            return hm;
        }
        hm = TableFactory.getHashMap((Trace)t, (String)name, (Bundle)bund);
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsObject.initAllAttrTypeTable", 900, "Error loading allAttributesByType table for " + name);
            }
            return null;
        }
        return hm;
    }

    protected static String getAttributeTitle(Trace t, HashMap hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsObject.getAttributeTitle", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return null;
        }
        AttrType at = (AttrType)hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsObject.getAttributeTitle", 900, "No attribute type in table for attribute id " + id);
            }
            return null;
        }
        String s = at.getDisplayTitle();
        if (Trace.isTracing) {
            t.data(66, "DmJmsObject.getAttributeTitle", 300, "Attribute id = " + id + ", title = " + s);
        }
        return s;
    }

    protected static int[] getDisplayColumnSequence(Trace t, HashMap hm, int[] ids, boolean zOS) {
        int[] retValue = new int[ids.length];
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsObject.getDisplayColumnSequence", 900, "<All> table has not been created");
            }
            return null;
        }
        if (Trace.isTracing) {
            if (zOS) {
                t.data(66, "DmJmsObject.getDisplayColumnSequence", 300, "Getting the zOS display column sequence");
            } else {
                t.data(66, "DmJmsObject.getDisplayColumnSequence", 300, "Getting the distributed display column sequence");
            }
        }
        int i = 0;
        while (i < ids.length) {
            AttrType at = (AttrType)hm.get(ids[i]);
            if (at == null) {
                retValue[i] = -1;
                if (Trace.isTracing) {
                    t.data(66, "DmJmsObject.getDisplayColumnSequence", 900, "No attribute type in table for attribute id " + ids[i]);
                }
            } else {
                retValue[i] = zOS ? at.getZosDisplayColumnSequence() : at.getDisplayColumnSequence();
                if (Trace.isTracing) {
                    t.data(66, "DmJmsObject.getDisplayColumnSequence", 300, "Attribute id = " + ids[i] + ", display sequence = " + retValue[i]);
                }
            }
            ++i;
        }
        return retValue;
    }

    protected static boolean isAttributeRepeating(Trace t, HashMap hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsObject.isAttributeRepeating", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return false;
        }
        AttrType at = (AttrType)hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsObject.isAttributeRepeating", 900, "No attribute type in table for attribute id " + id);
            }
            return false;
        }
        boolean repeating = at.isRepeating();
        if (Trace.isTracing) {
            t.data(66, "DmJmsObject.isAttributeRepeating", 300, "Attribute id = " + id + ", repeating = " + Boolean.toString(repeating));
        }
        return repeating;
    }

    protected String getAttrValueCollection(Collection list) {
        return null;
    }

    protected String getAttrValueByteArray(byte[] array) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            byte item = array[i];
            buffer.append(item);
            buffer.append(" ");
            ++i;
        }
        return buffer.toString();
    }

    protected Integer getAttrValueLong(long value) {
        return (int)value;
    }

    protected Integer getAttrValueBoolean(boolean value) {
        return value ? 1 : 0;
    }

    protected Integer getAttrValueInteger(int value) {
        return value;
    }

    protected String getAttrValueString(String value) {
        if (value == null) {
            value = "";
        }
        return value;
    }

    public Object getObject() {
        return this.baseObject;
    }

    public void rename(Trace t, String newName) throws DmCoreException {
        DmJmsRenamingEvent renamingEvent = new DmJmsRenamingEvent(this, newName);
        this.setChanged();
        this.notifyObservers(renamingEvent);
        DmJmsObject newDmJmsObject = null;
        Exception error = null;
        Object object = this.getObject();
        Attr attr = this.getAttributeInternal(t, 13100, 0);
        String oldName = (String)attr.getValue(t);
        String oldAlias = this.getAliasName(t, oldName);
        String newAlias = this.getAliasName(t, newName);
        Context context = (Context)this.dmContext.getObject();
        Thread currentThread = Thread.currentThread();
        ClassLoader previousClassLoader = currentThread.getContextClassLoader();
        ClassLoader newClassLoader = JmsAdminDataModel.getClassLoader();
        currentThread.setContextClassLoader(newClassLoader);
        try {
            try {
                context.rename(oldAlias, newAlias);
                object = context.lookup(newAlias);
            }
            catch (Exception e) {
                error = e;
                DmJmsAbstractContext dmJmsContext = this.getParent();
                JndiErrorHandler.getHandler().handleException(t, e, newAlias, dmJmsContext, 3);
                currentThread.setContextClassLoader(previousClassLoader);
                if (error == null) {
                    IObjectHandler handler = this.dmContext.getObjectHandler(t, object);
                    handler.removeFromSnapshot(this.dmContext, oldAlias);
                    newDmJmsObject = handler.addToSnapshot(this.dmContext, newAlias, object);
                }
                DmJmsRenameEvent renameEvent = new DmJmsRenameEvent(this, newDmJmsObject);
                renameEvent.setError(error);
                this.setChanged();
                this.notifyObservers(renameEvent);
            }
        }
        finally {
            currentThread.setContextClassLoader(previousClassLoader);
            if (error == null) {
                IObjectHandler handler = this.dmContext.getObjectHandler(t, object);
                handler.removeFromSnapshot(this.dmContext, oldAlias);
                newDmJmsObject = handler.addToSnapshot(this.dmContext, newAlias, object);
            }
            DmJmsRenameEvent renameEvent = new DmJmsRenameEvent(this, newDmJmsObject);
            renameEvent.setError(error);
            this.setChanged();
            this.notifyObservers(renameEvent);
        }
    }

    public void remove(Trace t) throws DmCoreException {
        DmJmsDeletingEvent deletingEvent = new DmJmsDeletingEvent(this);
        this.setChanged();
        this.notifyObservers(deletingEvent);
        String alias = this.getAttributeValue(t, 13101, 0);
        Context context = (Context)this.dmContext.getObject();
        Exception error = null;
        try {
            try {
                context.unbind(alias);
            }
            catch (Exception e) {
                error = e;
                DmJmsAbstractContext dmJmsContext = this.getParent();
                JndiErrorHandler.getHandler().handleException(t, e, alias, dmJmsContext, 2);
                if (error == null) {
                    IObjectHandler handler = this.dmContext.getObjectHandler(t, context);
                    handler.removeFromSnapshot(this.dmContext, alias);
                }
                DmJmsDeletedEvent deletedEvent = new DmJmsDeletedEvent(this);
                deletedEvent.setError(error);
                this.setChanged();
                this.notifyObservers(deletedEvent);
            }
        }
        finally {
            if (error == null) {
                IObjectHandler handler = this.dmContext.getObjectHandler(t, context);
                handler.removeFromSnapshot(this.dmContext, alias);
            }
            DmJmsDeletedEvent deletedEvent = new DmJmsDeletedEvent(this);
            deletedEvent.setError(error);
            this.setChanged();
            this.notifyObservers(deletedEvent);
        }
    }

    @Override
    public void setChanged() {
        super.setChanged();
    }

    public void performCrossAttributeValidation(Trace t, ArrayList parameters) throws DmCoreException {
    }

    public static HashMap getAllAttributesForType(Trace t, Hashtable parameters) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Enumeration en = parameters.elements();
        while (en.hasMoreElements()) {
            IJmsParameter parameter = (IJmsParameter)en.nextElement();
            int id = parameter.getId();
            list.add(id);
        }
        list.add(13100);
        list.add(13101);
        list.add(13102);
        list.add(13103);
        list.add(13110);
        list.add(13107);
        list.add(13108);
        list.add(13109);
        HashMap lookup = new HashMap();
        int i = 0;
        while (i < list.size()) {
            Object integer = list.get(i);
            lookup.put(integer, integer);
            ++i;
        }
        return lookup;
    }

    public boolean equals(Object object) {
        Trace t = Trace.getDefault();
        boolean result = false;
        if (object != null && object instanceof DmJmsObject) {
            String fullName = this.getFullName(t);
            DmJmsInitialContext initialContext = this.getDmInitialContext(t);
            String initialContextName = initialContext.getTitle();
            DmJmsObject comparisonObject = (DmJmsObject)object;
            String comparisonFullName = comparisonObject.getFullName(t);
            DmJmsInitialContext comparisonInitialContext = comparisonObject.getDmInitialContext(t);
            String comparisonInitialContextName = comparisonInitialContext.getTitle();
            if (fullName.equals(comparisonFullName) && initialContextName.equals(comparisonInitialContextName)) {
                result = true;
            }
        }
        return result;
    }

    public void initializeWithDefaults(Trace t) {
    }

    public int getAttributeDifferenceCount(Trace t, IDmObject dmObject2) {
        int countChanged = 0;
        int[] attrIds1 = this.getAllAttributes(t);
        int i = 0;
        while (i < attrIds1.length) {
            Attr attr1 = null;
            Attr attr2 = null;
            String attrValue1 = null;
            String attrValue2 = null;
            boolean attrPresent1 = true;
            boolean attrPresent2 = true;
            boolean repeating = false;
            int index = 0;
            do {
                attr1 = this.getAttribute(t, attrIds1[i], index);
                attr2 = dmObject2.getAttribute(t, attrIds1[i], index);
                attrPresent1 = true;
                attrPresent2 = true;
                if (attr1 != null) {
                    attrValue1 = attr1.toString(t);
                } else {
                    attrPresent1 = false;
                }
                if (attr2 != null) {
                    attrValue2 = attr2.toString(t);
                } else {
                    attrPresent2 = false;
                }
                if (index == 0) {
                    repeating = attr1.getAttrType().isRepeating();
                }
                ++index;
                if (attrPresent1 == attrPresent2 && (!attrPresent1 || !attrPresent2 || attrValue1 == null || attrValue2 == null || attrValue1.compareTo(attrValue2) == 0)) continue;
                ++countChanged;
                break;
            } while (repeating && attrPresent1 && attrPresent2);
            ++i;
        }
        if (Trace.isTracing) {
            t.data(66, "DmJmsObject.getAttributeDifferenceCount", 300, "There are " + countChanged + " different attributes between " + this.getTitle() + " and " + dmObject2.getTitle());
        }
        return countChanged;
    }

    public int getNameAttributeId() {
        return 13100;
    }
}

