/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.objects;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.jmsadmin.core.internal.base.JmsAdminDataModel;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsReopenedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsReopeningEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.JndiErrorHandler;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.directory.InitialDirContext;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;

public class DmJmsInitialContext
extends DmJmsAbstractContext {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/objects/DmJmsInitialContext.java";
    private static HashMap allAttributesByType = null;
    public static final String ROOT_KEY = "JndiInitialContext";
    private static final String NAME_KEY = "name";
    private static final String REQUIRED_LIBRARY_LOCATIONS_KEY_PREFIX = "requiredLibraryLocation_";
    public static final String LINESEPERATOR = System.getProperty("line.separator");
    public static final String USE_INITIAL_DIR_CONTEXT = "USE_INITIAL_DIR_CONTEXT";
    public static final String TRUE = "TRUE";
    public static final String NAME_PREFIX = "NAME_PREFIX";
    public static final String NAME_READABILITY_MARKER = "NAME_READABILITY_MARKER";
    public static final String AUTORECONNECT = "AUTORECONNECT";
    private Hashtable<String, String> environment;
    private boolean useInitialDirContext;
    private ClassLoader classLoader;

    public DmJmsInitialContext(Trace t, Hashtable<String, String> aEnvironment, String name, URL[] requiredLibraryLocations) {
        super(t, null, 2003, null);
        String providerUrl;
        String authentication;
        this.environment = aEnvironment;
        boolean hasRequiredLibraries = requiredLibraryLocations != null && requiredLibraryLocations.length > 0;
        ClassLoader defaultClassLoader = JmsAdminDataModel.getClassLoader();
        this.classLoader = hasRequiredLibraries ? new URLClassLoader(requiredLibraryLocations, defaultClassLoader) : defaultClassLoader;
        if (this.attributesByType == null) {
            this.attributesByType = allAttributesByType;
        }
        JmsAdminDataModel datamodel = JmsAdminDataModel.getDataModel();
        this.objectHandlers = datamodel.getObjectHandlers(t);
        String initial = this.environment.get("java.naming.factory.initial");
        if (initial == null) {
            initial = "";
        }
        if ((authentication = this.environment.get("java.naming.security.authentication")) == null) {
            authentication = "";
        }
        if ((providerUrl = this.environment.get("java.naming.provider.url")) == null) {
            providerUrl = "";
        }
        providerUrl = Utilities.decodeUrl(t, providerUrl);
        String status = CoreServices.message.getMessage(t, "JMS_CONTEXT_STATUS_DISCONECTED.title");
        this.useInitialDirContext = false;
        String string = this.environment.get(USE_INITIAL_DIR_CONTEXT);
        if (string != null && string.toUpperCase().equals(TRUE)) {
            this.useInitialDirContext = true;
        }
        String key = this.useInitialDirContext ? "Common.YES" : "Common.NO";
        String stringUseInitialDirContext = CoreServices.message.getMessage(t, String.valueOf(key) + ".title");
        String namePrefix = this.environment.get(NAME_PREFIX);
        if (namePrefix == null) {
            namePrefix = "";
        }
        this.createExtraAttributes(t, name, "", 2003, 2017);
        this.createAttribute(t, null, 13111, 0, status);
        this.createAttribute(t, null, 13104, 0, providerUrl);
        this.createAttribute(t, null, 13105, 0, initial);
        this.createAttribute(t, null, 13106, 0, authentication);
        this.createAttribute(t, null, 13112, 0, namePrefix);
        this.createAttribute(t, null, 13113, 0, stringUseInitialDirContext);
        if (hasRequiredLibraries && requiredLibraryLocations != null) {
            String[] requiredLibraryLocationStrings = new String[requiredLibraryLocations.length];
            int i = 0;
            while (i < requiredLibraryLocations.length) {
                requiredLibraryLocationStrings[i] = requiredLibraryLocations[i].toString();
                ++i;
            }
            this.createAttribute(t, null, 13114, 0, requiredLibraryLocationStrings);
        }
    }

    public DmJmsInitialContext(Trace t, Hashtable<String, String> aEnvironment, String name) {
        this(t, aEnvironment, name, null);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DmJmsInitialContext)) {
            return false;
        }
        return ((DmJmsInitialContext)object).getTitle().equals(this.getTitle());
    }

    @Override
    public void open(Trace t) throws DmCoreException {
        this.openInitialContext_internal(t);
        super.open(t);
    }

    private void openInitialContext_internal(Trace t) throws DmCoreException {
        InitialContext context;
        block8: {
            String provider = this.environment.get("java.naming.provider.url");
            if (provider == null) {
                String msgId = "AMQ4407";
                String message = CommonServices.getSystemMessage((Trace)t, (String)msgId);
                DmCoreException e1 = new DmCoreException(t, message, msgId, 0, 0, 30);
                t.FFST(66, "DmJmsInitialContext.openInitialContext_internal", 0, 50024, 0, 0, null, null, null);
                throw e1;
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader previousClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.classLoader);
            context = null;
            String alias = this.getTitle();
            try {
                context = this.useInitialDirContext ? new InitialDirContext(this.environment) : new InitialContext(this.environment);
            }
            catch (Exception e) {
                JndiErrorHandler.getHandler().handleException(t, e, alias, this, 8);
                currentThread.setContextClassLoader(previousClassLoader);
                break block8;
            }
            catch (LinkageError err) {
                try {
                    JndiErrorHandler.getHandler().handleUnexpected(t, err, alias, this, 8);
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    currentThread.setContextClassLoader(previousClassLoader);
                }
            }
            currentThread.setContextClassLoader(previousClassLoader);
        }
        this.baseObject = context;
        String status = CoreServices.message.getMessage(t, "JMS_CONTEXT_STATUS_CONECTED.title");
        Attr attr = this.getAttribute(t, 13111, 0);
        attr.replaceValue(t, (Object)status);
    }

    @Override
    public void reopen(Trace t) throws DmCoreException {
        DmJmsReopeningEvent reopeningEvent = new DmJmsReopeningEvent(this);
        this.setChanged();
        this.notifyObservers(reopeningEvent);
        DmCoreException error = null;
        try {
            try {
                this.closeInitialContext_internal(t);
                this.closeAbstractContext_internal(t);
                this.openInitialContext_internal(t);
                DmCoreException exception = this.openAbstractContext_internal(t);
                if (exception != null) {
                    throw exception;
                }
            }
            catch (DmCoreException e) {
                error = e;
                throw e;
            }
        }
        finally {
            DmJmsReopenedEvent reopenedEvent = new DmJmsReopenedEvent(this);
            reopenedEvent.setError((Exception)((Object)error));
            this.setChanged();
            this.notifyObservers(reopenedEvent);
        }
    }

    @Override
    public void close(Trace t) throws DmCoreException {
        this.closeInitialContext_internal(t);
        super.close(t);
    }

    private void closeInitialContext_internal(Trace t) {
        String status = CoreServices.message.getMessage(t, "JMS_CONTEXT_STATUS_DISCONECTED.title");
        Attr attr = this.getAttribute(t, 13111, 0);
        attr.replaceValue(t, (Object)status);
    }

    @Override
    public boolean useInitialDirContext(Trace t) {
        return this.useInitialDirContext;
    }

    public boolean needsAuthentication() {
        boolean result = true;
        String authentication = this.environment.get("java.naming.security.authentication");
        if ("none".equalsIgnoreCase(authentication)) {
            result = false;
        }
        return result;
    }

    public void setUserDN(Trace t, String userDN) {
        this.environment.put("java.naming.security.principal", userDN);
        JmsAdminDataModel dataModel = JmsAdminDataModel.getDataModel();
        try {
            dataModel.save(t);
        }
        catch (DmCoreException e) {
            t.FFST(66, "DmJmsInitialContext.setUserDN", 0, 0, e.getMessage());
        }
    }

    public String getUserDN() {
        return this.environment.get("java.naming.security.principal");
    }

    public void setPassword(String password) {
        this.environment.put("java.naming.security.credentials", password);
    }

    public String getPassword() {
        return this.environment.get("java.naming.security.credentials");
    }

    @Override
    public String getObjectName(Trace t, String alias) {
        String name = alias;
        String namePrefix = this.environment.get(NAME_PREFIX);
        if (namePrefix != null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsInitialContext.getObjectName", Integer.MIN_VALUE, "namePrefix = " + namePrefix);
            }
            int length = namePrefix.length();
            if (alias.startsWith(namePrefix) || alias.startsWith(namePrefix.toUpperCase())) {
                name = alias.substring(length);
            }
        }
        if (Trace.isTracing) {
            t.data(66, "DmJmsInitialContext.getObjectName", Integer.MIN_VALUE, "name = " + name);
        }
        return name;
    }

    @Override
    public String getAliasName(Trace t, String name) {
        String saved_name = name;
        String alias = name;
        String namePrefix = this.environment.get(NAME_PREFIX);
        if (namePrefix != null && !name.startsWith(namePrefix)) {
            if (name.startsWith(namePrefix.toUpperCase())) {
                saved_name = name.substring(namePrefix.length());
            }
            alias = String.valueOf(namePrefix) + saved_name;
        }
        return alias;
    }

    public InitialDirContext getInitialContext() {
        return (InitialDirContext)this.baseObject;
    }

    public Hashtable getEnvironment() {
        return this.environment;
    }

    public void serializeXml(Trace t, XMLMemento rootWrite) {
        ArrayList requiredLibraryLocations;
        String name = this.getAttributeValue(t, 13100, 0);
        IMemento msgWrite = rootWrite.createChild(ROOT_KEY);
        this.writeMementoKeyValue(msgWrite, NAME_KEY, name);
        Enumeration<String> en = this.environment.keys();
        while (en.hasMoreElements()) {
            String objKey = en.nextElement();
            String objValue = this.environment.get(objKey);
            if ("java.naming.security.credentials".equals(objKey)) continue;
            this.writeMementoKeyValue(msgWrite, objKey.toString(), objValue.toString());
        }
        Attr requiredLibraryLocationsAttr = this.getAttribute(t, 13114, 0);
        if (requiredLibraryLocationsAttr != null && (requiredLibraryLocations = (ArrayList)requiredLibraryLocationsAttr.getValue(t)) != null) {
            int i = 0;
            while (i < requiredLibraryLocations.size()) {
                this.writeMementoKeyValue(msgWrite, REQUIRED_LIBRARY_LOCATIONS_KEY_PREFIX + i, requiredLibraryLocations.get(i).toString());
                ++i;
            }
        }
    }

    private void writeMementoKeyValue(IMemento msgWrite, String key, String value) {
        if (value != null) {
            msgWrite.putString(key, value);
        }
    }

    public static DmJmsInitialContext startElement(Trace t, String qName, Attributes atts) throws CommonServicesException {
        DmJmsInitialContext ctx = null;
        String strName = null;
        ArrayList<URL> requiredLibraryLocations = new ArrayList<URL>();
        Hashtable<String, String> environment = new Hashtable<String, String>();
        int length = atts.getLength();
        int i = 0;
        while (i < length) {
            String localName = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (NAME_KEY.equals(localName)) {
                strName = value;
            } else if (localName.startsWith(REQUIRED_LIBRARY_LOCATIONS_KEY_PREFIX)) {
                try {
                    URL requiredLibraryLocationURL = new URL(value);
                    requiredLibraryLocations.add(requiredLibraryLocationURL);
                }
                catch (MalformedURLException e) {
                    String msgId = "AMQ4449";
                    String message = CommonServices.getSystemMessage((Trace)t, (String)msgId);
                    message = Message.format((String)message, (String)value);
                    CommonServicesException e2 = new CommonServicesException(t, message, (Throwable)e, msgId, 50005, 50005, 30);
                    throw e2;
                }
            } else {
                environment.put(localName, value);
            }
            ++i;
        }
        if (strName == null) {
            String msgId = "AMQ4408";
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId);
            CommonServicesException e1 = new CommonServicesException(t, message, msgId, 0, 0, 30);
            t.FFST(66, "DmJmsInitialContext.startElement", 1, 0, 0, 0, null, null, null);
            throw e1;
        }
        if (requiredLibraryLocations.size() == 0) {
            ctx = new DmJmsInitialContext(t, environment, strName);
        } else {
            URL[] requiredLibraryLocationURLs = new URL[requiredLibraryLocations.size()];
            requiredLibraryLocationURLs = requiredLibraryLocations.toArray(requiredLibraryLocationURLs);
            ctx = new DmJmsInitialContext(t, environment, strName, requiredLibraryLocationURLs);
        }
        if (Trace.isTracing) {
            t.data(66, "DmJmsInitialContext.startElement", 300, "strName = " + strName);
        }
        return ctx;
    }

    public void setAutoReconnect(Trace t, boolean value) {
        this.environment.put(AUTORECONNECT, Boolean.toString(value));
        JmsAdminDataModel dataModel = JmsAdminDataModel.getDataModel();
        try {
            dataModel.save(t);
        }
        catch (DmCoreException e) {
            t.FFST(66, "DmJmsInitialContext.setAutoReconnect", 0, 0, e.getMessage());
        }
    }

    public boolean getAutoReconnect(Trace t) {
        String value = this.environment.get(AUTORECONNECT);
        boolean result = false;
        if (value != null && "true".equalsIgnoreCase(value)) {
            result = true;
        }
        if (Trace.isTracing) {
            t.data(66, "DmJmsInitialContext.getAutoReconnect", 300, "autoReconnect = " + Boolean.toString(result));
        }
        return result;
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmJmsInitialContext.getAllAttributesByType(t, allAttributesByType);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        if ((allAttributesByType = DmJmsInitialContext.initAllAttrTypeTable(t, "DmJmsInitialContext", allAttributesByType, bund)) == null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsInitialContext.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmJmsInitialContext.getAttributeTitle(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmJmsInitialContext.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmJmsInitialContext.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmJmsInitialContext.getAttributeType(t, allAttributesByType, id);
    }

    public String getProviderUrl() {
        return this.environment.get("java.naming.provider.url");
    }

    @Override
    public String getFullName(Trace t) {
        String providerUrl = this.getProviderUrl();
        providerUrl = Utilities.decodeUrl(t, providerUrl);
        return providerUrl;
    }

    public ClassLoader getClassLoader(Trace t) {
        return this.classLoader;
    }
}

