/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.jmsadmin.core.internal.base.JmsAdminDataModel;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsDeletedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsDeletingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.handler.IObjectHandler;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.JndiErrorHandler;
import java.util.HashMap;
import javax.naming.Context;
import org.osgi.framework.Bundle;

public class DmJmsContext
extends DmJmsAbstractContext {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/objects/DmJmsContext.java";
    private static HashMap allAttributesByType = null;

    public DmJmsContext(Trace t, String name, Context aContext, DmJmsAbstractContext dmContext) {
        super(t, aContext, 2004, dmContext);
        if (this.attributesByType == null) {
            this.attributesByType = allAttributesByType;
        }
        JmsAdminDataModel datamodel = JmsAdminDataModel.getDataModel();
        this.objectHandlers = datamodel.getObjectHandlers(t);
        String alias = dmContext.getAliasName(t, name);
        this.createExtraAttributes(t, name, alias, 2004, 2017);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmJmsContext.getAllAttributesByType(t, allAttributesByType);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        if ((allAttributesByType = DmJmsContext.initAllAttrTypeTable(t, "DmJmsContext", allAttributesByType, bund)) == null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsContext.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmJmsContext.getAttributeTitle(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmJmsContext.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmJmsContext.isAttributeRepeating(t, allAttributesByType, id);
    }

    @Override
    public void remove(Trace t) throws DmCoreException {
        DmJmsDeletingEvent deletingEvent = new DmJmsDeletingEvent(this);
        this.setChanged();
        this.notifyObservers(deletingEvent);
        String alias = this.getAttributeValue(t, 13101, 0);
        Object object = this.getObject();
        Context context = (Context)this.dmContext.getObject();
        Exception error = null;
        try {
            try {
                context.destroySubcontext(alias);
            }
            catch (Exception e) {
                error = e;
                JndiErrorHandler.getHandler().handleException(t, e, alias, this, 7);
                if (error == null) {
                    IObjectHandler handler = this.dmContext.getObjectHandler(t, object);
                    handler.removeFromSnapshot(this.dmContext, alias);
                }
                DmJmsDeletedEvent deletedEvent = new DmJmsDeletedEvent(this);
                deletedEvent.setError(error);
                this.setChanged();
                this.notifyObservers(deletedEvent);
            }
        }
        finally {
            if (error == null) {
                IObjectHandler handler = this.dmContext.getObjectHandler(t, object);
                handler.removeFromSnapshot(this.dmContext, alias);
            }
            DmJmsDeletedEvent deletedEvent = new DmJmsDeletedEvent(this);
            deletedEvent.setError(error);
            this.setChanged();
            this.notifyObservers(deletedEvent);
        }
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmJmsContext.getAttributeType(t, allAttributesByType, id);
    }

    public String toString() {
        return this.getTitle();
    }
}

