/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.base.JmsAdminDataModel;
import com.ibm.mq.explorer.jmsadmin.core.internal.base.PatternMatcher;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsChildAddedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsClosedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsClosingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsOpenedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsOpeningEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsReopenedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsReopeningEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.handler.IObjectHandler;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractDestination;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsQueue;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsQueueConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsTopic;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsTopicConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsUnknown;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsXAConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsXAQueueConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsXATopicConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.JndiErrorHandler;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQXAConnectionFactory;
import com.ibm.mq.jms.MQXAQueueConnectionFactory;
import com.ibm.mq.jms.MQXATopicConnectionFactory;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;

public abstract class DmJmsAbstractContext
extends DmJmsObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/objects/DmJmsAbstractContext.java";
    private static final String OBJECT_CLASS = "objectclass";
    private static final String JAVA_CONTAINER = "javaContainer";
    private static final String COMMON_NAME = "cn";
    private static final String TOP = "top";
    protected Hashtable objectHandlers;
    private Hashtable dmObjects = new Hashtable();
    private boolean isOpen;

    protected DmJmsAbstractContext(Trace t, Object object, int type, DmJmsAbstractContext dmContext) {
        super(t, object, type, dmContext);
    }

    public void open(Trace t) throws DmCoreException {
        if (this.isOpen) {
            String msgId = "AMQ4419";
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId);
            DmCoreException e2 = new DmCoreException(t, message, msgId, 50024, 0, 30);
            t.FFST(66, "DmJmsAbstractContext.open", 0, 0, message);
            throw e2;
        }
        DmJmsOpeningEvent openingEvent = new DmJmsOpeningEvent(this);
        this.setChanged();
        this.notifyObservers(openingEvent);
        DmCoreException error = null;
        try {
            try {
                DmCoreException exception = this.openAbstractContext_internal(t);
                this.isOpen = true;
                if (exception != null) {
                    throw exception;
                }
            }
            catch (DmCoreException e) {
                error = e;
                throw e;
            }
        }
        finally {
            DmJmsOpenedEvent openedEvent = new DmJmsOpenedEvent(this);
            openedEvent.setError((Exception)((Object)error));
            this.setChanged();
            this.notifyObservers(openedEvent);
        }
    }

    protected DmCoreException openAbstractContext_internal(Trace t) throws DmCoreException {
        DmCoreException exception = null;
        Context context = (Context)this.baseObject;
        Thread currentThread = Thread.currentThread();
        ClassLoader previousClassLoader = currentThread.getContextClassLoader();
        ClassLoader newClassLoader = this.getDmInitialContext(t).getClassLoader(t);
        currentThread.setContextClassLoader(newClassLoader);
        String alias = this.getAliasName(t);
        try {
            try {
                NamingEnumeration<Binding> bindings = context.listBindings("");
                while (bindings.hasMore()) {
                    Binding bd = bindings.next();
                    String name = bd.getName();
                    Object obj = bd.getObject();
                    if (Trace.isTracing) {
                        t.data(66, "DmJmsAbstractContext.openAbstractContext_internal", 800, "object: " + name + ", " + obj.getClass().getName());
                    }
                    IObjectHandler handler = null;
                    try {
                        if (obj == null) {
                            NullPointerException e = new NullPointerException();
                            exception = JndiErrorHandler.getHandler().generateDamagedObjectException(t, e, name, this);
                        } else {
                            handler = this.getObjectHandler(t, obj);
                        }
                    }
                    catch (Exception e) {
                        exception = JndiErrorHandler.getHandler().generateDamagedObjectException(t, e, name, this);
                        handler = this.getDamagedObjectHandler(t, bd.getClassName());
                    }
                    catch (LinkageError err) {
                        exception = JndiErrorHandler.getHandler().generateDamagedObjectException(t, err, name, this);
                        handler = this.getDamagedObjectHandler(t, bd.getClassName());
                    }
                    if (handler == null) continue;
                    handler.addToSnapshot(this, name, obj);
                }
            }
            catch (Exception e) {
                JndiErrorHandler.getHandler().handleException(t, e, alias, this, 4);
                currentThread.setContextClassLoader(previousClassLoader);
            }
            catch (LinkageError err) {
                JndiErrorHandler.getHandler().handleUnexpected(t, err, alias, this, 8);
                currentThread.setContextClassLoader(previousClassLoader);
            }
        }
        finally {
            currentThread.setContextClassLoader(previousClassLoader);
        }
        return exception;
    }

    public void reopen(Trace t) throws DmCoreException {
        if (!this.isOpen) {
            String msgId = "AMQ4420";
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId);
            DmCoreException e2 = new DmCoreException(t, message, msgId, 50024, 0, 30);
            throw e2;
        }
        DmJmsReopeningEvent reopeningEvent = new DmJmsReopeningEvent(this);
        this.setChanged();
        this.notifyObservers(reopeningEvent);
        DmCoreException error = null;
        try {
            try {
                this.closeAbstractContext_internal(t);
                DmCoreException exception = this.openAbstractContext_internal(t);
                if (exception != null) {
                    throw exception;
                }
            }
            catch (DmCoreException e) {
                error = e;
                throw e;
            }
        }
        finally {
            DmJmsReopenedEvent reopenedEvent = new DmJmsReopenedEvent(this);
            reopenedEvent.setError((Exception)((Object)error));
            this.setChanged();
            this.notifyObservers(reopenedEvent);
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close(Trace t) throws DmCoreException {
        if (!this.isOpen) {
            String msgId = "AMQ4420";
            String message = CommonServices.getSystemMessage((Trace)t, (String)msgId);
            DmCoreException e2 = new DmCoreException(t, message, msgId, 50024, 0, 30);
            throw e2;
        }
        DmJmsClosingEvent closingEvent = new DmJmsClosingEvent(this);
        this.setChanged();
        this.notifyObservers(closingEvent);
        Exception error = null;
        try {
            try {
                Collection c = this.getContexts(t);
                for (DmJmsAbstractContext child : c) {
                    if (!child.isOpen()) continue;
                    child.close(t);
                }
                this.isOpen = false;
                Context context = (Context)this.baseObject;
                context.close();
            }
            catch (Exception e) {
                error = e;
                String alias = this.getAliasName(t);
                JndiErrorHandler.getHandler().handleException(t, e, alias, this, 5);
                if (error == null) {
                    this.closeAbstractContext_internal(t);
                }
                DmJmsClosedEvent closedEvent = new DmJmsClosedEvent(this);
                closedEvent.setError(error);
                this.setChanged();
                this.notifyObservers(closedEvent);
            }
        }
        finally {
            if (error == null) {
                this.closeAbstractContext_internal(t);
            }
            DmJmsClosedEvent closedEvent = new DmJmsClosedEvent(this);
            closedEvent.setError(error);
            this.setChanged();
            this.notifyObservers(closedEvent);
        }
    }

    protected void closeAbstractContext_internal(Trace t) {
        this.dmObjects.clear();
    }

    public void createSubcontext(Trace t, String name) throws DmCoreException {
        block12: {
            Context context = (Context)this.baseObject;
            String alias = this.getAliasName(t, name);
            Context subContext = null;
            Exception error = null;
            DmJmsObject dmObj = null;
            try {
                try {
                    if (this.useInitialDirContext(t)) {
                        try {
                            BasicAttributes ba = new BasicAttributes(OBJECT_CLASS, TOP);
                            DirContext dirContext = (DirContext)context;
                            subContext = dirContext.createSubcontext(alias, (Attributes)ba);
                        }
                        catch (NamingException namingException) {
                            subContext = context.createSubcontext(alias);
                        }
                    } else {
                        subContext = context.createSubcontext(alias);
                    }
                }
                catch (Exception e) {
                    error = e;
                    JndiErrorHandler.getHandler().handleException(t, e, alias, this, 6);
                    if (error == null) {
                        IObjectHandler handler = this.getObjectHandler(t, subContext);
                        dmObj = handler.addToSnapshot(this, alias, subContext);
                    }
                    DmJmsChildAddedEvent childAddedEvent = new DmJmsChildAddedEvent(this, dmObj);
                    childAddedEvent.setError(error);
                    this.setChanged();
                    this.notifyObservers(childAddedEvent);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (error == null) {
                    IObjectHandler handler = this.getObjectHandler(t, subContext);
                    dmObj = handler.addToSnapshot(this, alias, subContext);
                }
                DmJmsChildAddedEvent childAddedEvent = new DmJmsChildAddedEvent(this, dmObj);
                childAddedEvent.setError(error);
                this.setChanged();
                this.notifyObservers(childAddedEvent);
                throw throwable;
            }
            if (error == null) {
                IObjectHandler handler = this.getObjectHandler(t, subContext);
                dmObj = handler.addToSnapshot(this, alias, subContext);
            }
            DmJmsChildAddedEvent childAddedEvent = new DmJmsChildAddedEvent(this, dmObj);
            childAddedEvent.setError(error);
            this.setChanged();
            this.notifyObservers(childAddedEvent);
        }
    }

    public IObjectHandler getDamagedObjectHandler(Trace t, String classname) {
        String id = null;
        id = classname.equals(MQConnectionFactory.class.getName()) ? "<DamagedConnectionFactory>" : (classname.equals(MQQueueConnectionFactory.class.getName()) ? "<DamagedConnectionFactory>" : (classname.equals(MQTopicConnectionFactory.class.getName()) ? "<DamagedConnectionFactory>" : (classname.equals(MQXAConnectionFactory.class.getName()) ? "<DamagedConnectionFactory>" : (classname.equals(MQXAQueueConnectionFactory.class.getName()) ? "<DamagedConnectionFactory>" : (classname.equals(MQXATopicConnectionFactory.class.getName()) ? "<DamagedConnectionFactory>" : (classname.equals(MQQueue.class.getName()) ? "<DamagedDestination>" : (classname.equals(MQTopic.class.getName()) ? "<DamagedDestination>" : "<Unknown>")))))));
        return (IObjectHandler)this.objectHandlers.get(id);
    }

    public IObjectHandler getObjectHandler(Trace t, Object object) {
        String id = object.getClass().getName();
        IObjectHandler objectHandler = (IObjectHandler)this.objectHandlers.get(id);
        if (objectHandler == null) {
            objectHandler = object instanceof Context ? (IObjectHandler)this.objectHandlers.get("javax.naming.Context") : (IObjectHandler)this.objectHandlers.get("<Unknown>");
        }
        if (Trace.isTracing) {
            t.data(66, "DmJmsAbstractContext.getObjectHandler", 800, "handler: " + objectHandler.getClass().toString());
        }
        return objectHandler;
    }

    public int[] getMandatoryIds(Trace t) {
        return new int[]{13100, 13101};
    }

    public String getTitle() {
        Trace t = Trace.getDefault();
        String title = this.getAttributeValue(t, 13100, 0);
        return title;
    }

    public String toString(Trace t) {
        return this.getAttributeValue(t, 13100, 0);
    }

    public String getAlias(Trace t) {
        return this.getAttributeValue(t, 13101, 0);
    }

    public Collection getDestinations(Trace t) {
        DmObjectFilter filter = new DmObjectFilter(t, 2002, 2016);
        filter.setMessagingProvider(0);
        return this.getObjects(t, filter);
    }

    public Collection getQueues(Trace t) {
        DmObjectFilter filter = new DmObjectFilter(t, 2002, 2007);
        filter.setMessagingProvider(0);
        return this.getObjects(t, filter);
    }

    public Collection getTopics(Trace t) {
        DmObjectFilter filter = new DmObjectFilter(t, 2002, 2008);
        filter.setMessagingProvider(0);
        return this.getObjects(t, filter);
    }

    public Collection getConnectionFactories(Trace t) {
        DmObjectFilter filter = new DmObjectFilter(t, 2005, 2016);
        filter.setMessagingProvider(0);
        return this.getObjects(t, filter);
    }

    public Collection getContexts(Trace t) {
        DmObjectFilter filter = new DmObjectFilter(t, 2004, 2016);
        filter.setMessagingProvider(0);
        return this.getObjects(t, filter);
    }

    public Collection getUnknownObjects(Trace t) {
        DmObjectFilter filter = new DmObjectFilter(t, 2006, 2016);
        filter.setMessagingProvider(0);
        return this.getObjects(t, filter);
    }

    public Collection getLikeObjects(Trace t, DmJmsObject object) {
        int type = 2001;
        int subtype = 2015;
        if (object instanceof DmJmsConnectionFactory) {
            type = 2005;
            subtype = 2009;
        } else if (object instanceof DmJmsQueueConnectionFactory) {
            type = 2005;
            subtype = 2010;
        } else if (object instanceof DmJmsTopicConnectionFactory) {
            type = 2005;
            subtype = 2011;
        } else if (object instanceof DmJmsXAConnectionFactory) {
            type = 2005;
            subtype = 2012;
        } else if (object instanceof DmJmsXAQueueConnectionFactory) {
            type = 2005;
            subtype = 2013;
        } else if (object instanceof DmJmsXATopicConnectionFactory) {
            type = 2005;
            subtype = 2014;
        } else if (object instanceof DmJmsQueue) {
            type = 2002;
            subtype = 2007;
        } else if (object instanceof DmJmsTopic) {
            type = 2002;
            subtype = 2008;
        } else if (object instanceof DmJmsContext) {
            type = 2004;
            subtype = 2017;
        } else if (object instanceof DmJmsInitialContext) {
            type = 2003;
            subtype = 2017;
        } else if (object instanceof DmJmsUnknown) {
            type = 2006;
            subtype = 2016;
        }
        PCFFilter pcfFilter = null;
        if (object instanceof DmJmsAbstractConnectionFactory) {
            int transportParam = 13067;
            Attr attr = object.getAttribute(t, transportParam, 0);
            Integer transport = (Integer)attr.getValue(t);
            pcfFilter = PCFFilter.getFilter((int)transportParam, (PCFFilter.Operation)PCFFilter.EQUAL_TO, (int)transport);
        }
        DmObjectFilter filter = new DmObjectFilter(t, type, subtype, pcfFilter);
        filter.setMessagingProvider(0);
        Collection collection = this.getObjects(t, filter);
        return collection;
    }

    public Collection getObjects(Trace t) {
        ArrayList list = new ArrayList();
        Enumeration en = this.dmObjects.elements();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        return list;
    }

    public Collection getObjects(Trace t, DmObjectFilter filter) {
        ArrayList<DmJmsObject> list = new ArrayList<DmJmsObject>();
        Enumeration en = this.dmObjects.elements();
        while (en.hasMoreElements()) {
            DmJmsObject object = (DmJmsObject)en.nextElement();
            if (!this.match(t, object, filter)) continue;
            list.add(object);
        }
        return list;
    }

    public boolean match(Trace t, DmJmsObject object, DmObjectFilter filter) {
        int type = filter.getType();
        int subtype = filter.getSubType();
        int provider = filter.getMessagingProvider();
        String name = filter.getName();
        boolean result = this.checkTransportType(t, object, provider);
        if (result) {
            result = this.checkObjectType(t, object, type, subtype);
        }
        if (result) {
            result = this.checkObjectName(t, object, name);
        }
        if (result) {
            result = this.checkWhereClause(t, object, filter);
        }
        return result;
    }

    private boolean checkWhereClause(Trace t, DmJmsObject object, DmObjectFilter filter) {
        boolean result;
        block15: {
            result = true;
            try {
                PCFFilter pcfFilter = filter.getFilter();
                if (pcfFilter == null) break block15;
                int parameter = pcfFilter.getParameter();
                int operation = pcfFilter.getOperation();
                Object value = pcfFilter.getValue();
                if (value instanceof Integer) {
                    int intValue = (Integer)value;
                    Attr attr = object.getAttributeInternal(t, parameter, 0);
                    if (attr == null) break block15;
                    if (attr.getValue(t) instanceof Integer) {
                        Integer objectValue = (Integer)attr.getValue(t);
                        int intObjectValue = objectValue;
                        switch (operation) {
                            case 4: {
                                if (intValue > intObjectValue) {
                                    result = false;
                                    break;
                                }
                                break block15;
                            }
                            case 1: {
                                if (intValue < intObjectValue) {
                                    result = false;
                                    break;
                                }
                                break block15;
                            }
                            case 2: {
                                if (intValue != intObjectValue) {
                                    result = false;
                                    break;
                                }
                                break block15;
                            }
                            case 5: {
                                if (intValue != intObjectValue) break block15;
                                result = false;
                            }
                            default: {
                                break;
                            }
                        }
                        break block15;
                    }
                    t.FFST(66, "DmJmsAbstractContext.checkWhereClause", 0, 0, parameter, 0, attr.getValue(t).getClass().getName(), null, null);
                    break block15;
                }
                t.FFST(66, "DmJmsAbstractContext.checkWhereClause", 1, 0, parameter, 0, value.getClass().getName(), null, null);
            }
            catch (Exception e) {
                t.FFST(66, "DmJmsAbstractContext.checkWhereClause", 2, 0, 0, 0, e.getCause().getClass().getName(), e.getMessage(), null);
            }
        }
        return result;
    }

    private boolean checkObjectName(Trace t, DmJmsObject object, String pattern) {
        boolean result = false;
        Attr attr = object.getAttributeInternal(t, 13100, 0);
        if (attr == null) {
            result = true;
        } else {
            String name = (String)attr.getValue(t);
            PatternMatcher patternMatcher = new PatternMatcher(pattern);
            result = patternMatcher.match(name);
        }
        return result;
    }

    private boolean checkTransportType(Trace t, DmJmsObject object, int provider) {
        boolean result = false;
        Attr attr = object.getAttributeInternal(t, 13067, 0);
        if (attr == null) {
            result = true;
        } else {
            Integer value = (Integer)attr.getValue(t);
            int objectTransportType = value;
            block0 : switch (provider) {
                case 0: {
                    result = true;
                    break;
                }
                case 1: {
                    switch (objectTransportType) {
                        case 0: {
                            result = true;
                            break;
                        }
                        case 1: {
                            result = true;
                            break;
                        }
                        case 3: {
                            result = true;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (objectTransportType) {
                        case 2: {
                            result = true;
                            break block0;
                        }
                        case 4: {
                            result = true;
                        }
                    }
                }
            }
        }
        return result;
    }

    private boolean checkObjectType(Trace t, DmJmsObject object, int type, int subtype) {
        boolean result = false;
        switch (type) {
            case 2000: {
                result = true;
                break;
            }
            case 2005: {
                switch (subtype) {
                    case 2016: {
                        if (!(object instanceof DmJmsAbstractConnectionFactory)) break;
                        result = true;
                        break;
                    }
                    case 2009: {
                        if (!(object instanceof DmJmsConnectionFactory)) break;
                        result = true;
                        break;
                    }
                    case 2010: {
                        if (!(object instanceof DmJmsQueueConnectionFactory)) break;
                        result = true;
                        break;
                    }
                    case 2011: {
                        if (!(object instanceof DmJmsTopicConnectionFactory)) break;
                        result = true;
                        break;
                    }
                    case 2012: {
                        if (!(object instanceof DmJmsXAConnectionFactory)) break;
                        result = true;
                        break;
                    }
                    case 2013: {
                        if (!(object instanceof DmJmsXAQueueConnectionFactory)) break;
                        result = true;
                        break;
                    }
                    case 2014: {
                        if (!(object instanceof DmJmsXATopicConnectionFactory)) break;
                        result = true;
                    }
                }
                break;
            }
            case 2002: {
                switch (subtype) {
                    case 2016: {
                        if (!(object instanceof DmJmsAbstractDestination)) break;
                        result = true;
                        break;
                    }
                    case 2007: {
                        if (!(object instanceof DmJmsQueue)) break;
                        result = true;
                        break;
                    }
                    case 2008: {
                        if (!(object instanceof DmJmsTopic)) break;
                        result = true;
                    }
                }
                break;
            }
            case 2004: {
                if (!(object instanceof DmJmsContext)) break;
                result = true;
                break;
            }
            case 2003: {
                if (!(object instanceof DmJmsInitialContext)) break;
                result = true;
                break;
            }
            case 2006: {
                if (!(object instanceof DmJmsUnknown)) break;
                result = true;
            }
        }
        return result;
    }

    public boolean isEmpty(Trace t) {
        return this.dmObjects.isEmpty();
    }

    public void addToSnapshot(Trace t, String alias, DmJmsObject object) {
        this.dmObjects.put(alias, object);
    }

    public void removeFromSnapshot(Trace t, String alias) {
        this.dmObjects.remove(alias);
    }

    protected void bind(Trace t, DmJmsObject dmJmsObject) throws DmCoreException {
        String alias;
        Object object;
        block9: {
            Thread currentThread = Thread.currentThread();
            ClassLoader previousClassLoader = currentThread.getContextClassLoader();
            ClassLoader newClassLoader = JmsAdminDataModel.getClassLoader();
            currentThread.setContextClassLoader(newClassLoader);
            Context context = (Context)this.baseObject;
            object = dmJmsObject.getObject();
            alias = dmJmsObject.getAliasName(t);
            String name = dmJmsObject.getAttributeValue(t, 13100, 0);
            try {
                try {
                    if (this.useInitialDirContext(t)) {
                        BasicAttributes ba = new BasicAttributes();
                        ba.put(OBJECT_CLASS, JAVA_CONTAINER);
                        ba.put(COMMON_NAME, name);
                        ((DirContext)context).bind(alias, object, (Attributes)ba);
                    } else {
                        context.bind(alias, object);
                    }
                }
                catch (Exception e) {
                    JndiErrorHandler.getHandler().handleException(t, e, alias, this, 0);
                    currentThread.setContextClassLoader(previousClassLoader);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                currentThread.setContextClassLoader(previousClassLoader);
                throw throwable;
            }
            currentThread.setContextClassLoader(previousClassLoader);
        }
        IObjectHandler handler = this.getObjectHandler(t, object);
        handler.addToSnapshot(this, alias, dmJmsObject);
    }

    protected void rebind(Trace t, DmJmsObject dmJmsObject) throws DmCoreException {
        block6: {
            Thread currentThread = Thread.currentThread();
            ClassLoader previousClassLoader = currentThread.getContextClassLoader();
            ClassLoader newClassLoader = JmsAdminDataModel.getClassLoader();
            currentThread.setContextClassLoader(newClassLoader);
            Context context = (Context)this.baseObject;
            Object object = dmJmsObject.getObject();
            String alias = dmJmsObject.getAliasName(t);
            String name = dmJmsObject.getAttributeValue(t, 13100, 0);
            alias = this.getDmInitialContext(t).getAliasName(t, alias);
            try {
                try {
                    if (this.useInitialDirContext(t)) {
                        BasicAttributes ba = new BasicAttributes();
                        ba.put(OBJECT_CLASS, JAVA_CONTAINER);
                        ba.put(COMMON_NAME, name);
                        ((DirContext)context).rebind(alias, object, (Attributes)ba);
                        break block6;
                    }
                    context.rebind(alias, object);
                }
                catch (Exception e) {
                    JndiErrorHandler.getHandler().handleException(t, e, alias, this, 1);
                    currentThread.setContextClassLoader(previousClassLoader);
                }
            }
            finally {
                currentThread.setContextClassLoader(previousClassLoader);
            }
        }
    }

    public boolean useInitialDirContext(Trace t) {
        return this.getDmInitialContext(t).useInitialDirContext(t);
    }

    public IDmObject clone(Trace t, String name) {
        return null;
    }

    @Override
    public int getMessagingProvider(Trace t) {
        return -1;
    }
}

