/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.Key;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.IJmsParameter;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.JmsBrokerVersion;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.JmsMessageSelection;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.JmsReceiveExit;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.JmsReceiveExitInit;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.JmsSecurityExit;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.JmsSecurityExitInit;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.JmsSendExit;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.JmsSendExitInit;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import org.osgi.framework.Bundle;

public abstract class DmJmsAbstractConnectionFactory
extends DmJmsObject
implements DmActionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/objects/DmJmsAbstractConnectionFactory.java";
    private static Hashtable<Key, Key> allowed = DmJmsAbstractConnectionFactory.getFilterTable();
    private static HashMap allAttributesByType = null;
    private DmActionEvent event;

    public DmJmsAbstractConnectionFactory(Trace t, Object object, DmJmsAbstractContext dmContext) {
        super(t, object, 2005, dmContext);
        if (this.attributesByType == null) {
            this.attributesByType = allAttributesByType;
        }
    }

    public void setTransport(Trace t, int value) throws DmCoreException {
        Attr attr = this.getAttributeInternal(t, 13067, 0);
        attr.setNewValue(t, (Object)value);
        ArrayList<IJmsParameter> job = new ArrayList<IJmsParameter>();
        job.add(this.getParameter(13067));
        this.event = null;
        this.actionChange(t, this, job, false);
        if (this.event != null) {
            DmCoreException dmCoreException = this.event.getException();
            this.event = null;
            if (dmCoreException != null) {
                int rc = 50042;
                Throwable cause = dmCoreException.getCause();
                DmCoreException e = null;
                if (cause == null) {
                    String msgId = "JmsAdmin.ConnectionFactory.SwitchTransport.Failure";
                    String insert0 = this.getTitle();
                    String insert1 = dmCoreException.getMessage();
                    String message = JmsAdminPlugin.getMessage(msgId);
                    message = Message.format((String)message, (String)insert0, (String)insert1);
                    e = new DmCoreException(t, message, dmCoreException.getMessageID(), rc, 0, 30);
                } else {
                    String msgId = "AMQ4445";
                    String insert0 = cause.getMessage();
                    String insert1 = this.getTitle();
                    String[] inserts = new String[]{insert0, insert1};
                    String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
                    e = new DmCoreException(t, message, cause, msgId, rc, 0, 30);
                }
                throw e;
            }
        }
    }

    public void dmActionDone(DmActionEvent e) {
        this.event = e;
    }

    public int getTransport(Trace t) {
        int transportType = -1;
        Attr attr = this.getAttributeInternal(t, 13067, 0);
        if (attr != null) {
            Integer value = (Integer)attr.getValue(t);
            transportType = value;
        }
        return transportType;
    }

    private static Hashtable<Key, Key> getFilterTable() {
        Hashtable<Key, Key> table = new Hashtable<Key, Key>();
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13100);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13101);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13082);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13110);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13107);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13108);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13109);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13002);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13003);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13005);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13007);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13008);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13009);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13013);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13014);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13015);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13016);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13019);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13020);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13021);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13025);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13029);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13030);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13031);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13033);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13034);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13036);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13039);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13042);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13043);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13045);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13048);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13053);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13059);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13060);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13061);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13063);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13070);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13064);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13065);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13067);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13068);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13069);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13071);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13072);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13073);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13074);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13075);
        DmJmsAbstractConnectionFactory.addToFilter(table, 0, 13115);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13100);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13101);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13082);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13084);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13085);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13083);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13110);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13107);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13108);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13109);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13002);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13003);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13005);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13007);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13008);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13009);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13010);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13011);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13012);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13013);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13014);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13015);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13016);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13017);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13018);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13019);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13120);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13122);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13121);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13020);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13021);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13025);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13026);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13027);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13029);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13030);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13031);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13033);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13034);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13036);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13037);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13039);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13042);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13043);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13045);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13046);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13047);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13048);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13049);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13050);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13051);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13052);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13053);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13054);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13055);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13056);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13057);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13058);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13059);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13060);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13061);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13063);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13070);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13064);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13065);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13067);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13068);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13069);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13071);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13072);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13073);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13074);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13075);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13115);
        DmJmsAbstractConnectionFactory.addToFilter(table, 1, 13086);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13100);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13101);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13082);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13110);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13107);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13108);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13109);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13001);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13002);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13003);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13005);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13007);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13008);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13009);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13010);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13011);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13012);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13013);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13014);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13015);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13016);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13017);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13018);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13019);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13020);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13021);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13022);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13025);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13026);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13027);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13029);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13030);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13031);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13032);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13033);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13034);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13036);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13037);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13039);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13040);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13041);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13042);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13043);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13045);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13046);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13047);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13048);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13049);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13050);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13051);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13052);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13053);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13054);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13055);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13056);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13057);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13058);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13059);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13060);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13061);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13063);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13070);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13064);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13065);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13067);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13068);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13069);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13071);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13072);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13073);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13074);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13075);
        DmJmsAbstractConnectionFactory.addToFilter(table, 3, 13115);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13100);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13101);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13110);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13107);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13108);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13109);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13015);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13021);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13026);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13037);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13027);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13028);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13022);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13057);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13055);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13040);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13041);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13032);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13067);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13069);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13070);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13115);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13120);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13122);
        DmJmsAbstractConnectionFactory.addToFilter(table, 2, 13121);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13100);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13101);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13110);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13107);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13108);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13109);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13015);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13021);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13026);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13037);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13040);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13041);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13027);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13028);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13067);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13069);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13070);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13115);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13120);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13122);
        DmJmsAbstractConnectionFactory.addToFilter(table, 4, 13121);
        return table;
    }

    private static void addToFilter(Hashtable<Key, Key> table, int one, int two) {
        Key key = new Key(one, two);
        table.put(key, key);
    }

    @Override
    public Attr getAttribute(Trace t, int id, int index) {
        Attr attr = this.getAttributeInternal(t, 13067, 0);
        if (attr == null) {
            attr = this.getAttributeInternal(t, id, index);
        } else {
            Integer value = (Integer)attr.getValue(t);
            int transport = value;
            attr = null;
            Key key = new Key(transport, id);
            Key o = allowed.get(key);
            if (o != null) {
                attr = this.getAttributeInternal(t, id, index);
            }
        }
        return attr;
    }

    public String toString(Trace t) {
        return this.getAttributeValue(t, 13100, 0);
    }

    public String getTitle() {
        Trace t = Trace.getDefault();
        return this.getAttributeValue(t, 13100, 0);
    }

    public int[] getMandatoryIds(Trace t) {
        int[] mandatoryAttributes = null;
        int transport = this.getTransport(t);
        switch (transport) {
            case 0: {
                if (this.baseObject instanceof MQQueueConnectionFactory) {
                    mandatoryAttributes = new int[]{13100, 13072};
                    break;
                }
                mandatoryAttributes = new int[]{13100, 13008, 13002, 13072};
                break;
            }
            case 1: {
                if (this.baseObject instanceof MQQueueConnectionFactory) {
                    mandatoryAttributes = new int[]{13100, 13072};
                    break;
                }
                mandatoryAttributes = new int[]{13100, 13008, 13002, 13072};
                break;
            }
            case 2: 
            case 4: {
                mandatoryAttributes = new int[]{13100, 13026};
            }
        }
        return mandatoryAttributes;
    }

    @Override
    public void performCrossAttributeValidation(Trace t, ArrayList parameters) throws DmCoreException {
        boolean result = true;
        boolean modifyingBrokerVersionOrMessageSelection = false;
        boolean modifyingSendExitOrSendExitInitialisation = false;
        boolean modifyingReceiveExitOrReceiveExitInitialisation = false;
        boolean modifyingSecurityExitOrSecurityExitInitialisation = false;
        for (Object parameter : parameters) {
            if (parameter instanceof JmsBrokerVersion || parameter instanceof JmsMessageSelection) {
                modifyingBrokerVersionOrMessageSelection = true;
                continue;
            }
            if (parameter instanceof JmsSendExit || parameter instanceof JmsSendExitInit) {
                modifyingSendExitOrSendExitInitialisation = true;
                continue;
            }
            if (parameter instanceof JmsReceiveExit || parameter instanceof JmsReceiveExitInit) {
                modifyingReceiveExitOrReceiveExitInitialisation = true;
                continue;
            }
            if (!(parameter instanceof JmsSecurityExit) && !(parameter instanceof JmsSecurityExitInit)) continue;
            modifyingSecurityExitOrSecurityExitInitialisation = true;
        }
        if (result && modifyingBrokerVersionOrMessageSelection) {
            result = this.checkBrokerVersionAndMsgSelection(t);
        }
        if (result && modifyingSendExitOrSendExitInitialisation) {
            result = this.checkSendExit(t);
        }
        if (result && modifyingReceiveExitOrReceiveExitInitialisation) {
            result = this.checkReceiveExit(t);
        }
        if (result && modifyingSecurityExitOrSecurityExitInitialisation) {
            result = this.checkSecurityExit(t);
        }
    }

    public boolean checkBrokerVersionAndMsgSelection(Trace t) throws DmCoreException {
        boolean result = true;
        Attr brokerVersionAttribute = this.getAttribute(t, 13009, 0);
        Attr messageSelectionAttribute = this.getAttribute(t, 13031, 0);
        if (brokerVersionAttribute != null && messageSelectionAttribute != null) {
            boolean doConsistencyCheck = false;
            Integer brokerVersionObject = (Integer)brokerVersionAttribute.getNewValue(t);
            if (brokerVersionObject == null) {
                brokerVersionObject = (Integer)brokerVersionAttribute.getValue(t);
            } else {
                doConsistencyCheck = true;
            }
            int brokerVersion = brokerVersionObject;
            Integer messageSelectionObject = (Integer)messageSelectionAttribute.getNewValue(t);
            if (messageSelectionObject == null) {
                messageSelectionObject = (Integer)messageSelectionAttribute.getValue(t);
            } else {
                doConsistencyCheck = true;
            }
            int messageSelection = messageSelectionObject;
            if (doConsistencyCheck && brokerVersion == 0 && messageSelection == 1) {
                result = false;
                AttrType brokerVersionAttributeType = brokerVersionAttribute.getAttrType();
                AttrType messageSelectionAttributeType = messageSelectionAttribute.getAttrType();
                String insert0 = this.getParameter(13009).getFieldName(t);
                String insert1 = brokerVersionAttributeType.getDisplayGroup().getTitle();
                String insert2 = CoreServices.message.getMessage(t, "JMS_BROKER_V1.title");
                String insert3 = this.getParameter(13031).getFieldName(t);
                String insert4 = messageSelectionAttributeType.getDisplayGroup().getTitle();
                String insert5 = CoreServices.message.getMessage(t, "JMS_MSGSELECTION_BROKER.title");
                String[] inserts = new String[]{insert0, insert1, insert2, insert3, insert4, insert5};
                String msgId = "AMQ4436";
                String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
                DmCoreException e = new DmCoreException(t, message, msgId, 50024, 0, 30);
                throw e;
            }
        }
        return result;
    }

    public boolean checkSendExit(Trace t) throws DmCoreException {
        boolean result = true;
        Attr sendExitAttribute = this.getAttribute(t, 13051, 0);
        Attr sendExitInitAttribute = this.getAttribute(t, 13052, 0);
        if (sendExitAttribute != null && sendExitInitAttribute != null) {
            boolean doConsistencyCheck = false;
            ArrayList sendExitObject = (ArrayList)sendExitAttribute.getNewValue(t);
            if (sendExitObject == null) {
                sendExitObject = (ArrayList)sendExitAttribute.getValue(t);
            } else {
                doConsistencyCheck = true;
            }
            ArrayList sendExitInitObject = (ArrayList)sendExitInitAttribute.getNewValue(t);
            if (sendExitInitObject == null) {
                sendExitInitObject = (ArrayList)sendExitInitAttribute.getValue(t);
            } else {
                doConsistencyCheck = true;
            }
            if (doConsistencyCheck && sendExitObject.size() == 0 && sendExitInitObject.size() > 0) {
                result = false;
                AttrType sendExitAttributeType = sendExitAttribute.getAttrType();
                AttrType sendExitInitAttributeType = sendExitInitAttribute.getAttrType();
                String insert0 = this.getParameter(13052).getFieldName(t);
                String insert1 = sendExitInitAttributeType.getDisplayGroup().getTitle();
                String insert2 = this.getParameter(13051).getFieldName(t);
                String insert3 = sendExitAttributeType.getDisplayGroup().getTitle();
                String[] inserts = new String[]{insert0, insert1, insert2, insert3};
                String msgId = "AMQ4448";
                String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
                DmCoreException e = new DmCoreException(t, message, msgId, 50024, 0, 30);
                throw e;
            }
        }
        return result;
    }

    public boolean checkReceiveExit(Trace t) throws DmCoreException {
        boolean result = true;
        Attr recieveExitAttribute = this.getAttribute(t, 13046, 0);
        Attr recieveExitInitAttribute = this.getAttribute(t, 13047, 0);
        if (recieveExitAttribute != null && recieveExitInitAttribute != null) {
            boolean doConsistencyCheck = false;
            ArrayList recieveExitObject = (ArrayList)recieveExitAttribute.getNewValue(t);
            if (recieveExitObject == null) {
                recieveExitObject = (ArrayList)recieveExitAttribute.getValue(t);
            } else {
                doConsistencyCheck = true;
            }
            ArrayList recieveExitInitObject = (ArrayList)recieveExitInitAttribute.getNewValue(t);
            if (recieveExitInitObject == null) {
                recieveExitInitObject = (ArrayList)recieveExitInitAttribute.getValue(t);
            } else {
                doConsistencyCheck = true;
            }
            if (doConsistencyCheck && recieveExitObject.size() == 0 && recieveExitInitObject.size() > 0) {
                result = false;
                AttrType recieveExitAttributeType = recieveExitAttribute.getAttrType();
                AttrType recieveExitInitAttributeType = recieveExitInitAttribute.getAttrType();
                String insert0 = this.getParameter(13047).getFieldName(t);
                String insert1 = recieveExitInitAttributeType.getDisplayGroup().getTitle();
                String insert2 = this.getParameter(13046).getFieldName(t);
                String insert3 = recieveExitAttributeType.getDisplayGroup().getTitle();
                String[] inserts = new String[]{insert0, insert1, insert2, insert3};
                String msgId = "AMQ4448";
                String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
                DmCoreException e = new DmCoreException(t, message, msgId, 50024, 0, 30);
                throw e;
            }
        }
        return result;
    }

    public boolean checkSecurityExit(Trace t) throws DmCoreException {
        boolean result = true;
        Attr securityExitAttribute = this.getAttribute(t, 13049, 0);
        Attr securityExitInitAttribute = this.getAttribute(t, 13050, 0);
        if (securityExitAttribute != null && securityExitInitAttribute != null) {
            boolean doConsistencyCheck = false;
            String securityExitObject = (String)securityExitAttribute.getNewValue(t);
            if (securityExitObject == null) {
                securityExitObject = (String)securityExitAttribute.getValue(t);
            } else {
                doConsistencyCheck = true;
            }
            String securityExitInitObject = (String)securityExitInitAttribute.getNewValue(t);
            if (securityExitInitObject == null) {
                securityExitInitObject = (String)securityExitInitAttribute.getValue(t);
            } else {
                doConsistencyCheck = true;
            }
            if (doConsistencyCheck && securityExitObject.length() == 0 && securityExitInitObject.length() > 0) {
                result = false;
                AttrType securityExitAttributeType = securityExitAttribute.getAttrType();
                AttrType securityExitInitAttributeType = securityExitInitAttribute.getAttrType();
                String insert0 = this.getParameter(13050).getFieldName(t);
                String insert1 = securityExitInitAttributeType.getDisplayGroup().getTitle();
                String insert2 = this.getParameter(13049).getFieldName(t);
                String insert3 = securityExitAttributeType.getDisplayGroup().getTitle();
                String[] inserts = new String[]{insert0, insert1, insert2, insert3};
                String msgId = "AMQ4448";
                String message = CommonServices.getSystemMessage((Trace)t, (String)msgId, (String[])inserts);
                DmCoreException e = new DmCoreException(t, message, msgId, 50024, 0, 30);
                throw e;
            }
        }
        return result;
    }

    @Override
    public int getMessagingProvider(Trace t) {
        int provider = -1;
        Attr attr = this.getAttributeInternal(t, 13067, 0);
        if (attr != null) {
            Integer value = (Integer)attr.getValue(t);
            int transport = value;
            switch (transport) {
                case 0: 
                case 1: 
                case 3: {
                    provider = 1;
                    break;
                }
                case 2: 
                case 4: {
                    provider = 2;
                }
            }
        }
        return provider;
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        if ((allAttributesByType = DmJmsAbstractConnectionFactory.initAllAttrTypeTable(t, "DmJmsConnectionFactory", allAttributesByType, bund)) == null) {
            if (Trace.isTracing) {
                t.data(66, "DmJmsAbstractConnectionFactory.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmJmsAbstractConnectionFactory.getAllAttributesByType(t, allAttributesByType);
    }

    public static HashMap getAllAttributesByType(Trace t, int transport) {
        return DmJmsAbstractConnectionFactory.getAllAttributesByType(t, allAttributesByType, transport);
    }

    public static HashMap<Object, Object> getAllAttributesByType(Trace t, HashMap hm, int transport) {
        if (hm == null) {
            String message = "objectType not initialised";
            t.FFST(66, "DmJmsAbstractConnectionFactory.getAllAttributesByType", 2, 0, message);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set k = hm.keySet();
        for (Integer id : k) {
            Key key = new Key(transport, id);
            Key o = allowed.get(key);
            if (o == null) continue;
            list.add(id);
        }
        HashMap<Object, Object> ids = new HashMap<Object, Object>();
        int i = 0;
        while (i < list.size()) {
            Object id = list.get(i);
            ids.put(id, id);
            ++i;
        }
        return ids;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmJmsAbstractConnectionFactory.getAttributeTitle(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmJmsAbstractConnectionFactory.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmJmsAbstractConnectionFactory.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmJmsAbstractConnectionFactory.getAttributeType(t, allAttributesByType, id);
    }
}

