/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.base;

public class PatternMatcher {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/base/PatternMatcher.java";
    private String[] substrings;
    private boolean startsWithWildcard;
    private boolean endsWithWildcard;

    public PatternMatcher(String pattern) {
        this.substrings = pattern.split("\\*");
        this.startsWithWildcard = pattern.charAt(0) == '*';
        this.endsWithWildcard = pattern.charAt(pattern.length() - 1) == '*';
    }

    public boolean match(String name) {
        int index;
        String substring;
        boolean match = true;
        int i = 0;
        if (i < this.substrings.length) {
            substring = this.substrings[i];
            if (this.startsWithWildcard) {
                index = name.indexOf(substring);
                if (index >= 0) {
                    name = name.substring(index + substring.length());
                } else {
                    match = false;
                }
            } else if (name.startsWith(substring)) {
                name = name.substring(substring.length());
            } else {
                match = false;
            }
        }
        i = 1;
        while (i < this.substrings.length && match) {
            substring = this.substrings[i];
            index = name.indexOf(substring);
            if (index >= 0) {
                name = name.substring(index + substring.length());
            } else {
                match = false;
            }
            ++i;
        }
        if (match && name.length() > 0 && !this.endsWithWildcard) {
            match = false;
        }
        return match;
    }
}

