/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.base;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.jmsadmin.core.internal.handler.IObjectHandler;
import com.ibm.mq.explorer.jmsadmin.core.internal.handlerfactories.IObjectHandlerFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractDestination;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsDamagedConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsDamagedDestination;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsUnknown;
import com.ibm.mq.explorer.jmsadmin.core.internal.paramlist.DmJmsConnectionFactoryParameters;
import com.ibm.mq.explorer.jmsadmin.core.internal.paramlist.DmJmsQueueConnectionFactoryParameters;
import com.ibm.mq.explorer.jmsadmin.core.internal.paramlist.DmJmsQueueParameters;
import com.ibm.mq.explorer.jmsadmin.core.internal.paramlist.DmJmsTopicConnectionFactoryParameters;
import com.ibm.mq.explorer.jmsadmin.core.internal.paramlist.DmJmsTopicParameters;
import com.ibm.mq.explorer.jmsadmin.core.internal.paramlist.DmJmsXAConnectionFactoryParameters;
import com.ibm.mq.explorer.jmsadmin.core.internal.paramlist.DmJmsXAQueueConnectionFactoryParameters;
import com.ibm.mq.explorer.jmsadmin.core.internal.paramlist.DmJmsXATopicConnectionFactoryParameters;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class JmsAdminDataModel
extends DefaultHandler {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/base/JmsAdminDataModel.java";
    public static final String STATE_FILENAME = "JmsAdmin.xml";
    public static final String JMS_NODE = "JndiInitialContexts";
    public static final String LINESEPERATOR = System.getProperty("line.separator");
    private boolean parseSuccessfull;
    private ArrayList initialContexts;
    private static String stateLocation;
    private ClassLoader classLoader;
    private static JmsAdminDataModel dataModel;
    private ArrayList objectHandlerFactories;
    private static DmJmsConnectionFactoryParameters dmJmsConnectionFactoryParameters;
    private static DmJmsQueueConnectionFactoryParameters dmJmsQueueConnectionFactoryParameters;
    private static DmJmsTopicConnectionFactoryParameters dmJmsTopicConnectionFactoryParameters;
    private static DmJmsXAConnectionFactoryParameters dmJmsXAConnectionFactoryParameters;
    private static DmJmsXAQueueConnectionFactoryParameters dmJmsXAQueueConnectionFactoryParameters;
    private static DmJmsXATopicConnectionFactoryParameters dmJmsXATopicConnectionFactoryParameters;
    private static DmJmsQueueParameters dmJmsQueueParameters;
    private static DmJmsTopicParameters dmJmsTopicParameters;

    public JmsAdminDataModel(Trace t, String dir, ClassLoader aClassLoader, ArrayList aObjectHandlerFactories) {
        dataModel = this;
        this.initialContexts = new ArrayList();
        stateLocation = dir;
        this.classLoader = aClassLoader;
        this.objectHandlerFactories = aObjectHandlerFactories;
        Bundle bundle = JmsAdminPlugin.getDefault().getBundle();
        DmJmsInitialContext.staticInit(t, bundle);
        DmJmsContext.staticInit(t, bundle);
        DmJmsAbstractConnectionFactory.staticInit(t, bundle);
        DmJmsAbstractDestination.staticInit(t, bundle);
        DmJmsUnknown.staticInit(t, bundle);
        DmJmsDamagedConnectionFactory.staticInit(t, bundle);
        DmJmsDamagedDestination.staticInit(t, bundle);
        this.restore(t);
    }

    public void close(Trace t) {
    }

    public void addNewInitialContext(Trace t, Hashtable environment, String name) throws DmCoreException {
        DmJmsInitialContext initialContext = new DmJmsInitialContext(t, environment, name);
        this.addInitialContext(t, initialContext);
    }

    public void addInitialContext(Trace t, DmJmsInitialContext initialContext) throws DmCoreException {
        this.initialContexts.add(initialContext);
        this.save(t);
    }

    public void removeInitialContext(Trace t, DmJmsInitialContext initialContext) throws DmCoreException {
        this.initialContexts.remove(initialContext);
        this.save(t);
    }

    public ArrayList getInitialContexts() {
        return this.initialContexts;
    }

    public static ClassLoader getClassLoader() {
        return JmsAdminDataModel.dataModel.classLoader;
    }

    public static JmsAdminDataModel getDataModel() {
        return dataModel;
    }

    public Hashtable getObjectHandlers(Trace t) {
        Hashtable<String, IObjectHandler> list = new Hashtable<String, IObjectHandler>();
        int i = 0;
        while (i < this.objectHandlerFactories.size()) {
            IObjectHandlerFactory factory = (IObjectHandlerFactory)this.objectHandlerFactories.get(i);
            IObjectHandler handler = factory.makeObjectHandler();
            String id = handler.getID();
            list.put(id, handler);
            ++i;
        }
        return list;
    }

    public boolean mergeDm(Trace t, XMLMemento xmlNode) throws DmCoreException {
        boolean result = true;
        boolean determineAttributes = true;
        IMemento[] jmsNodes = xmlNode.getChildren("JndiInitialContext");
        if (jmsNodes != null && jmsNodes.length > 0) {
            try {
                result = false;
                IMemento[] iMementoArray = jmsNodes;
                int n = jmsNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    DmJmsInitialContext jmsCtx;
                    IMemento jmsNode = iMementoArray[n2];
                    AttributesImpl atts = new AttributesImpl();
                    String[] attributeKeys = this.getAttributeKeys(jmsNode);
                    if (attributeKeys == null) {
                        determineAttributes = false;
                        break;
                    }
                    if (attributeKeys.length > 0) {
                        String[] stringArray = attributeKeys;
                        int n3 = attributeKeys.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String key = stringArray[n4];
                            atts.addAttribute("", key, "", "", jmsNode.getString(key));
                            ++n4;
                        }
                    }
                    if (!this.initialContexts.contains(jmsCtx = DmJmsInitialContext.startElement(t, "", atts))) {
                        this.initialContexts.add(jmsCtx);
                    }
                    ++n2;
                }
                if (determineAttributes) {
                    result = this.save(t);
                }
            }
            catch (CommonServicesException e) {
                t.FFST(66, "JmsAdminDataModel.mergeDm", 10, -1, 0, 0, e.getMessage(), null, null);
            }
        }
        return result;
    }

    private String[] getAttributeKeys(IMemento iMemento) {
        String[] toReturn = null;
        try {
            Method getType = iMemento.getClass().getMethod("getAttributeKeys", null);
            Object ret = getType.invoke((Object)iMemento, null);
            if (ret instanceof String[]) {
                toReturn = (String[])ret;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return toReturn;
    }

    public boolean save(Trace t) throws DmCoreException {
        boolean result = this.save(t, this.getDmAsXMLMemento(t));
        return result;
    }

    private boolean save(Trace t, XMLMemento xmlNode) throws DmCoreException {
        boolean result = false;
        OutputStreamWriter writer = null;
        try {
            try {
                File file = JmsAdminDataModel.getDataStoreLocation();
                FileOutputStream output = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
                xmlNode.save((Writer)writer);
                result = true;
            }
            catch (Exception e) {
                UiPlugin.logException((Exception)e);
                String msg = CommonServices.getSystemMessage((String)"AMQ4557");
                t.data(66, "JmsAdminDataModel.save", Integer.MIN_VALUE, String.valueOf(msg) + ": " + e.toString());
                throw new DmCoreException(t, msg, (Throwable)e, "AMQ4557", 0, 0, 20);
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                UiPlugin.logException((Exception)e1);
            }
        }
        return result;
    }

    public XMLMemento getDmAsXMLMemento(Trace t) {
        XMLMemento rootWrite = XMLMemento.createWriteRoot((String)JMS_NODE);
        int i = 0;
        while (i < this.initialContexts.size()) {
            DmJmsInitialContext ctx = (DmJmsInitialContext)this.initialContexts.get(i);
            ctx.serializeXml(t, rootWrite);
            ++i;
        }
        return rootWrite;
    }

    /*
     * Exception decompiling
     */
    public void restore(Trace t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        Trace t = Trace.getDefault();
        if ("JndiInitialContext".equals(qName)) {
            DmJmsInitialContext ctx = null;
            try {
                ctx = DmJmsInitialContext.startElement(t, qName, atts);
            }
            catch (CommonServicesException e) {
                t.FFST(66, "JmsAdminDataModel.startElement", 0, 0, e.getMessage());
                SAXException saxException = new SAXException((Exception)((Object)e));
                throw saxException;
            }
            if (ctx != null) {
                try {
                    this.addInitialContext(t, ctx);
                }
                catch (DmCoreException e) {
                    t.FFST(66, "JmsAdminDataModel.startElement", 1, 0, e.getMessage());
                    SAXException saxException = new SAXException((Exception)((Object)e));
                    throw saxException;
                }
            }
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.parseSuccessfull = false;
        super.error(e);
    }

    public boolean isParseSuccessfull() {
        return this.parseSuccessfull;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        Trace t = Trace.getDefault();
        InputSource is = null;
        if (systemId.indexOf("JndiInitialContexts.dtd") != -1) {
            String dtd = this.jndiInitialContextsDtd();
            char[] aryDtd = dtd.toCharArray();
            CharArrayReader charReader = new CharArrayReader(aryDtd);
            is = new InputSource(charReader);
        } else {
            try {
                is = super.resolveEntity(publicId, systemId);
            }
            catch (Exception e) {
                t.FFST(66, "JmsAdminDataModel.resolveEntity", 0, 0, e.getMessage());
                SAXException saxException = new SAXException(e);
                throw saxException;
            }
        }
        return is;
    }

    private String jndiInitialContextsDtd() {
        String dtd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!ELEMENT JndiInitialContexts (JndiInitialContext*)>\n\n<!ELEMENT JndiInitialContext EMPTY>\n<!ATTLIST JndiInitialContext url CDATA #REQUIRED>\n";
        return dtd;
    }

    public static DmJmsConnectionFactoryParameters getDmJmsConnectionFactoryParameters(Trace t) {
        if (dmJmsConnectionFactoryParameters == null) {
            dmJmsConnectionFactoryParameters = new DmJmsConnectionFactoryParameters(t);
        }
        return dmJmsConnectionFactoryParameters;
    }

    public static DmJmsQueueConnectionFactoryParameters getDmJmsQueueConnectionFactoryParameters(Trace t) {
        if (dmJmsQueueConnectionFactoryParameters == null) {
            dmJmsQueueConnectionFactoryParameters = new DmJmsQueueConnectionFactoryParameters(t);
        }
        return dmJmsQueueConnectionFactoryParameters;
    }

    public static DmJmsTopicConnectionFactoryParameters getDmJmsTopicConnectionFactoryParameters(Trace t) {
        if (dmJmsTopicConnectionFactoryParameters == null) {
            dmJmsTopicConnectionFactoryParameters = new DmJmsTopicConnectionFactoryParameters(t);
        }
        return dmJmsTopicConnectionFactoryParameters;
    }

    public static DmJmsXAConnectionFactoryParameters getDmJmsXAConnectionFactoryParameters(Trace t) {
        if (dmJmsXAConnectionFactoryParameters == null) {
            dmJmsXAConnectionFactoryParameters = new DmJmsXAConnectionFactoryParameters(t);
        }
        return dmJmsXAConnectionFactoryParameters;
    }

    public static DmJmsXAQueueConnectionFactoryParameters getDmJmsXAQueueConnectionFactoryParameters(Trace t) {
        if (dmJmsXAQueueConnectionFactoryParameters == null) {
            dmJmsXAQueueConnectionFactoryParameters = new DmJmsXAQueueConnectionFactoryParameters(t);
        }
        return dmJmsXAQueueConnectionFactoryParameters;
    }

    public static DmJmsXATopicConnectionFactoryParameters getDmJmsXATopicConnectionFactoryParameters(Trace t) {
        if (dmJmsXATopicConnectionFactoryParameters == null) {
            dmJmsXATopicConnectionFactoryParameters = new DmJmsXATopicConnectionFactoryParameters(t);
        }
        return dmJmsXATopicConnectionFactoryParameters;
    }

    public static DmJmsQueueParameters getDmJmsQueueParameters(Trace t) {
        if (dmJmsQueueParameters == null) {
            dmJmsQueueParameters = new DmJmsQueueParameters(t);
        }
        return dmJmsQueueParameters;
    }

    public static DmJmsTopicParameters getDmJmsTopicParameters(Trace t) {
        if (dmJmsTopicParameters == null) {
            dmJmsTopicParameters = new DmJmsTopicParameters(t);
        }
        return dmJmsTopicParameters;
    }

    public static File getDataStoreLocation() {
        return new File(stateLocation, STATE_FILENAME);
    }
}

