/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.core.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.jmsadmin.core.internal.actions.JMSAdminAction;
import com.ibm.mq.explorer.jmsadmin.ui.extensions.JmsInitialContextExtObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminMenuActions;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContext;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AutoreconnectAction
extends JMSAdminAction {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/core/internal/actions/AutoreconnectAction.java";

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        Trace t = Trace.getDefault();
        if (selection != null && selection instanceof IStructuredSelection) {
            this.structuredSelection = (IStructuredSelection)selection;
            boolean autoreconnectValue = false;
            if (this.structuredSelection.size() == 1) {
                List<JmsInitialContextExtObject> initialContexts = this.getExtObjectsFromSelection(t, JmsInitialContextExtObject.class);
                JmsContext jmsContext = JmsAdminPlugin.getJmsInitialContext(initialContexts.get(0).getObjectId());
                autoreconnectValue = jmsContext.getDmObject().getAutoReconnect(t);
            }
            action.setChecked(autoreconnectValue);
        }
    }

    public void run(IAction action) {
        Trace t = Trace.getDefault();
        if (this.structuredSelection != null) {
            List<JmsInitialContextExtObject> initialContexts = this.getExtObjectsFromSelection(t, JmsInitialContextExtObject.class);
            for (JmsInitialContextExtObject initialContextExtObject : initialContexts) {
                JmsContext jmsContext = JmsAdminPlugin.getJmsInitialContext(initialContextExtObject.getObjectId());
                JmsAdminMenuActions.autoreconnectToggle(jmsContext);
            }
        }
    }
}

