/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.rcp.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.rcp.internal.base.RcpActionBarAdvisor;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class RcpWindowAdvisor
extends WorkbenchWindowAdvisor {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui.rcp/src/com/ibm/mq/explorer/ui/rcp/internal/base/RcpWindowAdvisor.java";
    private static final String[] menusToRemove = new String[]{"org.eclipse.ui.run", "org.eclipse.search.menu", "navigate"};
    private static final String[] actionsToRemove = new String[]{"converstLineDelimitersTo", "org.eclipse.ui.openLocalFile", "selectWorkingSets"};

    public RcpWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
        configurer.setShowProgressIndicator(true);
    }

    public void preWindowOpen() {
        super.preWindowOpen();
        this.getWindowConfigurer().setShowCoolBar(false);
    }

    public void postWindowCreate() {
        Trace.getDefault();
        IMenuManager menuBar = this.getWindowConfigurer().getActionBarConfigurer().getMenuManager();
        if (menuBar != null) {
            List<String> removeList = Arrays.asList(actionsToRemove);
            List<String> removeMenuList = Arrays.asList(menusToRemove);
            IContributionItem[] items = menuBar.getItems();
            int i = 0;
            while (i < items.length) {
                String id = items[i].getId();
                if (id != null) {
                    if (removeMenuList.contains(id.intern())) {
                        menuBar.remove(items[i]);
                    } else if (items[i] instanceof IMenuManager) {
                        IMenuManager mm = (IMenuManager)items[i];
                        IContributionItem[] fileItems = mm.getItems();
                        int k = 0;
                        while (k < fileItems.length) {
                            String itemId;
                            IContributionItem item = fileItems[k];
                            if (!item.isGroupMarker() && (itemId = item.getId()) != null && removeList.contains(itemId.intern())) {
                                mm.remove(item);
                            }
                            ++k;
                        }
                    }
                }
                ++i;
            }
            menuBar.update(true);
        }
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new RcpActionBarAdvisor(configurer);
    }
}

