/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.rcp.internal.base;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.UiDisplayData;
import com.ibm.mq.explorer.ui.rcp.internal.base.RcpPlugin;
import com.ibm.mq.explorer.ui.rcp.internal.base.RcpWorkbenchAdvisor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class RcpApplication
implements IApplication {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui.rcp/src/com/ibm/mq/explorer/ui/rcp/internal/base/RcpApplication.java";
    private static FileLock fileLock = null;
    private static Display display = null;

    public Object start(IApplicationContext context) throws Exception {
        Trace t = Trace.getDefault();
        Integer result = EXIT_OK;
        boolean success = true;
        int returnCode = 0;
        RcpWorkbenchAdvisor workbenchAdvisor = new RcpWorkbenchAdvisor();
        display = PlatformUI.createDisplay();
        UiDisplayData uiDisplayData = new UiDisplayData(1);
        display.setData((Object)uiDisplayData);
        this.handleMigration(t);
        if (!RcpApplication.claimSingleInstanceLock(t)) {
            MessageBox msgBox;
            Message msgFile = null;
            try {
                msgFile = CommonServices.loadSystemMessages((Trace)t);
            }
            catch (CommonServicesException e1) {
                Shell shell = new Shell(display);
                msgBox = new MessageBox(shell, 33);
                msgBox.setMessage(e1.getLocalizedMessage());
                msgBox.setText("IBM MQ Explorer");
                msgBox.open();
                success = false;
            }
            if (msgFile != null) {
                Shell shell = new Shell(display);
                String msg = msgFile.getMessage(t, "AMQ4574");
                msgBox = new MessageBox(shell, 33);
                msgBox.setMessage(msg);
                msgBox.setText("IBM MQ Explorer");
                msgBox.open();
                success = false;
                context.applicationRunning();
            } else {
                success = false;
            }
            if (Trace.isTracing) {
                t.data(67, "RcpApplication.start", 900, "unable to claim lock, MQ Explorer already running");
            }
        }
        if (success) {
            uiDisplayData.setFileLock(fileLock);
            try {
                returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)workbenchAdvisor);
                if (returnCode == 1) {
                    t.data(67, "RcpApplication.start", 300, "restarting");
                    result = EXIT_RESTART;
                }
            }
            catch (Throwable th) {
                t.FFST(67, "RcpApplication.start", 0, 50018, returnCode, 0, th.toString(), "", "");
            }
        }
        display.dispose();
        RcpApplication.releaseSingleInstanceLock(t);
        return result;
    }

    public static boolean claimSingleInstanceLock(Trace t) {
        boolean result;
        block10: {
            File directory;
            result = false;
            String workspaceLocation = RcpPlugin.getDefault().getStateLocation().toString();
            int index = workspaceLocation.lastIndexOf(46);
            if (index > 1) {
                workspaceLocation = workspaceLocation.substring(0, index);
            }
            if (!(directory = new File(workspaceLocation)).exists()) {
                if (Trace.isTracing) {
                    t.data(67, "RcpApplication.claimSingleInstanceLock", 300, "directory '" + workspaceLocation + "' does not exist - trying to create it");
                }
                if (!directory.mkdir() && Trace.isTracing) {
                    t.data(67, "RcpApplication.claimSingleInstanceLock", 900, "failed to create directory '" + workspaceLocation + "'");
                }
            }
            if (directory.exists()) {
                String filename = String.valueOf(workspaceLocation) + File.separator + "Explorer.lck";
                if (Trace.isTracing) {
                    t.data(67, "RcpApplication.claimSingleInstanceLock", 300, "trying to claim lock from file " + filename);
                }
                try {
                    File file = new File(filename);
                    FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
                    fileLock = channel.tryLock();
                    if (fileLock != null) {
                        result = true;
                        if (Trace.isTracing) {
                            t.data(67, "RcpApplication.claimSingleInstanceLock", 300, "lock claimed");
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!Trace.isTracing) break block10;
                    t.data(67, "RcpApplication.claimSingleInstanceLock", 900, "IOException claiming lock using file " + filename + Common.LINE_SEPARATOR + ioe);
                }
            }
        }
        return result;
    }

    public static void releaseSingleInstanceLock(Trace t) {
        block4: {
            if (fileLock != null) {
                try {
                    fileLock.release();
                    if (Trace.isTracing) {
                        t.data(67, "RcpApplication.releaseSingleInstanceLock", 300, "lock released");
                    }
                }
                catch (IOException ioe) {
                    if (!Trace.isTracing) break block4;
                    t.data(67, "RcpApplication.releaseSingleInstanceLock", 900, "IOException releasing lock" + Common.LINE_SEPARATOR + ioe);
                }
            }
        }
    }

    private void handleMigration(Trace t) {
        File directory;
        String workspaceLocation;
        int index;
        URL url;
        String location = "";
        Location instance = Platform.getInstanceLocation();
        if (instance != null && (url = instance.getURL()) != null) {
            location = url.getFile();
        }
        if ((index = (workspaceLocation = RcpPlugin.getDefault().getStateLocation().toString()).lastIndexOf(46)) > 1) {
            workspaceLocation = workspaceLocation.substring(0, index);
        }
        if (!(directory = new File(workspaceLocation)).exists()) {
            System.out.println("MQ Explorer: Using new workspace: " + location);
        } else {
            String lastVers = "?.?";
            File[] contents = directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().matches("^WMQ_[0-9]+\\.[0-9]+.*txt$");
                }
            });
            if (contents.length > 0) {
                String versionMarker = contents[0].getName().substring(4);
                String[] digits = versionMarker.split("\\.");
                try {
                    int version = Integer.valueOf(digits[0]);
                    int release = Integer.valueOf(digits[1]);
                    lastVers = String.valueOf(version) + "." + release;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            System.out.println("MQ Explorer: Using existing workspace: " + location + " (MQ " + lastVers + ")");
        }
    }

    public void stop() {
    }
}

