/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.rcp.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.rcp.internal.base.ExplorerShowViewMenu;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class RcpActionBarAdvisor
extends ActionBarAdvisor {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui.rcp/src/com/ibm/mq/explorer/ui/rcp/internal/base/RcpActionBarAdvisor.java";
    private Message msgFile = new Message(Trace.getDefault(), "com.ibm.mq.explorer.ui.rcp.internal.base.RcpExplorer", ((Object)((Object)this)).getClass().getClassLoader());
    private MenuManager fileMenu;
    private MenuManager editMenu;
    private MenuManager helpMenu;
    private MenuManager windowMenu;

    public RcpActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        Trace t = Trace.getDefault();
        this.fileMenu = this.createFileMenu(t, window);
        this.editMenu = this.createEditMenu(t, window);
        this.helpMenu = this.createHelpMenu(t, window);
        this.windowMenu = this.createWindowMenu(t, window);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        Trace.getDefault();
        menuBar.add((IContributionItem)this.fileMenu);
        menuBar.add((IContributionItem)this.editMenu);
        menuBar.add((IContributionItem)this.windowMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)this.helpMenu);
    }

    private MenuManager createFileMenu(Trace t, IWorkbenchWindow window) {
        ActionFactory.IWorkbenchAction saveAction = ActionFactory.SAVE.create(window);
        this.getActionBarConfigurer().registerGlobalAction((IAction)saveAction);
        MenuManager menu = new MenuManager(this.msgFile.getMessage("File"), "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        menu.add((IAction)saveAction);
        menu.add((IContributionItem)new Separator());
        ActionFactory.IWorkbenchAction refreshAction = ActionFactory.REFRESH.create(window);
        this.getActionBarConfigurer().registerGlobalAction((IAction)refreshAction);
        menu.add((IAction)refreshAction);
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IAction)ActionFactory.IMPORT.create(window));
        menu.add((IAction)ActionFactory.EXPORT.create(window));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)ActionFactory.QUIT.create(window));
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createEditMenu(Trace t, IWorkbenchWindow window) {
        ActionFactory.IWorkbenchAction cutAction = ActionFactory.CUT.create(window);
        this.getActionBarConfigurer().registerGlobalAction((IAction)cutAction);
        ActionFactory.IWorkbenchAction copyAction = ActionFactory.COPY.create(window);
        this.getActionBarConfigurer().registerGlobalAction((IAction)copyAction);
        ActionFactory.IWorkbenchAction pasteAction = ActionFactory.PASTE.create(window);
        this.getActionBarConfigurer().registerGlobalAction((IAction)pasteAction);
        ActionFactory.IWorkbenchAction deleteAction = ActionFactory.DELETE.create(window);
        this.getActionBarConfigurer().registerGlobalAction((IAction)deleteAction);
        ActionFactory.IWorkbenchAction selectAction = ActionFactory.SELECT_ALL.create(window);
        this.getActionBarConfigurer().registerGlobalAction((IAction)selectAction);
        MenuManager menu = new MenuManager(this.msgFile.getMessage("Edit"), "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add((IAction)cutAction);
        menu.add((IAction)copyAction);
        menu.add((IAction)pasteAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)deleteAction);
        menu.add((IAction)selectAction);
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        return menu;
    }

    private MenuManager createWindowMenu(Trace t, IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(this.msgFile.getMessage("Window"), "window");
        MenuManager viewMenu = new MenuManager(this.msgFile.getMessage("Show_View"));
        ExplorerShowViewMenu viewList = new ExplorerShowViewMenu(t, window);
        viewMenu.add((IContributionItem)viewList);
        menu.add((IContributionItem)viewMenu);
        menu.add((IContributionItem)new Separator());
        ActionFactory.IWorkbenchAction actionResetPerspective = ActionFactory.RESET_PERSPECTIVE.create(window);
        menu.add((IAction)actionResetPerspective);
        actionResetPerspective.setEnabled(true);
        menu.add((IContributionItem)new Separator());
        MenuManager navMenu = new MenuManager(this.msgFile.getMessage("Navigation"));
        navMenu.add((IAction)ActionFactory.SHOW_VIEW_MENU.create(window));
        navMenu.add((IContributionItem)new Separator());
        navMenu.add((IAction)ActionFactory.MAXIMIZE.create(window));
        navMenu.add((IAction)ActionFactory.MINIMIZE.create(window));
        navMenu.add((IContributionItem)new Separator());
        ActionFactory.IWorkbenchAction actionNextView = ActionFactory.NEXT_PART.create(window);
        ActionFactory.IWorkbenchAction actionPreviousView = ActionFactory.PREVIOUS_PART.create(window);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)actionNextView, (ActionFactory.IWorkbenchAction)actionPreviousView);
        navMenu.add((IAction)actionNextView);
        navMenu.add((IAction)actionPreviousView);
        menu.add((IContributionItem)navMenu);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IAction)ActionFactory.PREFERENCES.create(window));
        return menu;
    }

    private MenuManager createHelpMenu(Trace t, IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(this.msgFile.getMessage("Help"), "help");
        menu.add((IAction)ActionFactory.HELP_CONTENTS.create(window));
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)ActionFactory.ABOUT.create(window));
        return menu;
    }
}

