/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.rcp.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.views.IViewDescriptor;

public class ExplorerShowViewMenu
extends ContributionItem {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui.rcp/src/com/ibm/mq/explorer/ui/rcp/internal/base/ExplorerShowViewMenu.java";
    private static final String MQ_EXPLORER_PREFIX = "com.ibm.mq.explorer.";
    private IWorkbenchWindow window;
    private Comparator<IAction> actionComparator = new Comparator<IAction>(){

        @Override
        public int compare(IAction a1, IAction a2) {
            if (collator == null) {
                ExplorerShowViewMenu.collator = Collator.getInstance();
            }
            return collator.compare(a1.getText(), a2.getText());
        }
    };
    private static Collator collator;
    private Map<String, IAction> actions = new HashMap<String, IAction>();

    public ExplorerShowViewMenu(Trace t, IWorkbenchWindow window) {
        super("viewsShortlist");
        this.window = window;
    }

    public boolean isDynamic() {
        return true;
    }

    private void fillMenu(IMenuManager innerMgr) {
        innerMgr.removeAll();
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null || page.getPerspective() == null) {
            return;
        }
        List<String> viewIds = Arrays.asList(page.getShowViewShortcuts());
        ArrayList<IAction> explorerActions = new ArrayList<IAction>(viewIds.size());
        ArrayList<IAction> otherActions = new ArrayList<IAction>(viewIds.size());
        for (String id : viewIds) {
            IAction action = this.getAction(id);
            if (action == null || WorkbenchActivityHelper.filterItem((Object)action)) continue;
            if (id.startsWith(MQ_EXPLORER_PREFIX)) {
                explorerActions.add(action);
                continue;
            }
            otherActions.add(action);
        }
        Collections.sort(explorerActions, this.actionComparator);
        for (IAction action : explorerActions) {
            innerMgr.add(action);
        }
        if (otherActions.size() > 0) {
            innerMgr.add((IContributionItem)new Separator());
            Collections.sort(otherActions, this.actionComparator);
            for (IAction action : otherActions) {
                innerMgr.add(action);
            }
        }
    }

    private IAction getAction(String id) {
        IViewDescriptor desc;
        Object action = this.actions.get(id);
        if (action == null && (desc = this.window.getWorkbench().getViewRegistry().find(id)) != null) {
            action = new Action(){

                public void run() {
                    IWorkbenchPage page = ExplorerShowViewMenu.this.window.getActivePage();
                    if (page != null) {
                        try {
                            page.showView(desc.getId());
                        }
                        catch (PartInitException e) {
                            Message msgFile = new Message(Trace.getDefault(), "com.ibm.mq.explorer.ui.rcp.internal.base.RcpExplorer", ((Object)((Object)this)).getClass().getClassLoader());
                            ErrorDialog.openError((Shell)ExplorerShowViewMenu.this.window.getShell(), (String)msgFile.getMessage("ShowView_errorTitle"), (String)e.getMessage(), (IStatus)e.getStatus());
                        }
                    }
                }
            };
            action.setText(desc.getLabel());
            action.setToolTipText(desc.getLabel());
            action.setImageDescriptor(desc.getImageDescriptor());
            action.setActionDefinitionId(id);
            this.actions.put(id, (IAction)action);
        }
        return action;
    }

    public void fill(Menu menu, int startIndex) {
        MenuManager manager = new MenuManager();
        this.fillMenu((IMenuManager)manager);
        IContributionItem[] items = manager.getItems();
        int index = startIndex;
        int i = 0;
        while (i < items.length) {
            items[i].fill(menu, index++);
            ++i;
        }
    }
}

