/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.mapping.mqjms.pages;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.mapping.mqjms.MqJmsMappingPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.ConnectedQmgrsViewerFilter;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.SelectUiMQObjectDialog;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChooseQueueManagerWizPage
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.mapping.mqjms/src/com/ibm/mq/explorer/mapping/mqjms/pages/ChooseQueueManagerWizPage.java";
    public static final String PAGE_ID = "com.ibm.mq.explorer.wizard.page.choosequeuemanager";
    private static final int HORIZONTAL_SPAN = 6;
    private NewObjectWiz wizard;
    private UiQueueManager uiQueueManager;
    private Text queueManagerText;
    private ViewerFilter queueManagerFilter;
    private String pageTextString;
    private String informationTextString;

    public ChooseQueueManagerWizPage(Trace t, String title, String description, String pageTextString, String informationTextString, String helpId, String queueManagerName, UiQueueManager queueManager) {
        this(t, title, description, pageTextString, informationTextString, helpId, (ViewerFilter)new ConnectedQmgrsViewerFilter(queueManagerName), queueManager);
    }

    public ChooseQueueManagerWizPage(Trace t, String title, String description, String pageTextString, String informationTextString, String helpId, ViewerFilter qmFilter, UiQueueManager queueManager) {
        super(PAGE_ID, helpId);
        this.setHeadings(title, description);
        this.pageTextString = pageTextString;
        this.informationTextString = informationTextString;
        this.queueManagerFilter = qmFilter;
        this.uiQueueManager = queueManager;
    }

    public void createPageContent(final Trace t, Composite parent) {
        this.wizard = (NewObjectWiz)this.getWizard();
        Composite compositeMain = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        compositeMain.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        compositeMain.setLayoutData((Object)gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite(compositeMain, 768);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        UiUtils.createBlankLine((Composite)composite, (int)6);
        final Text pageText = new Text(composite, 66);
        pageText.setText(this.pageTextString);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)pageText, (boolean)false);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 300;
        layoutData.horizontalSpan = 6;
        pageText.setLayoutData((Object)layoutData);
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UiUtils.resizeControl((Trace)t, (Control)pageText);
            }
        });
        UiUtils.createBlankLine((Composite)composite, (int)6);
        Label label = new Label(composite, 0);
        String text = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseQueueManager.QueueManagerLabel");
        label.setText(text);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 6;
        label.setLayoutData((Object)layoutData);
        this.queueManagerText = new Text(composite, 2048);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.queueManagerText, (boolean)true);
        layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalSpan = 5;
        this.queueManagerText.setLayoutData((Object)layoutData);
        if (this.uiQueueManager != null) {
            String queueManagerName = this.uiQueueManager.toFormattedString();
            this.queueManagerText.setText(queueManagerName);
        }
        Button selectButton = new Button(composite, 8);
        text = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseQueueManager.SelectButton");
        selectButton.setText(text);
        layoutData = new GridData();
        layoutData.horizontalSpan = 1;
        layoutData.horizontalAlignment = 3;
        selectButton.setLayoutData((Object)layoutData);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChooseQueueManagerWizPage.this.selectQueueManager(t);
            }
        });
        UiUtils.createBlankLine((Composite)composite, (int)6);
        UiUtils.createInformationTextArea((Trace)t, (Composite)composite, (String)this.informationTextString, (int)6);
        Point size = composite.computeSize(-1, -1);
        scrolledComposite.setMinSize(size);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
    }

    public boolean performFinish() {
        return false;
    }

    public void checkIfEnableButtons() {
        if (this.uiQueueManager != null) {
            this.setPageComplete(true);
            this.setMessage(null);
        } else {
            String errorMessage = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseQueueManager.NotSelectedError");
            this.setMessage(errorMessage, 3);
        }
        this.wizard.setEnableFinish(false);
    }

    public void nextPressed() {
        Trace t = Trace.getDefault();
        NewObjectProvider newObjectProvider = this.wizard.getNewObjectProvider();
        newObjectProvider.setParent(t, (UiMQObject)this.uiQueueManager);
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    private void selectQueueManager(Trace t) {
        String dialogHelpId;
        String title;
        boolean result;
        Shell shell = this.getShell();
        SelectUiMQObjectDialog selDlg = new SelectUiMQObjectDialog(shell);
        if (this.uiQueueManager != null) {
            selDlg.setPreselectObjectName(this.uiQueueManager.toString());
        }
        if (result = selDlg.openToSelectQueueManager(t, title = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseQueueManager.SelectDialogTitle"), null, this.queueManagerFilter, dialogHelpId = "com.ibm.mq.explorer.mapping.mqjms.infopop.UI_NewObjectWizardChooseQueueManagerDialog")) {
            this.uiQueueManager = (UiQueueManager)selDlg.getSelectedObject();
        }
        if (this.uiQueueManager != null) {
            String queueManagerString = this.uiQueueManager.toFormattedString();
            this.queueManagerText.setText(queueManagerString);
        }
        this.checkIfEnableButtons();
    }
}

