/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.mapping.mqjms.pages;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.mapping.mqjms.MqJmsMappingPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ChooseObjectTypeWizPage
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.mapping.mqjms/src/com/ibm/mq/explorer/mapping/mqjms/pages/ChooseObjectTypeWizPage.java";
    public static final String PAGE_ID = "com.ibm.mq.explorer.wizard.page.chooseobjectype";
    private static final int HORIZONTAL_SPAN = 1;
    private String helpId;
    private NewObjectWiz wizard;
    private NewObjectProvider newObjectProvider;
    private String[] types;
    private int currentTypeIndex;
    private Text typeHelpText;
    private Combo typesCombo;
    private boolean initialised;

    public ChooseObjectTypeWizPage(Trace t, String title, String description, String helpId) {
        super(PAGE_ID);
        this.setHeadings(title, description);
        this.helpId = helpId;
    }

    public void createPageContent(final Trace t, Composite parent) {
        this.wizard = (NewObjectWiz)this.getWizard();
        this.newObjectProvider = this.wizard.getNewObjectProvider();
        UiUtils.setHelp((Control)parent, (String)this.helpId);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 1;
        composite.setLayoutData((Object)layoutData);
        UiUtils.createBlankLine((Composite)composite, (int)1);
        Label label = new Label(composite, 0);
        String text = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseObjectType.NameLabel");
        label.setText(text);
        layoutData = new GridData(768);
        label.setLayoutData((Object)layoutData);
        Text nameText = new Text(composite, 2048);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)nameText, (boolean)false);
        text = this.wizard.getNewObjectName();
        nameText.setText(text);
        layoutData = new GridData(768);
        nameText.setLayoutData((Object)layoutData);
        UiUtils.createBlankLine((Composite)composite, (int)1);
        UiUtils.createBlankLine((Composite)composite, (int)1);
        label = new Label(composite, 0);
        text = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseObjectType.ObjectTypeLabel");
        label.setText(text);
        layoutData = new GridData(768);
        label.setLayoutData((Object)layoutData);
        this.types = this.newObjectProvider.getNewObjectTypes(t);
        String[] typeStrings = new String[this.types.length];
        int i = 0;
        while (i < this.types.length) {
            typeStrings[i] = this.newObjectProvider.getNameForNewObjectType(t, this.types[i]);
            ++i;
        }
        this.typesCombo = new Combo(composite, 12);
        this.typesCombo.setItems(typeStrings);
        this.typesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseObjectTypeWizPage.this.setCurrentTypeIndex(t, ChooseObjectTypeWizPage.this.typesCombo.getSelectionIndex());
            }
        });
        layoutData = new GridData(768);
        this.typesCombo.setLayoutData((Object)layoutData);
        this.typeHelpText = new Text(composite, 2114);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.typeHelpText, (boolean)true);
        layoutData = new GridData(768);
        this.typeHelpText.setLayoutData((Object)layoutData);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UiUtils.resizeControl((Trace)t, (Control)ChooseObjectTypeWizPage.this.typeHelpText);
            }
        });
    }

    public boolean performFinish() {
        return true;
    }

    public void checkIfEnableButtons() {
        this.setPageComplete(true);
        this.wizard.setEnableFinish(false);
    }

    public void nextPressed() {
        this.wizard.setNewObjectTypeId(this.types[this.currentTypeIndex]);
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    private void setCurrentTypeIndex(Trace t, int newValue) {
        this.currentTypeIndex = newValue;
        this.updateHelpText(t);
    }

    private void updateHelpText(Trace t) {
        String currentType = this.types[this.currentTypeIndex];
        String text = this.newObjectProvider.getDescriptionForNewObjectType(t, currentType);
        if (text == null) {
            text = new String();
        }
        this.typeHelpText.setText(text);
        UiUtils.resizeControl((Trace)t, (Control)this.typeHelpText);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.initialised) {
            this.setCurrentTypeIndex(Trace.getDefault(), 0);
            this.typesCombo.select(this.currentTypeIndex);
            this.initialised = true;
        }
    }
}

