/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.mapping.mqjms.pages;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.SelectJmsContextDialog;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsContext;
import com.ibm.mq.explorer.mapping.mqjms.MqJmsMappingPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChooseJmsContextWizPage
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.mapping.mqjms/src/com/ibm/mq/explorer/mapping/mqjms/pages/ChooseJmsContextWizPage.java";
    public static final String PAGE_ID = "com.ibm.mq.explorer.wizard.page.choosejmscontext";
    private static final int HORIZONTAL_SPAN = 6;
    private NewObjectWiz wizard;
    private UiJmsContext uiJmsContext;
    private Text jmsContextText;
    private String pageTextString;
    private String informationTextString;
    private boolean selectPressed = false;

    public ChooseJmsContextWizPage(Trace t, String title, String description, String pageText, String informationText, String helpId) {
        super(PAGE_ID, helpId);
        this.setHeadings(title, description);
        this.pageTextString = pageText;
        this.informationTextString = informationText;
    }

    public void createPageContent(final Trace t, Composite parent) {
        this.wizard = (NewObjectWiz)this.getWizard();
        Composite compositeMain = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        compositeMain.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        compositeMain.setLayoutData((Object)gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite(compositeMain, 768);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        UiUtils.createBlankLine((Composite)composite, (int)6);
        final Text pageText = new Text(composite, 66);
        pageText.setText(this.pageTextString);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)pageText, (boolean)false);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 300;
        layoutData.horizontalSpan = 6;
        pageText.setLayoutData((Object)layoutData);
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UiUtils.resizeControl((Trace)t, (Control)pageText);
            }
        });
        UiUtils.createBlankLine((Composite)composite, (int)6);
        Label label = new Label(composite, 0);
        String text = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseJmsContext.JmsContextLabel");
        label.setText(text);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 6;
        label.setLayoutData((Object)layoutData);
        this.jmsContextText = new Text(composite, 2048);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.jmsContextText, (boolean)true);
        layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalSpan = 5;
        this.jmsContextText.setLayoutData((Object)layoutData);
        String jmsContextName = this.getJmsContextName(t);
        this.jmsContextText.setText(jmsContextName);
        Button selectButton = new Button(composite, 8);
        text = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseJmsContext.SelectButton");
        selectButton.setText(text);
        layoutData = new GridData();
        layoutData.horizontalSpan = 1;
        layoutData.horizontalAlignment = 3;
        selectButton.setLayoutData((Object)layoutData);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChooseJmsContextWizPage.this.selectJmsContext(t);
            }
        });
        UiUtils.createBlankLine((Composite)composite, (int)6);
        UiUtils.createInformationTextArea((Trace)t, (Composite)composite, (String)this.informationTextString, (int)6);
        Point size = composite.computeSize(-1, -1);
        scrolledComposite.setMinSize(size);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
    }

    public boolean performFinish() {
        return false;
    }

    public void checkIfEnableButtons() {
        if (this.uiJmsContext != null) {
            this.setPageComplete(true);
            this.setMessage(null);
        } else if (this.selectPressed) {
            String errorMessage = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseJmsContext.NotSelectedError");
            this.setMessage(errorMessage, 3);
        }
        this.wizard.setEnableFinish(false);
    }

    public void nextPressed() {
        Trace t = Trace.getDefault();
        NewObjectProvider newObjectProvider = this.wizard.getNewObjectProvider();
        newObjectProvider.setParent(t, (UiMQObject)this.uiJmsContext);
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    private void selectJmsContext(Trace t) {
        Shell shell = this.getShell();
        String title = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseJmsContext.SelectDialogTitle");
        String helpId = "com.ibm.mq.explorer.mapping.mqjms.infopop.UI_NewObjectWizardChooseJmsContextDialog";
        SelectJmsContextDialog dialog = new SelectJmsContextDialog(t, shell, title, helpId);
        if (this.uiJmsContext != null) {
            dialog.selectContext((DmJmsAbstractContext)this.uiJmsContext.getDmObject());
        }
        if (dialog.open(t)) {
            this.uiJmsContext = dialog.getSelectedContext(t);
        }
        this.selectPressed = true;
        String jmsContextName = this.getJmsContextName(t);
        this.jmsContextText.setText(jmsContextName);
        this.checkIfEnableButtons();
    }

    private String getJmsContextName(Trace t) {
        String name = null;
        if (this.uiJmsContext != null) {
            DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)this.uiJmsContext.getDmObject();
            name = dmJmsContext.getFullName(t);
        }
        if (name == null) {
            name = new String();
        }
        return name;
    }
}

