/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.mapping.mqjms.mappers;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractDestination;
import com.ibm.mq.explorer.jmsadmin.ui.internal.destinations.NewDestinationObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.properties.mapping.AbstractPropertyMapper;
import com.ibm.mq.explorer.ui.internal.properties.mapping.ClassNotSupportedException;
import com.ibm.mq.explorer.ui.internal.properties.mapping.MappedProperty;
import com.ibm.mq.explorer.ui.internal.properties.mapping.UnableToUseMappingObjectException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;

public abstract class MqToJmsDestinationPropertyMapper
extends AbstractPropertyMapper {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.mapping.mqjms/src/com/ibm/mq/explorer/mapping/mqjms/mappers/MqToJmsDestinationPropertyMapper.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static DateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");

    public Collection<String> getRequiredPlugins() {
        ArrayList<String> plugins = new ArrayList<String>();
        plugins.add("com.ibm.mq.explorer.qmgradmin");
        plugins.add("com.ibm.mq.explorer.jmsadmin");
        return plugins;
    }

    public Collection<MappedProperty> map(Trace t, IDmObject from) throws ClassNotSupportedException {
        Class<?> fromClass = from.getClass();
        this.checkSupportedClasses(t, fromClass);
        ArrayList<MappedProperty> mappedProperties = new ArrayList<MappedProperty>();
        this.mapCcsid(t, from, mappedProperties);
        return mappedProperties;
    }

    protected void mapParentProperty(Trace t, IDmObject from, int fromId, int toId, Collection<MappedProperty> properties) {
        DmQueueManager fromParent = from.getQueueManager();
        String fromValue = fromParent.getAttributeValue(t, fromId, 0);
        AttrType fromAttrType = DmQueueManager.getAttributeType((Trace)t, (int)fromId);
        String toValue = fromValue;
        AttrType toAttrType = DmJmsAbstractDestination.getAttributeType((Trace)t, (int)toId);
        this.mapProperty(fromId, fromValue, fromAttrType, toId, toValue, toAttrType, properties);
    }

    private void mapCcsid(Trace t, IDmObject from, Collection<MappedProperty> properties) {
        int fromId = 2;
        DmQueueManager fromParent = from.getQueueManager();
        String fromValue = fromParent.getAttributeValue(t, fromId, 0);
        AttrType fromAttrType = DmQueueManager.getAttributeType((Trace)t, (int)fromId);
        int toId = 13011;
        Integer toValue = Integer.valueOf(fromValue);
        AttrType toAttrType = DmJmsAbstractDestination.getAttributeType((Trace)t, (int)toId);
        this.mapProperty(fromId, fromValue, fromAttrType, toId, toValue, toAttrType, properties);
    }

    protected void mapDescription(Trace t, String description, IDmObject from, Collection<MappedProperty> properties) {
        int fromId = -1;
        Object fromValue = null;
        AttrType fromAttrType = null;
        int toId = 13021;
        String toValue = description;
        String queueName = from.getTitle();
        DmQueueManager queueManager = from.getQueueManager();
        String queueManagerName = queueManager.getTitle();
        long currentTimeMillis = System.currentTimeMillis();
        Date currentTime = new Date(currentTimeMillis);
        String timestamp = dateFormat.format(currentTime);
        toValue = Message.format((String)toValue, (String)queueName, (String)queueManagerName, (String)timestamp);
        AttrType toAttrType = DmJmsAbstractDestination.getAttributeType((Trace)t, (int)toId);
        this.mapProperty(fromId, fromValue, fromAttrType, toId, toValue, toAttrType, properties);
    }

    public void validateFromObject(Trace t, IDmObject from) throws UnableToUseMappingObjectException {
    }

    public int getNewObjectNameId() {
        return 2016;
    }

    public String[] getPageIds(Trace t, String typeId, NewObjectProvider newObjectProvider, String[] defaultPageIds) {
        String[] pageIds = null;
        ArrayList<String> newPageIds = new ArrayList<String>();
        newPageIds.add("com.ibm.mq.explorer.wizard.page.choosejmscontext");
        String[] oldPageIds = null;
        oldPageIds = defaultPageIds != null ? defaultPageIds : NewObjectWiz.DEFAULT_PAGE_IDS;
        newPageIds.addAll(Arrays.asList(oldPageIds));
        pageIds = new String[newPageIds.size()];
        pageIds = newPageIds.toArray(pageIds);
        return pageIds;
    }

    public NewObjectProvider getToNewObjectProvider(Trace t) {
        return new NewDestinationObjectProvider(t, null);
    }

    public String getToObjectId(Trace t) {
        return "com.ibm.mq.explorer.jmsadmin.JMSDestination";
    }
}

