/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.mapping.mqjms.mappers;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractDestination;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsQueue;
import com.ibm.mq.explorer.mapping.mqjms.MqJmsMappingPlugin;
import com.ibm.mq.explorer.mapping.mqjms.mappers.JmsToMqDestinationPropertyMapper;
import com.ibm.mq.explorer.mapping.mqjms.pages.ChooseObjectTypeWizPage;
import com.ibm.mq.explorer.mapping.mqjms.pages.ChooseQueueManagerWizPage;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.queues.UiQueueNewObjectProvider;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWizPage1;
import com.ibm.mq.explorer.ui.internal.properties.mapping.ClassNotSupportedException;
import com.ibm.mq.explorer.ui.internal.properties.mapping.UnableToUseMappingObjectException;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.Collection;

public class JmsToMqQueuePropertyMapper
extends JmsToMqDestinationPropertyMapper {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.mapping.mqjms/src/com/ibm/mq/explorer/mapping/mqjms/mappers/JmsToMqQueuePropertyMapper.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final Class SUPPORTED_FROM_CLASS = DmJmsQueue.class;
    private static final Class SUPPORTED_TO_CLASS = DmQueue.class;

    public Class getSupportedFromClass() {
        return SUPPORTED_FROM_CLASS;
    }

    public Class getSupportedToClass() {
        return SUPPORTED_TO_CLASS;
    }

    public void validateFromObject(Trace t, IDmObject from) throws UnableToUseMappingObjectException {
        UiQueueManager[] queueManagers;
        String requiredQueueManagerName = this.getWantedQueueManagerName(t, from);
        if (requiredQueueManagerName != null && requiredQueueManagerName.length() > 0 && ((queueManagers = QmgradminPlugin.getMatchingQueueManagers((Trace)t, (String)requiredQueueManagerName)) == null || queueManagers.length == 0)) {
            String message = "AMQ4451";
            int queueManagerAttributeId = 13043;
            Attr queueManagerAttr = from.getAttribute(t, queueManagerAttributeId, 0);
            AttrType queueManagerAttrType = queueManagerAttr.getAttrType();
            String queueManagerPropertyTitle = queueManagerAttrType.getDisplayTitle();
            String objectName = from.getTitle();
            String[] inserts = new String[]{queueManagerPropertyTitle, objectName, requiredQueueManagerName};
            throw new UnableToUseMappingObjectException(message, inserts);
        }
    }

    @Override
    public Collection map(Trace t, IDmObject from) throws ClassNotSupportedException {
        Collection mappedProperties = super.map(t, from);
        this.mapPersistence(t, from, mappedProperties);
        this.mapQueueManager(t, from, mappedProperties);
        this.mapQueue(t, from, mappedProperties);
        this.mapReadAheadAllowed(t, from, mappedProperties);
        this.mapDescription(t, from, mappedProperties);
        return mappedProperties;
    }

    @Override
    protected void mapProperty(Trace t, int fromId, Object fromValue, int toId, Object toValue, Collection properties) {
        AttrType fromAttrType = DmJmsAbstractDestination.getAttributeType((Trace)t, (int)fromId);
        AttrType toAttrType = DmQueue.getAttributeType((Trace)t, (int)toId);
        this.mapProperty(fromId, fromValue, fromAttrType, toId, toValue, toAttrType, properties);
    }

    private void mapPersistence(Trace t, IDmObject from, Collection properties) {
        int fromIdPersistence = 13035;
        Object fromValuePersistence = this.getInternalJmsValue(t, (DmJmsObject)from, fromIdPersistence);
        if (fromValuePersistence != null) {
            int fromValuePersistenceInt = (Integer)fromValuePersistence;
            int toIdPersistence = 5;
            Integer newPersistence = null;
            if (fromValuePersistenceInt == 2) {
                newPersistence = 1;
                this.mapProperty(t, from, fromIdPersistence, toIdPersistence, (Object)newPersistence, properties);
            } else if (fromValuePersistenceInt == 1) {
                newPersistence = 0;
                this.mapProperty(t, from, fromIdPersistence, toIdPersistence, (Object)newPersistence, properties);
            } else if (fromValuePersistenceInt == 3) {
                newPersistence = 0;
                this.mapProperty(t, from, fromIdPersistence, toIdPersistence, (Object)newPersistence, properties);
                Integer newNpmClass = 10;
                this.mapProperty(t, from, fromIdPersistence, 78, (Object)newNpmClass, properties);
            }
        }
    }

    private void mapQueueManager(Trace t, IDmObject from, Collection properties) {
        int fromIdQueueManager = 13043;
        String fromValueQueueManager = from.getAttributeValue(t, fromIdQueueManager, 0);
        if (fromValueQueueManager != null && fromValueQueueManager.length() > 0) {
            this.mapProperty(t, from, fromIdQueueManager, 2015, properties);
        }
    }

    private void mapQueue(Trace t, IDmObject from, Collection properties) {
        this.mapProperty(t, from, 13044, 2016, properties);
    }

    private void mapReadAheadAllowed(Trace t, IDmObject from, Collection properties) {
        int fromIdReadAheadAllowed = 13077;
        Object fromValueReadAheadAllowed = this.getInternalJmsValue(t, (DmJmsObject)from, fromIdReadAheadAllowed);
        if (fromValueReadAheadAllowed != null) {
            int fromValueReadAheadAllowedInt = (Integer)fromValueReadAheadAllowed;
            Integer newReadAheadAllowed = null;
            int toIdReadAheadAllowed = 188;
            if (fromValueReadAheadAllowedInt == 1) {
                newReadAheadAllowed = 1;
                this.mapProperty(t, from, fromIdReadAheadAllowed, toIdReadAheadAllowed, (Object)newReadAheadAllowed, properties);
            } else if (fromValueReadAheadAllowedInt == 0) {
                newReadAheadAllowed = 0;
                this.mapProperty(t, from, fromIdReadAheadAllowed, toIdReadAheadAllowed, (Object)newReadAheadAllowed, properties);
            }
        }
    }

    private void mapDescription(Trace t, IDmObject from, Collection properties) {
        int toIdDescription = 2013;
        AttrTypeFixedLengthString toAttributeTypeDescription = (AttrTypeFixedLengthString)DmQueue.getAttributeType((Trace)t, (int)toIdDescription);
        this.mapDescription(t, from, toIdDescription, toAttributeTypeDescription, properties);
    }

    @Override
    protected String getWantedQueueManagerName(Trace t, IDmObject from) {
        int queueManagerAttributeId = 13043;
        String queueManager = from.getAttributeValue(t, queueManagerAttributeId, 0);
        return queueManager;
    }

    @Override
    public String[] getPageIds(Trace t, String typeId, NewObjectProvider newObjectProvider, String[] defaultPageIds) {
        String[] pageIds = null;
        String[] oldPageIds = super.getPageIds(t, typeId, newObjectProvider, defaultPageIds);
        int index = 0;
        int i = 0;
        while (i < oldPageIds.length) {
            if (oldPageIds[i] == "com.ibm.mq.explorer.wizard.page.choosequeuemanager") {
                index = i + 1;
            }
            ++i;
        }
        pageIds = new String[oldPageIds.length + 1];
        i = 0;
        while (i < index) {
            pageIds[i] = oldPageIds[i];
            ++i;
        }
        pageIds[index] = "com.ibm.mq.explorer.wizard.page.chooseobjectype";
        i = index + 1;
        while (i < pageIds.length) {
            pageIds[i] = oldPageIds[i - 1];
            ++i;
        }
        return pageIds;
    }

    public WizPage getWizardPage(Trace t, String pageId, NewObjectWiz wizard, NewObjectProvider newObjectProvider, IDmObject from) {
        WizPage wizPage = null;
        String title = MqJmsMappingPlugin.getMessage("MqJms.Wizard.NewMqQueue.Title");
        if (pageId.equals("com.ibm.mq.explorer.wizard.page.choosequeuemanager")) {
            String description = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseQueueManager.Description.Queue");
            String pageText = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseQueueManager.ExplanatoryText.Queue");
            String oldObjectName = from.getTitle();
            String newObjectName = wizard.getNewObjectName();
            pageText = Message.format((String)pageText, (String)oldObjectName, (String)newObjectName);
            String informationText = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseQueueManager.InformationText.Queue");
            String helpId = "com.ibm.mq.explorer.mapping.mqjms.infopop.UI_NewObjectWizardJmsToMqQueue";
            String wantedQueueManagerName = this.getWantedQueueManagerName(t, from);
            UiQueueManager[] queueManagers = QmgradminPlugin.getMatchingQueueManagers((Trace)t, (String)wantedQueueManagerName);
            UiQueueManager queueManager = null;
            if (queueManagers != null && queueManagers.length > 0) {
                queueManager = queueManagers[0];
            }
            wizPage = new ChooseQueueManagerWizPage(t, title, description, pageText, informationText, helpId, wantedQueueManagerName, queueManager);
        } else if (pageId.equals("com.ibm.mq.explorer.wizard.page.chooseobjectype")) {
            String description = MqJmsMappingPlugin.getMessage("MqJms.WizPage.ChooseObjectType.Description.Queue");
            String helpId = "com.ibm.mq.explorer.mapping.mqjms.infopop.UI_NewObjectWizardMqQueueTypes";
            wizPage = new ChooseObjectTypeWizPage(t, title, description, helpId);
        } else if (pageId.equals("PAGE_STD_SELECT_LIKE_OBJECT")) {
            String helpId = "com.ibm.mq.explorer.mapping.mqjms.infopop.UI_NewObjectWizardPropertyMappingMqToJmsQueue";
            wizPage = new NewObjectWizPage1(t, pageId, helpId);
        }
        return wizPage;
    }

    public int getNewObjectNameId() {
        return 13044;
    }

    public String getStartMappingWizardText() {
        return MqJmsMappingPlugin.getMessage("MqJms.Wizard.StartMapping.ToMqQueue");
    }

    public NewObjectProvider getToNewObjectProvider(Trace t) {
        return new UiQueueNewObjectProvider(t, null);
    }

    public String getToObjectId(Trace t) {
        return "com.ibm.mq.explorer.queue";
    }
}

