/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.mapping.mqjms.mappers;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.mapping.mqjms.MqJmsMappingPlugin;
import com.ibm.mq.explorer.mapping.mqjms.mappers.JmsToMqPropertyMapper;
import com.ibm.mq.explorer.ui.internal.properties.mapping.ClassNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;

public abstract class JmsToMqDestinationPropertyMapper
extends JmsToMqPropertyMapper {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.mapping.mqjms/src/com/ibm/mq/explorer/mapping/mqjms/mappers/JmsToMqDestinationPropertyMapper.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";

    public Collection map(Trace t, IDmObject from) throws ClassNotSupportedException {
        Class<?> fromClass = from.getClass();
        this.checkSupportedClasses(t, fromClass);
        ArrayList mappedProperties = new ArrayList();
        this.mapPriority(t, from, mappedProperties);
        this.mapPutAsyncAllowed(t, from, mappedProperties);
        return mappedProperties;
    }

    protected void mapDescription(Trace t, IDmObject from, int toId, AttrTypeFixedLengthString toAttributeType, Collection properties) {
        int maxLength;
        String namePrefix;
        String jmsName = from.getTitle();
        String newDescriptionWithoutName = MqJmsMappingPlugin.getMessage("MqJms.PropertyMapping.JmsToMqDestination.Description");
        String newDescription = Message.format((String)newDescriptionWithoutName, (String)(namePrefix = new String()), (String)jmsName);
        int currentLength = newDescription.length();
        if (currentLength > (maxLength = toAttributeType.getLength())) {
            namePrefix = MqJmsMappingPlugin.getMessage("MqJms.PropertyMapping.JmsToMqDestination.DescriptionNamePrefix");
            int extraLength = currentLength - maxLength + namePrefix.length();
            jmsName = jmsName.substring(extraLength);
            newDescription = Message.format((String)newDescriptionWithoutName, (String)namePrefix, (String)jmsName);
        }
        this.mapProperty(t, from, 13021, toId, (Object)newDescription, properties);
    }

    private void mapPriority(Trace t, IDmObject from, Collection properties) {
        int fromValuePriorityInt;
        int fromIdPriority = 13038;
        Object fromValuePriority = this.getInternalJmsValue(t, (DmJmsObject)from, fromIdPriority);
        if (fromValuePriority != null && (fromValuePriorityInt = ((Integer)fromValuePriority).intValue()) != -2 && fromValuePriorityInt != -1) {
            this.mapProperty(t, from, fromIdPriority, 6, properties);
        }
    }

    private void mapPutAsyncAllowed(Trace t, IDmObject from, Collection properties) {
        int fromIdPutAsyncAllowed = 13076;
        Object fromValuePutAsyncAllowed = this.getInternalJmsValue(t, (DmJmsObject)from, fromIdPutAsyncAllowed);
        if (fromValuePutAsyncAllowed != null) {
            int fromValuePutAsyncAllowedInt = (Integer)fromValuePutAsyncAllowed;
            Integer newPutAsyncAllowed = null;
            int toIdPutAsyncAllowed = 184;
            if (fromValuePutAsyncAllowedInt == 1) {
                newPutAsyncAllowed = 2;
                this.mapProperty(t, from, fromIdPutAsyncAllowed, toIdPutAsyncAllowed, (Object)newPutAsyncAllowed, properties);
            } else if (fromValuePutAsyncAllowedInt == 0) {
                newPutAsyncAllowed = 1;
                this.mapProperty(t, from, fromIdPutAsyncAllowed, toIdPutAsyncAllowed, (Object)newPutAsyncAllowed, properties);
            }
        }
    }
}

