/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.mapping.mqjms.mappers;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractConnectionFactory;
import com.ibm.mq.explorer.mapping.mqjms.mappers.JmsToMqPropertyMapper;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.properties.mapping.ClassNotSupportedException;
import com.ibm.mq.explorer.ui.internal.properties.mapping.UnableToUseMappingObjectException;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import java.util.ArrayList;
import java.util.Collection;

public class JmsConnectionFactoryToMqQueueManagerPropertyMapper
extends JmsToMqPropertyMapper {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.mapping.mqjms/src/com/ibm/mq/explorer/mapping/mqjms/mappers/JmsConnectionFactoryToMqQueueManagerPropertyMapper.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final Class SUPPORTED_FROM_CLASS = DmJmsAbstractConnectionFactory.class;
    private static final Class SUPPORTED_TO_CLASS = DmQueueManager.class;
    public static final char QUEUE_MANAGER_NAME_WILDCARD = '*';
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String DEFAULT_CHANNEL = "SYSTEM.DEF.SVRCONN";

    public Class getSupportedFromClass() {
        return SUPPORTED_FROM_CLASS;
    }

    public Class getSupportedToClass() {
        return SUPPORTED_TO_CLASS;
    }

    public void validateFromObject(Trace t, IDmObject from) throws UnableToUseMappingObjectException {
        boolean validName = false;
        String name = this.getNewObjectName(t, from);
        if (name.equals(Character.toString('*'))) {
            validName = true;
        } else {
            if (name.startsWith(Character.toString('*'))) {
                name = name.substring(1);
            }
            validName = StringValidation.isValidMQQueueManagerName((Trace)t, (String)name);
        }
        if (!validName) {
            String messageId = "AMQ4463";
            int queueManagerAttributeId = this.getNewObjectNameId();
            Attr queueManagerAttribute = from.getAttribute(t, queueManagerAttributeId, 0);
            AttrType queueManagerAttributeType = queueManagerAttribute.getAttrType();
            String queueManagerAttributeTitle = queueManagerAttributeType.getDisplayTitle();
            String connectionFactoryName = from.getTitle();
            String[] inserts = new String[]{queueManagerAttributeTitle, connectionFactoryName, name};
            throw new UnableToUseMappingObjectException(messageId, inserts);
        }
    }

    @Override
    protected void mapProperty(Trace t, int fromId, Object fromValue, int toId, Object toValue, Collection properties) {
        AttrType fromAttrType = DmJmsAbstractConnectionFactory.getAttributeType((Trace)t, (int)fromId);
        AttrType toAttrType = DmQueueManager.getAttributeType((Trace)t, (int)toId);
        this.mapProperty(fromId, fromValue, fromAttrType, toId, toValue, toAttrType, properties);
    }

    public Collection map(Trace t, IDmObject from) throws ClassNotSupportedException {
        Class<?> fromClass = from.getClass();
        this.checkSupportedClasses(t, fromClass);
        ArrayList mappedProperties = new ArrayList();
        this.mapRefreshInterval(t, mappedProperties);
        this.mapAutoConnect(t, mappedProperties);
        this.mapCcdtUrl(t, from, mappedProperties);
        this.mapConnName(t, from, mappedProperties);
        this.mapChannel(t, from, mappedProperties);
        return mappedProperties;
    }

    private void mapRefreshInterval(Trace t, Collection properties) {
        int toId = 11011;
        AttrType refreshIntAttrType = DmQueueManagerHandle.getAttributeType((Trace)t, (int)toId);
        Object toValue = refreshIntAttrType.getDefaultValue(t);
        this.mapProperty(t, -1, null, toId, toValue, properties);
    }

    private void mapAutoConnect(Trace t, Collection properties) {
        int toId = 11012;
        AttrType refreshIntAttrType = DmQueueManagerHandle.getAttributeType((Trace)t, (int)toId);
        Object toValue = refreshIntAttrType.getDefaultValue(t);
        this.mapProperty(t, -1, null, toId, toValue, properties);
    }

    private void mapCcdtUrl(Trace t, IDmObject from, Collection properties) {
        int fromId = 13010;
        int toId = 11010;
        this.mapProperty(t, from, fromId, toId, properties);
    }

    private void mapConnName(Trace t, IDmObject from, Collection properties) {
        int toId = 11002;
        String connNameList = from.getAttributeValue(t, 13122, 0);
        if (connNameList == null || connNameList.length() == 0) {
            connNameList = "localhost(1414)";
        }
        this.mapProperty(t, -1, null, toId, (Object)connNameList, properties);
    }

    private void mapChannel(Trace t, IDmObject from, Collection properties) {
        int fromId = 13012;
        String fromValue = from.getAttributeValue(t, fromId, 0);
        int toId = 11003;
        String toValue = fromValue;
        if (toValue == null || toValue.length() == 0) {
            toValue = DEFAULT_CHANNEL;
        }
        this.mapProperty(t, fromId, fromValue, toId, (Object)toValue, properties);
    }

    public int getNewObjectNameId() {
        return 13043;
    }

    public String getNewObjectName(Trace t, IDmObject from) {
        String name = super.getNewObjectName(t, from);
        if (name == null || name.length() == 0) {
            name = Character.toString('*');
        }
        return name;
    }

    public String getStartMappingWizardText() {
        return null;
    }

    public NewObjectProvider getToNewObjectProvider(Trace t) {
        return null;
    }

    public String getToObjectId(Trace t) {
        return null;
    }

    @Override
    public String[] getPageIds(Trace t, String typeId, NewObjectProvider newObjectProvider, String[] defaultPageIds) {
        return null;
    }

    public WizPage getWizardPage(Trace t, String pageId, NewObjectWiz wizard, NewObjectProvider newObjectProvider, IDmObject from) {
        return null;
    }
}

