/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.mapping.mqjms.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmTopic;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsQueue;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsTopic;
import com.ibm.mq.explorer.jmsadmin.ui.internal.destinations.NewDestinationObjectProvider;
import com.ibm.mq.explorer.mapping.mqjms.actions.AddQueueManagerAction;
import com.ibm.mq.explorer.mapping.mqjms.mappers.JmsConnectionFactoryToMqQueueManagerPropertyMapper;
import com.ibm.mq.explorer.mapping.mqjms.mappers.JmsToMqQueuePropertyMapper;
import com.ibm.mq.explorer.mapping.mqjms.mappers.JmsToMqTopicPropertyMapper;
import com.ibm.mq.explorer.qmgradmin.internal.queues.UiQueueNewObjectProvider;
import com.ibm.mq.explorer.qmgradmin.internal.topics.UiTopicNewObjectProvider;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWizStarter;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.mapping.IPropertyMapper;
import com.ibm.mq.explorer.ui.internal.properties.mapping.UnableToUseMappingObjectException;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class MappingActions
implements IActionDelegate {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.mapping.mqjms/src/com/ibm/mq/explorer/mapping/mqjms/actions/MappingActions.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String ACTION_JMS_TO_MQ_QUEUE = "com.ibm.mq.explorer.mapping.mqjms.JmsToMqQueue";
    public static final String ACTION_JMS_TO_MQ_TOPIC = "com.ibm.mq.explorer.mapping.mqjms.JmsToMqTopic";
    public static final String ACTION_MQ_TO_JMS_QUEUE = "com.ibm.mq.explorer.mapping.mqjms.MqToJmsQueue";
    public static final String ACTION_MQ_TO_JMS_TOPIC = "com.ibm.mq.explorer.mapping.mqjms.MqToJmsTopic";
    public static final String ACTION_JMS_CONNECTION_FACTORY_TO_MQ_QUEUE_MANAGER = "com.ibm.mq.explorer.mapping.mqjms.JmsConnectionFactoryToMqQueueManager";
    private MQExtObject selectedObject;

    public void run(IAction action) {
        Trace t = Trace.getDefault();
        Shell shell = UiPlugin.getShell();
        String actionId = action.getId();
        UiMQObject uiObject = (UiMQObject)this.selectedObject.getInternalObject();
        IDmObject dmObject = uiObject.getDmObject();
        if (actionId.equals(ACTION_JMS_TO_MQ_QUEUE)) {
            if (dmObject instanceof DmJmsQueue) {
                this.createMQQueue(t, (DmJmsQueue)dmObject, shell);
            } else {
                t.FFST(66, "MappingActions.run", 0, 50022, "Object type '" + dmObject.getClass() + "' not supported");
            }
        } else if (actionId.equals(ACTION_JMS_TO_MQ_TOPIC)) {
            if (dmObject instanceof DmJmsTopic) {
                this.createMQTopic(t, (DmJmsTopic)dmObject, shell);
            } else {
                t.FFST(66, "MappingActions.run", 1, 50022, "Object type '" + dmObject.getClass() + "' not supported");
            }
        } else if (actionId.equals(ACTION_MQ_TO_JMS_QUEUE)) {
            if (dmObject instanceof DmQueue) {
                this.createJmsDestination(t, dmObject, shell);
            } else {
                t.FFST(66, "MappingActions.run", 2, 50022, "Object type '" + dmObject.getClass() + "' not supported");
            }
        } else if (actionId.equals(ACTION_MQ_TO_JMS_TOPIC)) {
            if (dmObject instanceof DmTopic) {
                this.createJmsDestination(t, dmObject, shell);
            } else {
                t.FFST(66, "MappingActions.run", 3, 50022, "Object type '" + dmObject.getClass() + "' not supported");
            }
        } else if (actionId.equals(ACTION_JMS_CONNECTION_FACTORY_TO_MQ_QUEUE_MANAGER)) {
            if (dmObject instanceof DmJmsAbstractConnectionFactory) {
                this.addMqQueueManager(t, (DmJmsAbstractConnectionFactory)dmObject, shell);
            } else {
                t.FFST(66, "MappingActions.run", 4, 50022, "Object type '" + dmObject.getClass() + "' not supported");
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null && object instanceof MQExtObject) {
            this.selectedObject = (MQExtObject)object;
        }
    }

    private void createMQQueue(Trace t, DmJmsQueue dmJmsQueue, Shell shell) {
        UiQueueNewObjectProvider newObjectProvider = null;
        String objectId = null;
        JmsToMqQueuePropertyMapper propertyMapper = new JmsToMqQueuePropertyMapper();
        String name = propertyMapper.getNewObjectName(t, (IDmObject)dmJmsQueue);
        boolean validName = StringValidation.isValidMQQueueName((Trace)t, (String)name);
        if (validName) {
            newObjectProvider = new UiQueueNewObjectProvider(t, null);
            objectId = "com.ibm.mq.explorer.queue";
            this.startMappingWizard(t, (NewObjectProvider)newObjectProvider, shell, (IDmObject)dmJmsQueue, objectId);
        } else if (name.equals("")) {
            this.showEmptyQueueError(t, shell, (IDmObject)dmJmsQueue, 13044);
        } else {
            this.showInvalidMqNameError(t, shell, (IDmObject)dmJmsQueue, 13044);
        }
    }

    private void createMQTopic(Trace t, DmJmsTopic dmJmsTopic, Shell shell) {
        boolean validName;
        UiTopicNewObjectProvider newObjectProvider = null;
        String objectId = null;
        JmsToMqTopicPropertyMapper propertyMapper = new JmsToMqTopicPropertyMapper();
        String name = propertyMapper.getNewObjectName(t, (IDmObject)dmJmsTopic);
        boolean bl = validName = name.length() == 0 || StringValidation.isValidMQTopicName((Trace)t, (String)name);
        if (validName) {
            newObjectProvider = new UiTopicNewObjectProvider(t, null);
            objectId = "com.ibm.mq.explorer.topic";
            this.startMappingWizard(t, (NewObjectProvider)newObjectProvider, shell, (IDmObject)dmJmsTopic, objectId);
        } else {
            this.showInvalidMqNameError(t, shell, (IDmObject)dmJmsTopic, 13100);
        }
    }

    private void showEmptyQueueError(Trace t, Shell shell, IDmObject dmObject, int attributeId) {
        String helpID = "AMQ4499";
        String message = CommonServices.getSystemMessage((String)helpID);
        String objectName = dmObject.getTitle();
        message = Message.format((String)message, (String)objectName);
        MessageBox.showMessageFailure((Trace)t, (Shell)shell, (String)message, (String)helpID);
    }

    private void showInvalidMqNameError(Trace t, Shell shell, IDmObject dmObject, int attributeId) {
        String helpID = "AMQ4457";
        String message = CommonServices.getSystemMessage((String)helpID);
        String objectName = dmObject.getTitle();
        Attr nameAttribute = dmObject.getAttribute(t, attributeId, 0);
        String name = (String)nameAttribute.getValue(t);
        AttrType nameAttributeType = nameAttribute.getAttrType();
        String nameAttributeTitle = nameAttributeType.getDisplayTitle();
        message = Message.format((String)message, (String)name, (String)nameAttributeTitle, (String)objectName);
        MessageBox.showMessageFailure((Trace)t, (Shell)shell, (String)message, (String)helpID);
    }

    private void createJmsDestination(Trace t, IDmObject dmObject, Shell shell) {
        NewDestinationObjectProvider newObjectProvider = new NewDestinationObjectProvider(t, null);
        String objectId = "com.ibm.mq.explorer.jmsadmin.JMSDestination";
        this.startMappingWizard(t, (NewObjectProvider)newObjectProvider, shell, dmObject, objectId);
    }

    private void startMappingWizard(Trace t, NewObjectProvider newObjectProvider, Shell shell, IDmObject mappingObject, String objectId) {
        if (newObjectProvider != null) {
            try {
                newObjectProvider.setObjectToMapPropertiesFrom(t, mappingObject);
                NewObjectWizStarter wizardStarter = new NewObjectWizStarter(t, newObjectProvider, objectId);
                wizardStarter.start(t);
            }
            catch (UnableToUseMappingObjectException e) {
                MessageBox.showMessageFailure((Trace)t, (Shell)shell, (String)e.getMessage(), (String)e.getMessageId());
            }
        } else {
            t.FFST(66, "MappingActions.startMappingWizard", 0, 0, "New object provider has not been initialised");
        }
    }

    private void addMqQueueManager(final Trace t, DmJmsAbstractConnectionFactory dmJmsConnectionFactory, final Shell shell) {
        try {
            JmsConnectionFactoryToMqQueueManagerPropertyMapper propertyMapper = new JmsConnectionFactoryToMqQueueManagerPropertyMapper();
            AddQueueManagerAction addQueueManagerAction = new AddQueueManagerAction(t, (IDmObject)dmJmsConnectionFactory, (IPropertyMapper)propertyMapper);
            addQueueManagerAction.performAdd(t, shell);
        }
        catch (UnableToUseMappingObjectException exception) {
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String message = exception.getMessage();
                    MessageBox.showMessageFailure((Trace)t, (Shell)shell, (String)message);
                }
            });
        }
    }
}

