/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.mapping.mqjms.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DataModel;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerAdapter;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.mapping.mqjms.MqJmsMappingPlugin;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.properties.mapping.ClassNotSupportedException;
import com.ibm.mq.explorer.ui.internal.properties.mapping.IPropertyMapper;
import com.ibm.mq.explorer.ui.internal.properties.mapping.MappedProperty;
import com.ibm.mq.explorer.ui.internal.properties.mapping.UnableToUseMappingObjectException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.swt.widgets.Shell;

public class AddQueueManagerAction {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.mapping.mqjms/src/com/ibm/mq/explorer/mapping/mqjms/actions/AddQueueManagerAction.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private IDmObject dmObject;
    private String dmObjectName;
    private IPropertyMapper propertyMapper;
    private BusyDialog busyDialog;
    private String queueManagerName;
    private int refreshInt;
    private boolean autoConnect = false;
    private boolean connectNow = false;
    private URL ccdtUrl = null;
    private String[] connNameList = null;
    private String channel = null;
    private boolean usingCcdtUrl;
    private boolean keepingQueueManager;

    public AddQueueManagerAction(Trace t, IDmObject dmObject, IPropertyMapper propertyMapper) throws UnableToUseMappingObjectException {
        this.dmObject = dmObject;
        this.dmObjectName = dmObject.getTitle();
        this.propertyMapper = propertyMapper;
        propertyMapper.validateFromObject(t, dmObject);
    }

    public void performAdd(Trace t, Shell shell) {
        this.createBusyDialog(t, shell);
        this.determineProperties(t);
        this.determineConnectionMethod(t, shell);
        this.addQueueManager(t, shell);
        this.showBusyDialog(t);
    }

    private void createBusyDialog(Trace t, Shell shell) {
        String text = MqJmsMappingPlugin.getMessage("MqJms.AddMqQueueManager.BusyDialog");
        text = Message.format((String)text, (String)this.dmObjectName);
        this.busyDialog = new BusyDialog(shell, text);
    }

    private void showBusyDialog(final Trace t) {
        UiPlugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AddQueueManagerAction.this.busyDialog.showDialog(t);
            }
        });
    }

    private void closeBusyDialog(final Trace t) {
        UiPlugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AddQueueManagerAction.this.busyDialog.closeDialog(t);
            }
        });
    }

    private void determineProperties(Trace t) {
        this.queueManagerName = this.propertyMapper.getNewObjectName(t, this.dmObject);
        try {
            Collection mappedProperties = this.propertyMapper.map(t, this.dmObject);
            for (MappedProperty mappedProperty : mappedProperties) {
                int attributeId = mappedProperty.getToId();
                Object attributeValue = mappedProperty.getToValue();
                switch (attributeId) {
                    case 11011: {
                        this.refreshInt = (Integer)attributeValue;
                        break;
                    }
                    case 11012: {
                        Integer autoConnectInteger = (Integer)attributeValue;
                        this.autoConnect = autoConnectInteger == 1;
                        break;
                    }
                    case 11010: {
                        this.ccdtUrl = (URL)attributeValue;
                        break;
                    }
                    case 11002: {
                        String tempConnNameList = (String)attributeValue;
                        this.connNameList = tempConnNameList.split(",");
                        break;
                    }
                    case 11003: {
                        this.channel = (String)attributeValue;
                        break;
                    }
                    default: {
                        t.FFST(66, "AddQueueManagerAction.determineProperties", 0, 50005, "Unexpected attribute: " + attributeId + " - '" + attributeValue + "'");
                    }
                }
            }
        }
        catch (ClassNotSupportedException exception) {
            String errorMessage = exception.getMessage();
            t.FFST(66, "AddQueueManagerAction.determineProperties", 2, 0, errorMessage);
        }
    }

    private void addQueueManager(final Trace t, final Shell shell) {
        DataModel dataModel = UiPlugin.getTheDataModel();
        DmQueueManagerAdapter listener = new DmQueueManagerAdapter(){

            public void dmQueueManagerDisconnected(DmObjectEvent event) {
                AddQueueManagerAction.this.handleQueueManagerAddedEvent(t, event, shell);
            }

            public void dmQueueManagerConnected(DmObjectEvent event) {
                AddQueueManagerAction.this.handleQueueManagerAddedEvent(t, event, shell);
            }
        };
        if (this.usingCcdtUrl) {
            dataModel.addQueueManagerAndObserver(t, this.queueManagerName, this.ccdtUrl, this.refreshInt, this.autoConnect, this.connectNow, (DmQueueManagerListener)listener);
        } else {
            dataModel.addQueueManagerAndObserver(t, this.queueManagerName, this.connNameList, this.channel, null, this.refreshInt, this.autoConnect, this.connectNow, (DmQueueManagerListener)listener);
        }
    }

    private void determineConnectionMethod(Trace t, Shell shell) {
        boolean canUseConnDetails;
        boolean canUseCcdtUrl = this.ccdtUrl != null;
        boolean bl = canUseConnDetails = this.connNameList != null && this.channel != null;
        if (canUseCcdtUrl) {
            this.usingCcdtUrl = true;
        } else {
            this.usingCcdtUrl = false;
            if (!canUseCcdtUrl && !canUseConnDetails) {
                t.FFST(66, "AddQueueManagerAction.determineConnectionMethod", 1, 0, "Could not use CCDT or connection details");
            }
        }
    }

    private void handleQueueManagerAddedEvent(final Trace t, DmObjectEvent event, Shell shell) {
        this.closeBusyDialog(t);
        final DmQueueManager queueManager = (DmQueueManager)event.getSource();
        DmCoreException eventException = event.getException();
        this.displayFailureMessage(t, shell, queueManager, eventException);
        this.determineIfKeepingQueueManager(t, shell, queueManager, eventException);
        if (this.keepingQueueManager) {
            queueManager.notifyListeners(t);
            this.displaySuccessMessage(t, shell, queueManager);
        } else {
            new Thread(){

                @Override
                public void run() {
                    queueManager.close(t);
                }
            }.start();
        }
    }

    private void displayFailureMessage(final Trace t, final Shell shell, DmQueueManager queueManager, final DmCoreException eventException) {
        if (eventException != null) {
            UiPlugin.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageBox.showExceptionMessage((Trace)t, (Shell)shell, (DmCoreException)eventException);
                }
            });
        }
    }

    private void displaySuccessMessage(final Trace t, final Shell shell, final DmQueueManager queueManager) {
        UiPlugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String msgID = "AMQ4462";
                String displayedName = queueManager.getTreeName(t);
                MessageBox.showSystemMessageById((Trace)t, (Shell)shell, (String)msgID, (String[])new String[]{displayedName}, (String)msgID);
            }
        });
    }

    private void determineIfKeepingQueueManager(final Trace t, final Shell shell, DmQueueManager queueManager, DmCoreException eventException) {
        final String displayedName = queueManager.getTreeName(t);
        boolean connectedSuccessfully = eventException == null;
        boolean changableQueueManager = this.queueManagerName.startsWith(Character.toString('*'));
        if (connectedSuccessfully) {
            if (changableQueueManager) {
                UiPlugin.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String helpId = "AMQ4466";
                        String[] inserts = new String[]{displayedName, AddQueueManagerAction.this.queueManagerName};
                        String message = CommonServices.getSystemMessage((Trace)t, (String)helpId, (String[])inserts);
                        int response = MessageBox.showYesNoMessage((Trace)t, (Shell)shell, (String)message, (int)0, (String)helpId);
                        if (response == 0) {
                            AddQueueManagerAction.this.keepingQueueManager = true;
                        } else {
                            AddQueueManagerAction.this.keepingQueueManager = false;
                        }
                    }
                });
            } else {
                this.keepingQueueManager = true;
            }
        } else if (eventException != null) {
            if (eventException.getReasonCode() == 10042) {
                this.keepingQueueManager = false;
            } else if (changableQueueManager) {
                UiPlugin.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String helpId = "AMQ4464";
                        String message = CommonServices.getSystemMessage((Trace)t, (String)helpId);
                        MessageBox.showMessageFailure((Trace)t, (Shell)shell, (String)message, (String)helpId);
                        AddQueueManagerAction.this.keepingQueueManager = false;
                    }
                });
            } else {
                UiPlugin.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String helpId = "AMQ4027";
                        String message = CommonServices.getSystemMessage((Trace)t, (String)helpId, (String)displayedName);
                        int response = MessageBox.showYesNoMessage((Trace)t, (Shell)shell, (String)message, (int)1, (String)helpId);
                        if (response == 0) {
                            AddQueueManagerAction.this.keepingQueueManager = true;
                        } else {
                            AddQueueManagerAction.this.keepingQueueManager = false;
                        }
                    }
                });
            }
        }
    }
}

