/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.trace.weaving;

import com.ibm.mq.commonservices.internal.trace.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@Aspect
public class TraceAspect {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.trace.weaving/src/com/ibm/mq/explorer/trace/weaving/TraceAspect.java";
    private static final Map<String, String> bundleNameMap = new HashMap<String, String>();
    private static final List<String> sensitiveConstructors;
    private static final List<String> sensitiveBeforeMethods;
    private static final List<String> sensitiveAfterMethods;
    private static final List<Integer> sensitivePCF;
    private static final String ATTR_STRING = "AttrString";
    private static final String PWDEFAULT_CREDENTIALS = "PwDefaultCredentials";
    private static final String DM_SSL_SOCKET_FACTORY = "DmSSLSocketFactory";
    private static final String QUEUE_MANAGER_HANDLE = "QueueManagerHandle";
    private static final String DM_ADD_ATTR = "DmObject.addAttr(..)";
    private static final String DM_CREATE_ATTR = "DmObject.createAttribute(..)";
    private static final String DM_GET_ATTR_VAL = "DmObject.getAttributeValue(..)";
    private static final String DM_SET_ATTR_VAL = "DmObject.setAttributeValue(..)";
    private static final String PWUTILS_ENCRYPT = "PwUtils.encrypt(..)";
    private static final String DM_ADD_QUEUE_MANAGER_AND_OBSERVER = "DataModel.addQueueManagerAndObserver(..)";
    private static final String QMH_GET_SECURITY_OPTIONS = "QueueManagerHandle.getSecurityOptions(..)";
    private static final String QMH_SET_SECURITY_OPTIONS = "QueueManagerHandle.setSecurityOptions(..)";
    private static final String CORE_SEVICES_ADD_QUEUE_MANAGER = "CoreServices.addQueueManager(..)";
    private static final String SENSITIVE_DATA = "********";
    private static final String passwordKey = "password";
    private static final int PARAM_QMGRHANDLE_USERID_PASSWORD = 11019;
    private static final int PARAM_QMGRHANDLE_SSL_PERSONAL_STORE_PW = 11026;
    private static final int PARAM_QMGRHANDLE_SSL_TRUSTED_STORE_PW = 11028;
    private static final int MQCACH_PASSWORD = 3518;

    static {
        bundleNameMap.put("com.ibm.mq.commonservices", "MQEX.COMMONS");
        bundleNameMap.put("com.ibm.mq.explorer.ams", "MQEX.AMS    ");
        bundleNameMap.put("com.ibm.mq.explorer.clusterplugin", "MQEX.CLUS   ");
        bundleNameMap.put("com.ibm.mq.explorer.core", "MQEX.CORE   ");
        bundleNameMap.put("com.ibm.mq.explorer.importexport", "MQEX.IMP_EXP");
        bundleNameMap.put("com.ibm.mq.explorer.jmsadmin", "MQEX.JMSA   ");
        bundleNameMap.put("com.ibm.mq.explorer.jmsadmin.sample.menus", "MQEX.JMSA.S ");
        bundleNameMap.put("com.ibm.mq.explorer.jmsadmin.tests", "MQEX.JMSA.T ");
        bundleNameMap.put("com.ibm.mq.explorer.mapping.mqjms", "MQEX.MAP    ");
        bundleNameMap.put("com.ibm.mq.explorer.messageplugin.internal", "MQEX.MESS   ");
        bundleNameMap.put("com.ibm.mq.explorer.oam", "MQEX.OAM    ");
        bundleNameMap.put("com.ibm.mq.explorer.oam.tests", "MQEX.OAM.T  ");
        bundleNameMap.put(" com.ibm.mq.explorer.passwords", "MQEX.PASSW  ");
        bundleNameMap.put("com.ibm.mq.explorer.pubsub", "MQEX.PUBSUB ");
        bundleNameMap.put("com.ibm.mq.explorer.qmgradmin", "MQEX.QMGR   ");
        bundleNameMap.put("com.ibm.mq.explorer.qmgradmin.sets", "MQEX.QMGR.S ");
        bundleNameMap.put("com.ibm.mq.explorer.qmgradmin.topicstatus", "MQEX.QMGR.T ");
        bundleNameMap.put("com.ibm.mq.explorer.sample.menus", "MQEX.SAMP.M ");
        bundleNameMap.put("com.ibm.mq.explorer.sample.simple", "MQEX.SAMP.S ");
        bundleNameMap.put("com.ibm.mq.explorer.servicedef", "MQEX.SERDEF ");
        bundleNameMap.put("com.ibm.mq.explorer.telemetry.mqtt.utility", "MQEX.TEL.M.U");
        bundleNameMap.put("com.ibm.mq.explorer.telemetry.ui", "MQEX.TEL.UI ");
        bundleNameMap.put("com.ibm.mq.explorer.tests", "MQEX.TST    ");
        bundleNameMap.put("com.ibm.mq.explorer.tests.coretests", "MQEX.TST.C  ");
        bundleNameMap.put("com.ibm.mq.explorer.tests.coretests.cluster", "MQEX.TST.C.C");
        bundleNameMap.put("com.ibm.mq.explorer.tests.sample", "MQEX.TST.S  ");
        bundleNameMap.put("com.ibm.mq.explorer.traceplugin.internal", "MQEX.TRC    ");
        bundleNameMap.put("com.ibm.mq.explorer.ui", "MQEX.UI     ");
        bundleNameMap.put("com.ibm.mq.explorer.ui.rcp", "MQEX.UI.RCP ");
        bundleNameMap.put("com.ibm.mq.pcf.event", "MQEX.PCF.E  ");
        bundleNameMap.put("com.ibm.mq.telemetry.mqtt.utility", "MQEX.TEL.M.U");
        bundleNameMap.put("com.ibm.wmqfte.explorer", "MQEX.MFT    ");
        bundleNameMap.put("com.ibm.wmqfte.explorer.context", "MQEX.MFT.C  ");
        bundleNameMap.put("com.ibm.wmqfte.runtime", "MQEX.MFT.R  ");
        sensitiveConstructors = new ArrayList<String>();
        sensitiveConstructors.add(ATTR_STRING);
        sensitiveConstructors.add(PWDEFAULT_CREDENTIALS);
        sensitiveConstructors.add(DM_SSL_SOCKET_FACTORY);
        sensitiveConstructors.add(QUEUE_MANAGER_HANDLE);
        sensitiveBeforeMethods = new ArrayList<String>();
        sensitiveBeforeMethods.add(DM_ADD_ATTR);
        sensitiveBeforeMethods.add(DM_CREATE_ATTR);
        sensitiveBeforeMethods.add(DM_SET_ATTR_VAL);
        sensitiveBeforeMethods.add(PWUTILS_ENCRYPT);
        sensitiveBeforeMethods.add(DM_ADD_QUEUE_MANAGER_AND_OBSERVER);
        sensitiveBeforeMethods.add(QMH_SET_SECURITY_OPTIONS);
        sensitiveBeforeMethods.add(CORE_SEVICES_ADD_QUEUE_MANAGER);
        sensitiveAfterMethods = new ArrayList<String>();
        sensitiveAfterMethods.add(DM_GET_ATTR_VAL);
        sensitiveAfterMethods.add(QMH_GET_SECURITY_OPTIONS);
        sensitivePCF = new ArrayList<Integer>();
        sensitivePCF.add(11019);
        sensitivePCF.add(11026);
        sensitivePCF.add(11028);
        sensitivePCF.add(3518);
    }

    public static String getBundleShortName(String symbolicName) {
        return bundleNameMap.get(symbolicName);
    }

    @Pointcut(value="(within(com.ibm.mq.explorer..*) || within(com.ibm.mq.commonservices..*) || within(com.ibm.wmqfte.explorer..*) ) && !within(com.ibm.mq.explorer.trace..*) && !within(com.ibm.mq.commonservices.internal.trace..*) && !within(com.ibm.wmqfte.explorer.ras.ExplorerTraceHandler) && !execution(com.ibm.mq.commonservices.internal.trace.AMQLogger com.ibm.mq.commonservices.internal.utils.CommonServices.getAMQLogger()) && !execution(com.ibm.mq.commonservices.internal.trace.EventLogger com.ibm.mq.commonservices.internal.utils.CommonServices.getEventLogger(int)) && !execution(java.lang.String[] com.ibm.mq.commonservices.internal.utils.CommonServices.getListOfNames(int)) && !execution(com.ibm.mq.commonservices.internal.utils.RASProperties com.ibm.mq.commonservices.internal.utils.CommonServices.getRASProperties()) && !execution(java.util.logging.Logger com.ibm.mq.commonservices.internal.utils.CommonServices.getTraceLogger()) && !execution(boolean com.ibm.mq.commonservices.internal.utils.CommonServices.threadInitialize(com.ibm.mq.commonservices.internal.trace.Trace)) && !within(com.ibm.mq.commonservices.internal.utils.Message*) && !within(com.ibm.mq.explorer.core.internal.attrs.AttrKey*) && !within(com.ibm.mq.explorer.core.internal.parser..*) && !within(com.ibm.mq.explorer.jmsadmin.core.internal.objects.Key*) && !within(com.ibm.mq.explorer.servicedef.core.internal.objects.Key*) && !within(com.ibm.mq.explorer.tests.WMQTest*) && !within(com.ibm.mq.explorer.ui.internal.controls.ExtTableGreyCellManager*) && !execution(java.lang.String toString(..)) && !execution(java.util.HashMap<String, Integer> com.ibm.mq.commonservices.internal.utils.CommonServices.getHashMapOfNames(int)) && !execution(int              com.ibm.mq.explorer.core.internal.attrs.Attr.getAttributeID()) && !execution(com.ibm.mq.explorer.core.internal.attrs.AttrType com.ibm.mq.explorer.core.internal.attrs.Attr.getAttrType()) && !execution(int              com.ibm.mq.explorer.core.internal.attrs.Attr.getRepeatingIndex()) && !execution(java.lang.Object com.ibm.mq.explorer.core.internal.attrs.Attr.getValue(com.ibm.mq.commonservices.internal.trace.Trace)) && !execution(void             com.ibm.mq.explorer.core.internal.attrs.Attr.setDefaultValueUsed(com.ibm.mq.commonservices.internal.trace.Trace, boolean)) && !execution(int              com.ibm.mq.explorer.core.internal.attrs.AttrType.getAttributeType()) && !execution(java.lang.Object com.ibm.mq.explorer.core.internal.attrs.AttrType.getDefaultValue(com.ibm.mq.commonservices.internal.trace.Trace)) && !execution(java.lang.String com.ibm.mq.explorer.core.internal.attrs.AttrType.getDisplayTitle()) && !execution(int              com.ibm.mq.explorer.core.internal.attrs.AttrType.getPCFType()) && !execution(boolean          com.ibm.mq.explorer.core.internal.attrs.AttrType.isReadWrite()) && !execution(boolean          com.ibm.mq.explorer.core.internal.attrs.AttrType.isRepeating()) && !execution(void             com.ibm.mq.explorer.core.internal.attrs.AttrType.setAttributeType(com.ibm.mq.commonservices.internal.trace.Trace, int)) && !execution(void             com.ibm.mq.explorer.core.internal.attrs.AttrType.setDefaultValue(com.ibm.mq.commonservices.internal.trace.Trace, java.lang.Object)) && !execution(java.lang.Number[] com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum.getKeysArray(int[])) && !execution(com.ibm.mq.explorer.core.internal.attrs.AttrType com.ibm.mq.explorer.core.internal.attrs.AttrTypeFactory.create(com.ibm.mq.commonservices.internal.trace.Trace, com.ibm.mq.explorer.core.internal.parser.Attribute)) && !execution(void             com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString.setPassword(com.ibm.mq.commonservices.internal.trace.Trace, boolean)) && !execution(boolean          com.ibm.mq.explorer.core.internal.attrs.AttrTypeString.isTrimmed()) && !execution(void             com.ibm.mq.explorer.core.internal.attrs.AttrTypeString.setTrimmed(boolean)) && !execution(int[]            com.ibm.mq.explorer.core.internal.objects.DmObject.getAllAttributes(com.ibm.mq.commonservices.internal.trace.Trace)) && !execution(int[]            com.ibm.mq.explorer.core.internal.objects.DmObject.getAllAttributes(com.ibm.mq.commonservices.internal.trace.Trace, boolean)) && !execution(java.lang.String com.ibm.mq.explorer.core.internal.objects.DmObject.getClassName(java.lang.String)) && !execution(int              com.ibm.mq.explorer.core.internal.objects.DmObject.getRepeatingIndexes(com.ibm.mq.commonservices.internal.trace.Trace, int)) && !execution(java.lang.String com.ibm.mq.explorer.core.internal.objects.DmObject.getTitle()) && !execution(boolean          com.ibm.mq.explorer.core.internal.objects.DmQueueManager.isAttributeRepeating(com.ibm.mq.commonservices.internal.trace.Trace, int)) && !execution(java.lang.String com.ibm.mq.explorer.ui.extensions.MQExtObject.getName()) && !execution(java.lang.Object com.ibm.mq.explorer.ui.extensions.MQExtObject.getInternalObject()) && !execution(java.lang.Object com.ibm.mq.explorer.ui.extensions.TreeNode.getObject()) && !execution(boolean          com.ibm.mq.explorer.ui.extensions.TreeNode.isVisible()) && !execution(java.lang.String com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem.getAttributeName()) && !execution(int              com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem.getAttributePosition(boolean)) && !execution(com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder.get(com.ibm.mq.commonservices.internal.trace.Trace, int)) && !execution(long             com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder.getDateLastSelected()) && !execution(boolean          com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder.isDualOrder()) && !execution(int              com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder.size()) && !execution(java.lang.String com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem.getAttributeName()) && !execution(int              com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem.getAttributePosition(boolean)) && !execution(int              com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem.getWidth()) && !execution(boolean          com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem.isDualOrder()) && !execution(int              com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem.getAttributeId()) && !execution(int              com.ibm.mq.explorer.ui.internal.attributeorder.AttributePair.getAttributeId()) && !execution(java.lang.String com.ibm.mq.explorer.ui.internal.attributeorder.AttributePair.getAttributeName()) && !execution(int              com.ibm.mq.explorer.ui.internal.attributeorder.AttributePair.getAttributePosition(boolean)) && !execution(boolean          com.ibm.mq.explorer.ui.internal.attributeorder.DefaultObjectAttributeDetails.isAttributeRepeating(java.lang.String, int)) && !execution(int              com.ibm.mq.explorer.ui.internal.attributeorder.CompareAttributePairs.compare(com.ibm.mq.explorer.ui.internal.attributeorder.AttributePair, com.ibm.mq.explorer.ui.internal.attributeorder.AttributePair)) && !execution(void             com.ibm.mq.explorer.ui.internal.base.ContentPageFactoryManager.trace(com.ibm.mq.commonservices.internal.trace.Trace, java.lang.String, java.lang.String)) && !execution(void             com.ibm.mq.explorer.ui.internal.base.NotificationManager.trace(com.ibm.mq.commonservices.internal.trace.Trace, java.lang.String, java.lang.String)) && !execution(void             com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager.trace(com.ibm.mq.commonservices.internal.trace.Trace, java.lang.String, java.lang.String)) && !execution(void             com.ibm.mq.explorer.ui.internal.base.TreeNodeFactoryManager.trace(com.ibm.mq.commonservices.internal.trace.Trace, java.lang.String, java.lang.String)) && !execution(boolean          com.ibm.mq.explorer.ui.internal.base.UiPlugin.isPluginEnabled(java.lang.String)) && !execution(java.lang.Object com.ibm.mq.explorer.ui.internal.navigator.TreeNodeBase.getObject()) && !execution(boolean          com.ibm.mq.explorer.ui.internal.navigator.TreeNodeBase.isVisible()) && !execution(com.ibm.mq.explorer.core.internal.objects.IDmObject  com.ibm.mq.explorer.ui.internal.objects.UiMQObject.getDmObject()) && !execution(java.lang.Object[] com.ibm.wmqfte.explorer.views.TransferProgressContentProvider.getElements(java.lang.Object)) && !execution(* *.*Password*(..)) && !execution(java.lang.Object com.ibm.mq.explorer.core.internal.attrs.Attr.getNewValue(com.ibm.mq.commonservices.internal.trace.Trace)) && !execution(boolean          com.ibm.mq.explorer.core.internal.attrs.Attr.validate(com.ibm.mq.commonservices.internal.trace.Trace, java.lang.Object)) && !execution(boolean          com.ibm.mq.explorer.core.internal.attrs.AttrString.setNewValue(com.ibm.mq.commonservices.internal.trace.Trace,  java.lang.Object)) && !execution(boolean          com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString.validate(com.ibm.mq.commonservices.internal.trace.Trace, com.ibm.mq.explorer.core.internal.attrs.Attr, java.lang.Object)) && !execution(java.util.Hashtable<String, Object>  com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle.getUserIdOptions(com.ibm.mq.commonservices.internal.trace.Trace)) && !execution(int              com.ibm.mq.explorer.ui.internal.properties.AttributeControl.compareObjectValues(com.ibm.mq.commonservices.internal.trace.Trace, java.lang.Object, java.lang.Object )) && !execution(java.lang.Object com.ibm.mq.explorer.ui.internal.properties.PasswordAttributeControl.getValue(com.ibm.mq.commonservices.internal.trace.Trace)) && !execution(boolean          com.ibm.mq.explorer.ui.internal.properties.PasswordAttributeControl.setValue(com.ibm.mq.commonservices.internal.trace.Trace, java.lang.Object)) && !execution(boolean          com.ibm.mq.explorer.ui.internal.properties.PropertyControl.setAttributeValueFromControl(com.ibm.mq.commonservices.internal.trace.Trace, java.lang.Object, com.ibm.mq.explorer.core.internal.objects.IDmObject, com.ibm.mq.explorer.ui.internal.properties.AttributeControl)) && !execution(java.lang.String com.ibm.mq.explorer.passwords.internal.utils.PwUtils.decrypt(com.ibm.mq.commonservices.internal.trace.Trace, java.lang.String, java.lang.String )) && !execution(java.lang.String com.ibm.mq.explorer.passwords.internal.utils.PwUtils.bytes2String(byte[])) ")
    void myClass() {
    }

    @Before(value="myClass() && execution(new(..))")
    public void beforeConstructor(JoinPoint thisJoinPoint, JoinPoint.StaticPart thisJoinPointStaticPart) {
        String argsStr;
        Signature sig = thisJoinPointStaticPart.getSignature();
        String sourceClass = this.getConstructorClassName(sig);
        String sourceMethod = this.getConstructorMethodSig(sig);
        if (sensitiveConstructors.contains(sourceClass)) {
            String[] parameterNames = ((ConstructorSignature)sig).getParameterNames();
            argsStr = this.argsToSanitizedString(sourceClass, thisJoinPoint.getArgs(), parameterNames);
        } else {
            argsStr = TraceAspect.argsToString(thisJoinPoint.getArgs());
        }
        sourceMethod = String.valueOf(sourceMethod) + "(" + argsStr + ")";
        Trace.entry((String)sourceClass, (String)sourceMethod, (String)this.getBundleShortName(sig));
    }

    @After(value="myClass() && execution(new(..))")
    public void afterConstructor(JoinPoint thisJoinPoint, JoinPoint.StaticPart thisJoinPointStaticPart) {
        Signature sig = thisJoinPointStaticPart.getSignature();
        String sourceClass = this.getConstructorClassName(sig);
        String sourceMethod = this.getConstructorMethodSig(sig);
        Trace.exit((String)sourceClass, (String)sourceMethod, (String)this.getBundleShortName(sig));
    }

    @Before(value="myClass() && execution(* *(..))")
    public void beforeMethod(JoinPoint thisJoinPoint, JoinPoint.StaticPart thisJoinPointStaticPart) {
        String argsStr;
        Signature sig = thisJoinPointStaticPart.getSignature();
        String sourceClass = this.getClassName(sig);
        String sourceMethod = this.getMethodSig(sig);
        String classMethod = sig.toShortString();
        if (sensitiveBeforeMethods.contains(classMethod)) {
            String[] parameterNames = ((MethodSignature)sig).getParameterNames();
            argsStr = this.argsToSanitizedString(classMethod, thisJoinPoint.getArgs(), parameterNames);
        } else {
            argsStr = TraceAspect.argsToString(thisJoinPoint.getArgs());
        }
        sourceMethod = String.valueOf(sourceMethod) + "(" + argsStr + ")";
        Trace.entry((String)sourceClass, (String)sourceMethod, (String)this.getBundleShortName(sig));
    }

    @AfterReturning(pointcut="myClass() && execution(* *(..))", returning="obj")
    public void afterMethod(JoinPoint thisJoinPoint, JoinPoint.StaticPart thisJoinPointStaticPart, Object obj) {
        Signature sig = thisJoinPointStaticPart.getSignature();
        if (sig instanceof MethodSignature) {
            String sourceClass = this.getClassName(sig);
            String sourceMethod = this.getMethodSig(sig);
            String returnStr = "";
            MethodSignature method = (MethodSignature)sig;
            if (method.getReturnType().getName().compareTo("void") != 0) {
                if (obj != null) {
                    String classMethod = sig.toShortString();
                    if (sensitiveAfterMethods.contains(classMethod)) {
                        String[] parameterNames = ((MethodSignature)sig).getParameterNames();
                        returnStr = this.objToSanitizedString(classMethod, parameterNames, thisJoinPoint.getArgs(), obj);
                    } else {
                        returnStr = obj.toString();
                    }
                } else {
                    returnStr = "null";
                }
                sourceMethod = String.valueOf(sourceMethod) + "(" + returnStr + ")";
            }
            Trace.exit((String)sourceClass, (String)sourceMethod, (String)this.getBundleShortName(sig));
        }
    }

    @AfterThrowing(pointcut="myClass() && execution(* *(..))", throwing="thrown")
    public void afterThrowingMethod(JoinPoint thisJoinPoint, JoinPoint.StaticPart thisJoinPointStaticPart, Throwable thrown) {
        Signature sig = thisJoinPointStaticPart.getSignature();
        String sourceClass = this.getClassName(sig);
        String sourceMethod = this.getMethodSig(sig);
        Trace.exit((String)sourceClass, (String)sourceMethod, (String)this.getBundleShortName(sig), (Throwable)thrown);
    }

    private String getMethodSig(Signature sig) {
        String sigString = sig.toString();
        int i = sigString.lastIndexOf(46);
        String sourceMethod = sigString.substring(i + 1);
        return sourceMethod;
    }

    private String getClassName(Signature sig) {
        String shortName = sig.toShortString();
        int i = shortName.indexOf(46);
        String sourceClass = shortName.substring(0, i);
        return sourceClass;
    }

    private String getConstructorClassName(Signature sig) {
        String shortName = sig.toShortString();
        int i = shortName.indexOf(40);
        String sourceClass = shortName.substring(0, i);
        return sourceClass;
    }

    private String getConstructorMethodSig(Signature sig) {
        String sigString = sig.toString();
        int i = sigString.indexOf(40);
        String sourceMethod = "constructor" + sigString.substring(i);
        return sourceMethod;
    }

    public static String argsToString(Object[] args) {
        StringBuffer buffer = new StringBuffer();
        String nullStr = "null";
        int i = 0;
        while (i < args.length) {
            String argStr;
            try {
                argStr = args[i].toString();
            }
            catch (NullPointerException nullPointerException) {
                argStr = nullStr;
            }
            buffer.append(argStr);
            if (i < args.length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        return buffer.toString();
    }

    public static boolean isSensitivePCF(Object id) {
        return sensitivePCF.contains(id);
    }

    private String getBundleShortName(Signature sig) {
        Bundle bundle = FrameworkUtil.getBundle((Class)sig.getDeclaringType());
        if (bundle != null) {
            return TraceAspect.getBundleShortName(bundle.getSymbolicName());
        }
        return null;
    }

    private String argsToSanitizedString(String classMethod, Object[] args, String[] parameterNames) {
        String argsStr = "";
        int paramIndex = 0;
        if (classMethod.equals(DM_SET_ATTR_VAL) || classMethod.equals(DM_ADD_ATTR) || classMethod.equals(DM_CREATE_ATTR)) {
            int i = 0;
            while (i < parameterNames.length) {
                if (parameterNames[i].equals("id") && TraceAspect.isSensitivePCF(args[i]) && parameterNames[paramIndex = i + 2].equals("value")) {
                    this.sanitizePassword(args, paramIndex);
                }
                ++i;
            }
        } else if (classMethod.equals(ATTR_STRING)) {
            paramIndex = 1;
            if (parameterNames.length > paramIndex && parameterNames[paramIndex].equals("id") && TraceAspect.isSensitivePCF(args[paramIndex])) {
                paramIndex = 3;
                this.sanitizePassword(args, paramIndex);
            }
        } else if (classMethod.equals(PWDEFAULT_CREDENTIALS)) {
            paramIndex = 4;
            if (parameterNames.length > paramIndex && parameterNames[paramIndex].equals("_password")) {
                this.sanitizePassword(args, paramIndex);
            }
        } else if (classMethod.equals(DM_SSL_SOCKET_FACTORY)) {
            paramIndex = 3;
            if (parameterNames.length > paramIndex && parameterNames[paramIndex].equals("personalStorePassword")) {
                this.sanitizePassword(args, paramIndex);
            }
            if (parameterNames.length > (paramIndex = 5) && parameterNames[paramIndex].equals("trustedStorePassword")) {
                this.sanitizePassword(args, paramIndex);
            }
        } else if (classMethod.equals(PWUTILS_ENCRYPT)) {
            paramIndex = 2;
            if (parameterNames.length > paramIndex && parameterNames[paramIndex].equals("data")) {
                this.sanitizePassword(args, paramIndex);
            }
        } else if (classMethod.equals(DM_ADD_QUEUE_MANAGER_AND_OBSERVER) || classMethod.equals(QMH_SET_SECURITY_OPTIONS) || classMethod.equals(CORE_SEVICES_ADD_QUEUE_MANAGER) || classMethod.equals(QUEUE_MANAGER_HANDLE)) {
            int i = 0;
            while (i < parameterNames.length) {
                Hashtable secOptions;
                if (parameterNames[i].equals("secOptions") && (secOptions = (Hashtable)args[i]).containsKey(passwordKey)) {
                    Hashtable sanitizedSecOptions = (Hashtable)secOptions.clone();
                    sanitizedSecOptions.put(passwordKey, SENSITIVE_DATA);
                    args[i] = sanitizedSecOptions;
                }
                ++i;
            }
        }
        argsStr = TraceAspect.argsToString(args);
        return argsStr;
    }

    private void sanitizePassword(Object[] args, int i) {
        String password = (String)args[i];
        if (password != null && !password.equals("")) {
            args[i] = SENSITIVE_DATA;
        }
    }

    private String objToSanitizedString(String classMethod, String[] parameterNames, Object[] args, Object rtnObj) {
        Hashtable secOptions;
        String returnStr = rtnObj.toString();
        if (classMethod.equals(DM_GET_ATTR_VAL)) {
            int paramIndex = 1;
            if (parameterNames[paramIndex].equals("id") && TraceAspect.isSensitivePCF(args[paramIndex]) && !rtnObj.equals("")) {
                returnStr = SENSITIVE_DATA;
            }
        } else if (classMethod.equals(QMH_GET_SECURITY_OPTIONS) && (secOptions = (Hashtable)rtnObj).containsKey(passwordKey)) {
            Hashtable sanitizedSecOptions = (Hashtable)secOptions.clone();
            sanitizedSecOptions.put(passwordKey, SENSITIVE_DATA);
            returnStr = sanitizedSecOptions.toString();
        }
        return returnStr;
    }
}

