/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.utils.IOamWriteToDisk;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class OamWriteToDisk
extends Thread
implements IOamWriteToDisk {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/utils/OamWriteToDisk.java";
    protected FileDialog dialog = null;
    protected Shell parentShell = null;
    protected String fileName = null;
    protected File file = null;
    protected FileWriter fileWriter = null;
    protected BusyDialog busyDialog = null;
    protected ArrayList listOfObjects = null;

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        this.execute(t);
        if (this.busyDialog != null) {
            this.parentShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OamWriteToDisk.this.busyDialog.closeDialog(Trace.getDefault());
                    OamWriteToDisk.this.busyDialog = null;
                }
            });
        }
    }

    public void writeToDisk(Trace t) {
        if (this.createFile(t)) {
            this.busyDialog = new BusyDialog(this.parentShell, OamPlugin.oamMessages.getMessage("OAM.Writing.To.Disk"));
            this.start();
            this.busyDialog.showDialog(t);
        }
    }

    protected boolean writeToDisk(Trace t, DmObject dmObject) {
        boolean rc;
        block3: {
            rc = true;
            String output = null;
            String profileName = this.getProfileName(t, dmObject);
            String profileType = this.getProfileType(t, dmObject);
            String entityName = this.getEntityName(t, dmObject);
            String entityType = this.getEntityType(t, dmObject);
            StringBuffer sb = new StringBuffer();
            Attr authListAttr = dmObject.getAttribute(t, 1115, 0);
            ArrayList listOfAuthorities = (ArrayList)authListAttr.getValue(t);
            int i = 0;
            while (i < listOfAuthorities.size()) {
                int value = (Integer)listOfAuthorities.get(i);
                sb.append(" +" + this.getSetCommandAuthority(value));
                ++i;
            }
            output = profileType.equalsIgnoreCase("qmgr") ? "setmqaut -m " + dmObject.getQueueManager().getTitle() + " -t " + profileType + " -" + entityType + " " + entityName + sb.toString() : "setmqaut -m " + dmObject.getQueueManager().getTitle() + " -n " + profileName + " -t " + profileType + " -" + entityType + " " + entityName + sb.toString();
            try {
                this.fileWriter.write(output);
                this.fileWriter.write(OamCommon.NEWLINE_CHAR);
            }
            catch (IOException e) {
                if (!Trace.isTracing) break block3;
                t.data(66, "OamWriteToDisk.writeToDisk", 900, "Error writing to file " + this.fileName + "\n" + e);
            }
        }
        return rc;
    }

    public int promptForFilename(Trace t) {
        int rc = 0;
        this.dialog = new FileDialog(this.parentShell, 8192);
        this.dialog.setFilterExtensions(new String[]{"*.txt"});
        this.fileName = this.dialog.open();
        if (this.fileName == null) {
            rc = 1;
        }
        return rc;
    }

    protected String getProfileName(Trace t, DmObject auth) {
        String profileName;
        block2: {
            profileName = "?";
            try {
                profileName = auth.getAttributeValue(t, 3067, 0);
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block2;
                t.data(66, "OamWriteToDisk.getProfileName", 900, "Error getting profile name for " + auth.getTitle() + "\n" + e);
            }
        }
        return profileName;
    }

    protected String getEntityName(Trace t, DmObject auth) {
        String entityName;
        block6: {
            entityName = "?";
            try {
                int eType = (Integer)auth.getAttribute(t, 1118, 0).getValue(t);
                switch (eType) {
                    case 1: {
                        entityName = auth.getAttributeValue(t, 3068, 0);
                        break;
                    }
                    case 2: {
                        entityName = this.extractGroupName(t, auth.getAttributeValue(t, 3068, 0));
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block6;
                t.data(66, "OamWriteToDisk.getEntityName", 900, "Error getting entity name for " + auth.getTitle() + "\n" + e);
            }
        }
        return entityName;
    }

    protected String getEntityType(Trace t, DmObject auth) {
        String entityType;
        block6: {
            int eType = 0;
            entityType = "?";
            try {
                eType = (Integer)auth.getAttribute(t, 1118, 0).getValue(t);
                switch (eType) {
                    case 1: {
                        entityType = "p";
                        break;
                    }
                    case 2: {
                        entityType = "g";
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block6;
                t.data(66, "OamWriteToDisk.getEntityType", 900, "Error getting entity type for " + auth.getTitle() + "\n" + e);
            }
        }
        return entityType;
    }

    protected boolean createFile(Trace t) {
        boolean created = false;
        try {
            this.file = new File(this.fileName);
            if (this.file.createNewFile()) {
                if (!this.file.canWrite()) {
                    String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4819", (String)this.fileName);
                    MessageBox.showMessageFailure((Trace)t, (Shell)this.parentShell, (String)msg, (String)"AMQ4819", (Image)Icons.get((String)Icons.iconkeyEntityName));
                } else {
                    this.fileWriter = new FileWriter(this.file);
                    created = true;
                }
            } else {
                String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4820", (String)this.fileName);
                int reply = MessageBox.showYesNoMessage((Trace)t, (Shell)this.parentShell, null, (Image)Icons.get((String)Icons.iconkeyEntityName), (String)msg, (int)1, (String)"AMQ4820");
                if (reply == 0) {
                    if (!this.file.canWrite()) {
                        msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4819", (String)this.fileName);
                        MessageBox.showMessageFailure((Trace)t, (Shell)this.parentShell, (String)msg, (String)"AMQ4819", (Image)Icons.get((String)Icons.iconkeyEntityName));
                    } else {
                        this.fileWriter = new FileWriter(this.file);
                        created = true;
                    }
                }
            }
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(66, "OamWriteToDisk.createFile", 900, "Error creating file " + this.fileName + "\n" + e);
            }
            String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4819", (String)this.fileName);
            MessageBox.showMessageFailure((Trace)t, (Shell)this.parentShell, (String)msg, (String)"AMQ4819", (Image)Icons.get((String)Icons.iconkeyEntityName));
        }
        return created;
    }

    protected String getSetCommandAuthority(int id) {
        switch (id) {
            case 0: 
            case 14001: {
                return "none";
            }
            case 1: 
            case 14002: {
                return "altusr";
            }
            case 2: 
            case 14003: {
                return "browse";
            }
            case 3: 
            case 14004: {
                return "chg";
            }
            case 4: 
            case 14005: {
                return "clr";
            }
            case 5: 
            case 14006: {
                return "connect";
            }
            case 6: 
            case 14007: {
                return "crt";
            }
            case 7: 
            case 14008: {
                return "dlt";
            }
            case 8: 
            case 14009: {
                return "dsp";
            }
            case 9: 
            case 14010: {
                return "get";
            }
            case 10: 
            case 14011: {
                return "inq";
            }
            case 11: 
            case 14012: {
                return "put";
            }
            case 12: 
            case 14013: {
                return "passall";
            }
            case 13: 
            case 14014: {
                return "passid";
            }
            case 14: 
            case 14015: {
                return "set";
            }
            case 15: 
            case 14016: {
                return "setall";
            }
            case 16: 
            case 14017: {
                return "setid";
            }
            case 17: 
            case 14018: {
                return "ctrl";
            }
            case 18: 
            case 14019: {
                return "ctrlx";
            }
            case 19: 
            case 14031: {
                return "pub";
            }
            case 20: 
            case 14032: {
                return "sub";
            }
            case 21: 
            case 14033: {
                return "resume";
            }
            case 14027: {
                return "authinfo";
            }
            case 14035: {
                return "comminfo";
            }
            case 14025: {
                return "chl";
            }
            case 14026: {
                return "clntconn";
            }
            case 14028: {
                return "listener";
            }
            case 14022: {
                return "namelist";
            }
            case 14023: {
                return "process";
            }
            case 14021: {
                return "q";
            }
            case 14024: {
                return "qmgr";
            }
            case 14029: {
                return "service";
            }
            case 14030: {
                return "topic";
            }
            case 14036: {
                return "rqmname";
            }
        }
        return "?";
    }

    protected String getProfileType(Trace t, DmObject dmObject) {
        String pType;
        block16: {
            pType = "?";
            int id = -1;
            try {
                Integer objectType = (Integer)dmObject.getAttribute(t, 1016, 0).getValue(t);
                id = objectType;
                switch (id) {
                    case 7: {
                        pType = "authinfo";
                        break;
                    }
                    case 9: {
                        pType = "comminfo";
                        break;
                    }
                    case 6: {
                        pType = "chl";
                        break;
                    }
                    case 1014: {
                        pType = "clntconn";
                        break;
                    }
                    case 11: {
                        pType = "listener";
                        break;
                    }
                    case 2: {
                        pType = "namelist";
                        break;
                    }
                    case 3: {
                        pType = "process";
                        break;
                    }
                    case 1: {
                        pType = "q";
                        break;
                    }
                    case 5: {
                        pType = "qmgr";
                        break;
                    }
                    case 12: {
                        pType = "service";
                        break;
                    }
                    case 8: {
                        pType = "topic";
                        break;
                    }
                    case 1017: {
                        pType = "rqmname";
                        break;
                    }
                    default: {
                        pType = "?";
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block16;
                t.data(66, "OamWriteToDisk.getProfileType", 900, "Error getting WMQ object type for " + dmObject.getTitle() + "\n" + e);
            }
        }
        return pType;
    }

    protected String extractGroupName(Trace t, String name) {
        String groupName = name;
        int i = name.lastIndexOf("@");
        if (i != -1) {
            groupName = name.substring(0, i);
        }
        return groupName;
    }
}

