/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.table.OamExplorerTable;
import com.ibm.mq.explorer.oam.internal.utils.OamWriteToDisk;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import java.io.IOException;
import org.eclipse.swt.widgets.Shell;

public class OamWriteTableToDisk
extends OamWriteToDisk {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/utils/OamWriteTableToDisk.java";
    private OamExplorerTable oamExplorerTable = null;
    private boolean crtAuthorities = false;

    public OamWriteTableToDisk(Trace t, Shell _shell, OamExplorerTable _table, boolean _crt) {
        this.parentShell = _shell;
        this.oamExplorerTable = _table;
        this.crtAuthorities = _crt;
    }

    @Override
    public void execute(Trace t) {
        block8: {
            if (this.parentShell != null) {
                this.parentShell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Trace t2 = Trace.getDefault();
                        OamWriteTableToDisk.this.listOfObjects = OamWriteTableToDisk.this.oamExplorerTable.getObjects(t2);
                    }
                });
            }
            if (this.listOfObjects != null) {
                int i = 0;
                while (i < this.listOfObjects.size()) {
                    MQExtObject mqObject = (MQExtObject)this.listOfObjects.get(i);
                    UiAuthorityRecord uiObject = (UiAuthorityRecord)((Object)mqObject.getInternalObject());
                    if (!uiObject.isAccumulated()) {
                        DmAuthorityRecord dmObject = (DmAuthorityRecord)uiObject.getDmObject();
                        if (this.crtAuthorities) {
                            Attr[] attrs = this.getListOfCrtAuthorities(t, dmObject);
                            this.writeCrtAuthsToDisk(t, (DmObject)dmObject, attrs);
                        } else {
                            this.writeToDisk(t, (DmObject)dmObject);
                        }
                    }
                    ++i;
                }
                try {
                    this.fileWriter.close();
                }
                catch (IOException e) {
                    if (!Trace.isTracing) break block8;
                    t.data(66, "OamWriteTableToDisk.execute", 900, "Error closing file " + this.fileName + "\n" + e);
                }
            }
        }
    }

    private boolean writeCrtAuthsToDisk(Trace t, DmObject dmObject, Attr[] attrs) {
        boolean rc = true;
        String output = null;
        String profileName = this.getProfileName(t, dmObject);
        String entityName = this.getEntityName(t, dmObject);
        String entityType = this.getEntityType(t, dmObject);
        int i = 0;
        while (i < attrs.length) {
            block4: {
                Boolean bb = (Boolean)attrs[i].getValue(t);
                if (bb.booleanValue()) {
                    String profileType = this.getSetCommandAuthority(attrs[i].getAttributeID());
                    output = "setmqaut -m " + dmObject.getQueueManager().getTitle() + " -n " + profileName + " -t " + profileType + " -" + entityType + " " + entityName + " +crt";
                    try {
                        this.fileWriter.write(output);
                        this.fileWriter.write(OamCommon.NEWLINE_CHAR);
                    }
                    catch (IOException e) {
                        if (!Trace.isTracing) break block4;
                        t.data(66, "OamWriteTableToDisk.writeCrtAuthsToDisk", 900, "Error writing to file " + this.fileName + "\n" + e);
                    }
                }
            }
            ++i;
        }
        return rc;
    }

    private Attr[] getListOfCrtAuthorities(Trace t, DmAuthorityRecord authRecord) {
        AttrTypeEnum attrType = null;
        Attr[] attrs = new Attr[]{};
        attrType = (AttrTypeEnum)DmQueueManager.getAttributeType((Trace)t, (int)12004);
        Integer[] listOfAuthorities = attrType.getEnumerationIds(t);
        attrs = new Attr[listOfAuthorities.length];
        int i = 0;
        while (i < listOfAuthorities.length) {
            int id = listOfAuthorities[i];
            attrs[i] = authRecord.getAttribute(t, id, 0);
            ++i;
        }
        return attrs;
    }
}

