/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.utils.OamWriteToDisk;
import java.io.IOException;
import org.eclipse.swt.widgets.Shell;

public class OamWriteAllToDisk
extends OamWriteToDisk {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/utils/OamWriteAllToDisk.java";
    private DmQueueManager dmQueueManager = null;

    public OamWriteAllToDisk(Trace t, Shell _shell, DmQueueManager _qm) {
        this.parentShell = _shell;
        this.dmQueueManager = _qm;
    }

    @Override
    public void execute(Trace t) {
        block4: {
            this.getObjectsByType(t);
            if (this.listOfObjects != null) {
                int i = 0;
                while (i < this.listOfObjects.size()) {
                    DmAuthorityRecord dmObject = (DmAuthorityRecord)this.listOfObjects.get(i);
                    this.writeToDisk(t, (DmObject)dmObject);
                    ++i;
                }
                try {
                    this.fileWriter.close();
                }
                catch (IOException e) {
                    if (!Trace.isTracing) break block4;
                    t.data(66, "OamWriteAllToDisk.execute", 900, "Error closing file " + this.fileName + "\n" + e);
                }
            }
        }
    }

    private void getObjectsByType(Trace t) {
        block2: {
            DmObjectFilter dmObjectFilter = new DmObjectFilter(t, 87, 1001);
            dmObjectFilter.setAuthorityOptions(t, OamCommon.AUTH_OPTIONS_WILDCARD);
            try {
                this.listOfObjects = this.dmQueueManager.getObjects(t, dmObjectFilter, false);
            }
            catch (DmCoreException e) {
                if (!Trace.isTracing) break block2;
                t.data(66, "OamWriteAllToDisk.getObjectsByType", 900, "Error getting WMQ objects from " + this.dmQueueManager.getTitle() + "\n" + (Object)((Object)e));
            }
        }
    }
}

