/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;

public class OamEntity {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/utils/OamEntity.java";
    private String name = null;
    private int type = 0;
    private boolean isDomainName = false;

    public OamEntity(Trace t, String _name, int _type) {
        this.type = _type;
        this.name = this.type == 2 ? this.removeDomainName(t, _name) : _name;
        if (this.name.lastIndexOf("@") > 0) {
            this.isDomainName = true;
        }
    }

    public OamEntity(Trace t, IDmObject _auth) {
        this.type = this.getEntityType(t, _auth);
        this.name = this.getEntityName(t, _auth);
        if (this.name.lastIndexOf("@") > 0) {
            this.isDomainName = true;
        }
    }

    private String getEntityName(Trace t, IDmObject auth) {
        String entityName;
        block6: {
            entityName = "?";
            try {
                Attr attr = auth.getAttribute(t, 1118, 0);
                int eType = (Integer)attr.getValue(t);
                switch (eType) {
                    case 1: {
                        entityName = auth.getAttributeValue(t, 3068, 0);
                        break;
                    }
                    case 2: {
                        entityName = this.removeDomainName(t, auth.getAttributeValue(t, 3068, 0));
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block6;
                t.data(66, "OamEntity.getEntityName", 900, "Error getting entity name for " + auth.getTitle() + "\n" + e);
            }
        }
        return entityName;
    }

    private int getEntityType(Trace t, IDmObject auth) {
        int eType;
        block2: {
            eType = 0;
            try {
                Integer entityType = (Integer)auth.getAttribute(t, 1118, 0).getValue(t);
                eType = entityType;
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block2;
                t.data(66, "OamEntity.getEntityType", 900, "Error getting entity type for " + auth.getTitle() + "\n" + e);
            }
        }
        return eType;
    }

    private String removeDomainName(Trace t, String name) {
        String eName = name;
        int i = name.lastIndexOf("@");
        if (i != -1) {
            eName = name.substring(0, i);
        }
        return eName;
    }

    public boolean equals(Object obj) {
        Trace t = Trace.getDefault();
        boolean equal = false;
        if (obj instanceof OamEntity) {
            OamEntity entity = (OamEntity)obj;
            if (this.type == 2) {
                if (this.name.equalsIgnoreCase(entity.getName()) && this.type == entity.getType()) {
                    equal = true;
                }
            } else if (this.isDomainName && !entity.isDomainName) {
                String s = this.removeDomainName(t, this.name);
                if (s.equalsIgnoreCase(entity.getName()) && this.type == entity.getType()) {
                    equal = true;
                }
            } else if (!this.isDomainName && entity.isDomainName) {
                String s = this.removeDomainName(t, entity.getName());
                if (s.equalsIgnoreCase(this.name) && this.type == entity.getType()) {
                    equal = true;
                }
            } else if (this.name.equalsIgnoreCase(entity.getName()) && this.type == entity.getType()) {
                equal = true;
            }
        }
        return equal;
    }

    public String toString(Trace t) {
        return "OamEntity: name=" + this.name + ", type=" + this.type + ", domain name=" + this.isDomainName;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }
}

