/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.table.OamExplorerTable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.widgets.Display;

public class OamCreateCumulativeAuthorityRecord {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/utils/OamCreateCumulativeAuthorityRecord.java";
    private ArrayList<DmAuthorityRecord> usersByEntityType = new ArrayList();
    private ArrayList<DmAuthorityRecord> groupsByEntityType = new ArrayList();
    private Hashtable<String, DmAuthorityRecord> usersByEntityName = new Hashtable();
    private Hashtable<String, DmAuthorityRecord> groupsByEntityName = new Hashtable();
    private UiAuthorityRecord cumulativeUiAuthorityRecord = null;

    public void processResponses(final Trace t, ArrayList<DmAuthorityRecord> objects, final OamExplorerTable explorerTable, int entityType) {
        if (entityType == 2) {
            this.groupsByEntityName.clear();
            this.groupsByEntityType.clear();
            this.groupsByEntityType = this.getObjectsByType(t, objects, 2);
            this.processResponseByName(t, this.groupsByEntityType, this.groupsByEntityName);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    OamCreateCumulativeAuthorityRecord.this.createUiObjects(t, OamCreateCumulativeAuthorityRecord.this.groupsByEntityName, explorerTable);
                }
            });
        } else {
            this.usersByEntityName.clear();
            this.usersByEntityType.clear();
            this.usersByEntityType = this.getObjectsByType(t, objects, 1);
            this.processResponseByName(t, this.usersByEntityType, this.usersByEntityName);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    OamCreateCumulativeAuthorityRecord.this.createUiObjects(t, OamCreateCumulativeAuthorityRecord.this.usersByEntityName, explorerTable);
                }
            });
        }
    }

    public void processAllResponses(Trace t, ArrayList<DmAuthorityRecord> objects, OamExplorerTable groupsExplorerTable, OamExplorerTable usersExplorerTable) {
        this.usersByEntityName.clear();
        this.usersByEntityType.clear();
        this.groupsByEntityName.clear();
        this.groupsByEntityType.clear();
        this.processResponses(t, objects, groupsExplorerTable, 2);
        if (usersExplorerTable != null) {
            usersExplorerTable.clearTable(t);
            this.processResponses(t, objects, usersExplorerTable, 1);
        }
    }

    private void processResponseByName(Trace t, ArrayList<DmAuthorityRecord> objects, Hashtable<String, DmAuthorityRecord> newList) {
        if (Trace.isTracing) {
            t.data(66, "OamCreateCumulativeAuthorityRecord.processResponseByName", 300, "Number of data model objects : " + objects.size());
        }
        int i = 0;
        while (i < objects.size()) {
            DmAuthorityRecord dmObject = objects.get(i);
            String eName = dmObject.getAttributeValue(t, 3068, 0);
            DmAuthorityRecord parent = newList.get(eName);
            if (parent != null) {
                this.addAuthorityAttribute(t, parent, dmObject);
            } else {
                this.createNewAuthorityRecord(t, eName, dmObject, newList);
            }
            ++i;
        }
    }

    private void createNewAuthorityRecord(Trace t, String eName, DmAuthorityRecord dmObject, Hashtable<String, DmAuthorityRecord> newList) {
        String name = "[not_defined]";
        name = OamCommon.getClassProfileName(dmObject.getQueueManager().getPlatform());
        DmAuthorityRecord authRecord = (DmAuthorityRecord)DmObjectFactory.create((Trace)t, (DmObject)dmObject, (String)name);
        authRecord.addAttr(t, 3068, 0, (Object)eName);
        authRecord.addAttr(t, 14027, 0, (Object)false);
        authRecord.addAttr(t, 14035, 0, (Object)false);
        authRecord.addAttr(t, 14025, 0, (Object)false);
        authRecord.addAttr(t, 14026, 0, (Object)false);
        authRecord.addAttr(t, 14028, 0, (Object)false);
        authRecord.addAttr(t, 14022, 0, (Object)false);
        authRecord.addAttr(t, 14023, 0, (Object)false);
        authRecord.addAttr(t, 14021, 0, (Object)false);
        authRecord.addAttr(t, 14036, 0, (Object)false);
        authRecord.addAttr(t, 14029, 0, (Object)false);
        authRecord.addAttr(t, 14030, 0, (Object)false);
        this.addAuthorityAttribute(t, authRecord, dmObject);
        newList.put(eName, authRecord);
    }

    private void addAuthorityAttribute(Trace t, DmAuthorityRecord parent, DmAuthorityRecord dmObject) {
        block17: {
            int objectType = 0;
            try {
                objectType = (Integer)dmObject.getAttribute(t, 1016, 0).getValue(t);
                switch (objectType) {
                    case 7: {
                        parent.addAttr(t, 14027, 0, (Object)true);
                        break;
                    }
                    case 9: {
                        parent.addAttr(t, 14035, 0, (Object)true);
                        break;
                    }
                    case 6: {
                        parent.addAttr(t, 14025, 0, (Object)true);
                        break;
                    }
                    case 1014: {
                        parent.addAttr(t, 14026, 0, (Object)true);
                        break;
                    }
                    case 11: {
                        parent.addAttr(t, 14028, 0, (Object)true);
                        break;
                    }
                    case 2: {
                        parent.addAttr(t, 14022, 0, (Object)true);
                        break;
                    }
                    case 3: {
                        parent.addAttr(t, 14023, 0, (Object)true);
                        break;
                    }
                    case 1: {
                        parent.addAttr(t, 14021, 0, (Object)true);
                        break;
                    }
                    case 5: {
                        parent.addAttr(t, 14024, 0, (Object)true);
                        break;
                    }
                    case 1017: {
                        parent.addAttr(t, 14036, 0, (Object)true);
                        break;
                    }
                    case 12: {
                        parent.addAttr(t, 14029, 0, (Object)true);
                        break;
                    }
                    case 8: {
                        parent.addAttr(t, 14030, 0, (Object)true);
                        break;
                    }
                    default: {
                        if (Trace.isTracing) {
                            t.data(66, "OamCreateCumulativeAuthorityRecord.addAuthorityAttribute", 900, "Unknown object type : " + objectType);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block17;
                t.data(66, "OamCreateCumulativeAuthorityRecord.addAuthorityAttribute", 900, "Error getting WMQ object type for " + dmObject.getTitle() + "\n" + e);
            }
        }
    }

    private ArrayList<DmAuthorityRecord> getObjectsByType(Trace t, ArrayList<DmAuthorityRecord> objects, int type) {
        ArrayList<DmAuthorityRecord> list = new ArrayList<DmAuthorityRecord>();
        if (Trace.isTracing) {
            t.data(66, "OamCreateCumulativeAuthorityRecord.getObjectsByType", 300, "Number of data model objects : " + objects.size());
        }
        int i = 0;
        while (i < objects.size()) {
            block5: {
                DmAuthorityRecord dmObject = objects.get(i);
                try {
                    AttrInt attr = (AttrInt)dmObject.getAttribute(t, 1118, 0);
                    int eType = (Integer)attr.getValue(t);
                    if (eType == type) {
                        list.add(dmObject);
                    }
                }
                catch (Exception e) {
                    if (!Trace.isTracing) break block5;
                    t.data(66, "OamCreateCumulativeAuthorityRecord.getObjectsByType", 900, "Error getting entity type for " + dmObject.getTitle() + "\n" + e);
                }
            }
            ++i;
        }
        return list;
    }

    private void createUiObjects(Trace t, Hashtable<String, DmAuthorityRecord> objects, OamExplorerTable explorerTable) {
        explorerTable.beginUpdate(t);
        Enumeration<DmAuthorityRecord> e = objects.elements();
        while (e.hasMoreElements()) {
            IDmObject dmAuthRecord = (IDmObject)e.nextElement();
            if (!(dmAuthRecord instanceof DmAuthorityRecord)) continue;
            UiAuthorityRecord uiAuthRecord = (UiAuthorityRecord)explorerTable.getFactoryClass().create(t, dmAuthRecord, null);
            explorerTable.addItem(t, uiAuthRecord);
            this.cumulativeUiAuthorityRecord = uiAuthRecord;
        }
        explorerTable.endUpdate(t);
    }

    public UiAuthorityRecord getCumulativeUiAuthorityRecord() {
        return this.cumulativeUiAuthorityRecord;
    }
}

