/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import java.util.ArrayList;

public class OamCompareAuthorityRecords {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/utils/OamCompareAuthorityRecords.java";
    private UiAuthorityRecord compareUiAuthorityRecord = null;
    private UiAuthorityRecord compareWithUiAuthorityRecord = null;
    private AttrTypeEnum listOfAuthorityIds = null;

    public OamCompareAuthorityRecords(Trace t, UiAuthorityRecord ar1, UiAuthorityRecord ar2, AttrTypeEnum at) {
        this.compareUiAuthorityRecord = ar1;
        this.compareWithUiAuthorityRecord = ar2;
        this.listOfAuthorityIds = at;
    }

    public int[] getDifferentAuthorities(Trace t) {
        int[] differences = new int[]{};
        if (this.compareUiAuthorityRecord != null && this.compareWithUiAuthorityRecord != null) {
            int[] attrsIds = this.getListOfAuthorityIds(t, this.compareUiAuthorityRecord);
            Attr[] ids1 = this.getListOfAuthorities(t, this.compareUiAuthorityRecord, attrsIds);
            Attr[] ids2 = this.getListOfAuthorities(t, this.compareWithUiAuthorityRecord, attrsIds);
            differences = this.getDifferences(t, ids1, ids2);
        } else if (Trace.isTracing) {
            t.data(66, "OamCompareAuthorityRecords.getDifferentAuthorities", 900, "Authority records not defined");
        }
        return differences;
    }

    public int[] getSameAuthorities(Trace t) {
        int[] same = new int[]{};
        if (this.compareUiAuthorityRecord != null && this.compareWithUiAuthorityRecord != null) {
            int[] attrsIds = this.getListOfAuthorityIds(t, this.compareUiAuthorityRecord);
            Attr[] ids1 = this.getListOfAuthorities(t, this.compareUiAuthorityRecord, attrsIds);
            Attr[] ids2 = this.getListOfAuthorities(t, this.compareWithUiAuthorityRecord, attrsIds);
            same = this.getSame(t, ids1, ids2);
        } else if (Trace.isTracing) {
            t.data(66, "OamCompareAuthorityRecords.getSameAuthorities", 900, "Authority records not defined");
        }
        return same;
    }

    public int[] getAuthorities(Trace t) {
        int[] attrsIds = new int[]{};
        if (this.compareUiAuthorityRecord != null && this.compareWithUiAuthorityRecord != null) {
            attrsIds = this.getListOfAuthorityIds(t, this.compareUiAuthorityRecord);
        } else if (Trace.isTracing) {
            t.data(66, "OamCompareAuthorityRecords.getAuthorities", 900, "Authority records not defined");
        }
        return attrsIds;
    }

    private int[] getListOfAuthorityIds(Trace t, UiAuthorityRecord authRecord) {
        int[] ids = new int[]{};
        Integer[] listOfAuthorities = this.listOfAuthorityIds.getEnumerationIds(t);
        ids = new int[listOfAuthorities.length];
        int i = 0;
        while (i < listOfAuthorities.length) {
            ids[i] = listOfAuthorities[i];
            ++i;
        }
        return ids;
    }

    private Attr[] getListOfAuthorities(Trace t, UiAuthorityRecord authRecord, int[] attrIds) {
        Attr[] ids = new Attr[attrIds.length];
        int i = 0;
        while (i < attrIds.length) {
            ids[i] = authRecord.getDmObject().getAttribute(t, attrIds[i], 0);
            ++i;
        }
        return ids;
    }

    private int[] getDifferences(Trace t, Attr[] ids1, Attr[] ids2) {
        ArrayList<Attr> list = new ArrayList<Attr>();
        int[] returnList = null;
        int i = 0;
        while (i < ids1.length) {
            if (!ids1[i].getValue(t).equals(ids2[i].getValue(t))) {
                list.add(ids1[i]);
            }
            ++i;
        }
        returnList = new int[list.size()];
        i = 0;
        while (i < list.size()) {
            returnList[i] = ((Attr)list.get(i)).getAttributeID();
            ++i;
        }
        return returnList;
    }

    private int[] getSame(Trace t, Attr[] ids1, Attr[] ids2) {
        ArrayList<Attr> list = new ArrayList<Attr>();
        int[] returnList = null;
        int i = 0;
        while (i < ids1.length) {
            if (ids1[i].getValue(t).equals(ids2[i].getValue(t))) {
                list.add(ids1[i]);
            }
            ++i;
        }
        returnList = new int[list.size()];
        i = 0;
        while (i < list.size()) {
            returnList[i] = ((Attr)list.get(i)).getAttributeID();
            ++i;
        }
        return returnList;
    }
}

