/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.table;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.dialog.OamExplorerDialog;
import com.ibm.mq.explorer.oam.internal.filter.OamExplorerTreeViewerFilter;
import com.ibm.mq.explorer.oam.internal.filter.OamExplorerTreeViewerSorter;
import com.ibm.mq.explorer.oam.internal.menuaction.OamMenuActionContext;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecordFactory;
import com.ibm.mq.explorer.oam.internal.table.OamExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertree.ExplorerTree;
import com.ibm.mq.explorer.ui.internal.explorertree.ExplorerTreeSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertree.ExplorerTreeSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.explorertree.IHelpIdProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.pcf.event.PCFFilter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

public class OamExplorerTree
implements IHelpIdProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/table/OamExplorerTree.java";
    private ExplorerTree explorerTree = null;
    private Composite parentComposite = null;
    private OamExplorerDialog parentDialog = null;
    private OamObject oamObject = null;
    private UiAuthorityRecord specificProfileTreeNode = null;
    private UiAuthorityRecord genericProfileTreeNode = null;
    private DmAuthorityRecord authorityRecord = null;
    private OamExplorerTable usersExplorerTable = null;
    private OamExplorerTable groupsExplorerTable = null;
    private PCFFilter pcfFilter = null;
    private DmObjectFilter dmObjectFilter = null;

    public OamExplorerTree(Trace t, OamExplorerDialog _dialog, Composite _composite) {
        this.parentComposite = _composite;
        this.oamObject = _dialog.getOamObject();
        this.parentDialog = _dialog;
    }

    public void init(Trace t) {
        OamMenuActionContext ac = new OamMenuActionContext(t, this.parentDialog.getMyShell(), "com.ibm.mq.explorer.oam.explorerTree");
        this.explorerTree = new ExplorerTree(t, this.parentComposite, 0, true, (Object)ac);
        UiAuthorityRecordFactory factoryClass = new UiAuthorityRecordFactory(this.parentDialog.getUiQueueManager());
        this.explorerTree.setUiMQObjectFactoryClass(t, (IUiMQObjectFactory)factoryClass, null);
        this.authorityRecord = (DmAuthorityRecord)DmObjectFactory.create((Trace)t, (DmQueueManager)this.parentDialog.getDmQueueManager(), (int)87, (String)OamPlugin.oamMessages.getMessage("OAM.Specific.Profiles"));
        this.specificProfileTreeNode = (UiAuthorityRecord)factoryClass.create(t, (DmObject)this.authorityRecord, null);
        this.specificProfileTreeNode.setSpecificProfiles(true);
        this.specificProfileTreeNode.setOamObject(this.oamObject);
        this.authorityRecord = (DmAuthorityRecord)DmObjectFactory.create((Trace)t, (DmQueueManager)this.parentDialog.getDmQueueManager(), (int)87, (String)OamPlugin.oamMessages.getMessage("OAM.Generic.Profiles"));
        this.authorityRecord.addAttr(t, 1016, 0, (Object)this.oamObject.getOamObjectType(t));
        this.authorityRecord.initialize(t);
        this.genericProfileTreeNode = (UiAuthorityRecord)factoryClass.create(t, (DmObject)this.authorityRecord, null);
        this.genericProfileTreeNode.setGenericProfiles(true);
        this.genericProfileTreeNode.setOamObject(this.oamObject);
        this.explorerTree.beginUpdate(t);
        this.explorerTree.removeAll(t);
        this.explorerTree.addTreeItem(t, (UiMQObject)this.specificProfileTreeNode);
        this.explorerTree.addTreeItem(t, (UiMQObject)this.genericProfileTreeNode);
        this.explorerTree.endUpdate(t);
        this.explorerTree.addSelChangedListener(t, new ExplorerTreeSelectionChangedListener(){

            public void selChanged(ExplorerTreeSelectionChangedEvent event) {
                Trace t1 = Trace.getDefault();
                OamExplorerTree.this.populateContentPage(t1, event);
            }
        });
        if (this.oamObject.getName(t).equals("*")) {
            this.dmObjectFilter = new DmObjectFilter(t, 87, this.oamObject.getOamObjectType(t));
            this.dmObjectFilter.setAuthorityOptions(t, OamCommon.AUTH_OPTIONS_WILDCARD);
        } else {
            this.dmObjectFilter = new DmObjectFilter(t, this.oamObject.getName(t), 87, this.oamObject.getOamObjectType(t));
            this.dmObjectFilter.setAuthorityOptions(t, OamCommon.AUTH_OPTIONS);
        }
        OamExplorerTreeViewerFilter explorerView = new OamExplorerTreeViewerFilter();
        explorerView.setSpecificProfileTreeNode(this.specificProfileTreeNode);
        explorerView.setGenericProfileTreeNode(this.genericProfileTreeNode);
        this.explorerTree.addViewerFilter(t, (ViewerFilter)explorerView);
        OamExplorerTreeViewerSorter sorter = new OamExplorerTreeViewerSorter();
        sorter.setSpecificProfiles(this.specificProfileTreeNode);
        sorter.setGenericProfiles(this.genericProfileTreeNode);
        this.explorerTree.setSorter(t, (ViewerSorter)sorter);
        this.explorerTree.setHelpIdProvider(t, (IHelpIdProvider)this);
        this.startListening(t);
        if (this.parentComposite.getLayout() instanceof GridLayout) {
            GridData gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalSpan = 1;
            this.explorerTree.setLayoutData((Object)gridData);
        }
    }

    public void setUsersExplorerTable(OamExplorerTable table) {
        this.usersExplorerTable = table;
    }

    public void setGroupsExplorerTable(OamExplorerTable table) {
        this.groupsExplorerTable = table;
    }

    public OamExplorerTable getUsersExplorerTable() {
        return this.usersExplorerTable;
    }

    public OamExplorerTable getGroupsExplorerTable() {
        return this.groupsExplorerTable;
    }

    private void populateContentPage(Trace t, ExplorerTreeSelectionChangedEvent event) {
        UiAuthorityRecord authRecord = (UiAuthorityRecord)event.getObject();
        if (authRecord.getOamObject() == null) {
            authRecord.setOamObject(this.parentDialog.getOamObject());
            if (Trace.isTracing) {
                t.data(66, "OamExplorerTree.populateContentPage", 300, "Reset Oam context");
            }
        }
        this.parentDialog.getOamObject().setUiAuthorityRecord(authRecord);
        if (!authRecord.isSpecificProfilesTreeNode() && !authRecord.isGenericProfilesTreeNode()) {
            if (this.usersExplorerTable != null) {
                this.usersExplorerTable.stopListening(t);
                this.pcfFilter = PCFFilter.getFilter((int)1118, (PCFFilter.Operation)PCFFilter.EQUAL_TO, (int)1);
                this.dmObjectFilter = new DmObjectFilter(t, event.getObject().toFormattedString(), 87, this.oamObject.getOamObjectType(t), this.pcfFilter);
                this.dmObjectFilter.setAuthorityOptions(t, OamCommon.AUTH_OPTIONS_X);
                this.usersExplorerTable.startListening(t, this.dmObjectFilter);
            }
            if (this.groupsExplorerTable != null) {
                this.groupsExplorerTable.stopListening(t);
                this.pcfFilter = PCFFilter.getFilter((int)1118, (PCFFilter.Operation)PCFFilter.EQUAL_TO, (int)2);
                this.dmObjectFilter = new DmObjectFilter(t, event.getObject().toFormattedString(), 87, this.oamObject.getOamObjectType(t), this.pcfFilter);
                this.dmObjectFilter.setAuthorityOptions(t, OamCommon.AUTH_OPTIONS_X);
                this.groupsExplorerTable.startListening(t, this.dmObjectFilter);
            }
        }
        this.parentDialog.getContent().displayContentPage(t);
    }

    private void startListening(Trace t) {
        if (this.explorerTree != null && this.dmObjectFilter != null) {
            this.explorerTree.startListener(t, (IDmObservable)this.parentDialog.getDmQueueManager(), this.dmObjectFilter);
        }
    }

    public void stopListening(Trace t) {
        if (this.explorerTree != null) {
            this.explorerTree.stopListener(t, (IDmObservable)this.parentDialog.getDmQueueManager());
            this.explorerTree.removeAll(t);
        }
    }

    public void refreshExplorerTree(Trace t) {
        if (this.explorerTree != null) {
            this.explorerTree.refresh(t);
        }
    }

    public String getHelpId(UiMQObject uiMQObject) {
        UiAuthorityRecord authRecord = null;
        String helpId = null;
        if (uiMQObject instanceof UiAuthorityRecord) {
            authRecord = (UiAuthorityRecord)uiMQObject;
            if (authRecord.isGenericProfilesTreeNode()) {
                helpId = "com.ibm.mq.explorer.oam.infopop.OAM_GenericProfilesTreenode";
            } else if (authRecord.isSpecificProfilesTreeNode()) {
                helpId = "com.ibm.mq.explorer.oam.infopop.OAM_SpecificProfilesTreenode";
            } else if (authRecord.isGenericProfile()) {
                helpId = "com.ibm.mq.explorer.oam.infopop.OAM_GenericProfileTreenode";
            } else if (authRecord.isSpecificProfile()) {
                helpId = "com.ibm.mq.explorer.oam.infopop.OAM_SpecificProfileTreenode";
            }
        }
        return helpId;
    }
}

