/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.table;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.oam.internal.attribute.OamAttributeDetails;
import com.ibm.mq.explorer.oam.internal.content.OamExplorerTableContentPage;
import com.ibm.mq.explorer.oam.internal.dialog.OamDialog;
import com.ibm.mq.explorer.oam.internal.filter.OamExplorerTableViewerFilter;
import com.ibm.mq.explorer.oam.internal.filter.OamViewerFilter;
import com.ibm.mq.explorer.oam.internal.preference.OamPreferencePage;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeDetails;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectFactory;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

public class OamExplorerTable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/table/OamExplorerTable.java";
    private ExplorerTable explorerTable = null;
    private Composite parentComposite = null;
    private OamDialog parentDialog = null;
    private AttributeOrderManager attrOrderManager = null;
    private OamExplorerTableViewerFilter explorerViewFilter = null;
    private OamExplorerTableContentPage contentPage = null;
    private String objectId = "";
    private boolean sorting = true;
    private boolean statusBar = true;
    private boolean tableTree = false;
    private UiMQObjectFactory uiFactoryClass = null;

    public OamExplorerTable(Trace t, OamDialog _dialog, Composite _composite) {
        this.parentComposite = _composite;
        this.parentDialog = _dialog;
    }

    public void init(Trace t, String id, UiMQObjectFactory factory, String orderId, OamAttributeDetails aDetails, OamViewerFilter viewer, boolean stBar, boolean tree) {
        this.objectId = id;
        this.statusBar = stBar;
        this.tableTree = tree;
        this.explorerTable = new ExplorerTable(t, this.parentComposite, 0, this.objectId, false, false, this.statusBar, true, (Object)"com.ibm.mq.explorer.oam.explorerTable", this.tableTree ? 1 : 0, null, false);
        this.explorerTable.setSorting(t, this.sorting);
        this.attrOrderManager = UiPlugin.getAttributeOrderManager();
        this.attrOrderManager.register(t, (IAttributeDetails)aDetails, this.objectId, orderId, "AuthorityRecordsExplorerTable", aDetails.getDefaultAttributeOrder(t));
        this.explorerTable.setObjectId(t, this.objectId);
        this.explorerTable.setAttributeOrderId(t, orderId);
        this.explorerTable.setInstance(t, this.parentDialog.getExplorerTableInstanceId(t), true);
        this.uiFactoryClass = factory;
        this.explorerTable.setUiMQObjectFactoryClass(t, (IUiMQObjectFactory)this.uiFactoryClass, null);
        if (viewer != null) {
            this.explorerTable.addViewerFilter(t, (ViewerFilter)viewer);
        }
        this.explorerTable.setTickCrossMode(t, !OamPreferencePage.displayAsText, Icons.get((String)Icons.iconkeyTick), Icons.get((String)Icons.iconkeyBlank));
        this.explorerTable.addSelChangedListener(t, new ExplorerTableSelectionChangedListener(){

            public void selChanged(ExplorerTableSelectionChangedEvent event) {
                Trace t2 = Trace.getDefault();
                if (OamExplorerTable.this.contentPage != null) {
                    OamExplorerTable.this.contentPage.enableButtons(t2);
                }
                OamExplorerTable.this.parentDialog.enableButtons(t2);
            }
        });
        if (this.parentComposite.getLayout() instanceof GridLayout) {
            GridData gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.widthHint = 100;
            this.explorerTable.setLayoutData((Object)gridData);
        }
    }

    public void init(Trace t, String id, UiMQObjectFactory factory, String orderId, OamAttributeDetails aDetails, boolean viewer, boolean stBar, boolean tree) {
        if (viewer) {
            this.explorerViewFilter = new OamExplorerTableViewerFilter();
        }
        this.init(t, id, factory, orderId, aDetails, this.explorerViewFilter, stBar, tree);
    }

    public void startListening(Trace t, DmObjectFilter dmFilter) {
        if (this.explorerTable != null) {
            if (this.contentPage != null) {
                this.contentPage.enableButtons(t);
            }
            this.explorerTable.startListener(t, (IDmObservable)this.parentDialog.getDmQueueManager(), dmFilter);
        }
    }

    public void stopListening(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.stopListener(t, (IDmObservable)this.parentDialog.getDmQueueManager());
            this.explorerTable.removeAll(t);
        }
    }

    public void refreshTable(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.refresh();
        }
    }

    public void setOwner(OamExplorerTableContentPage owner) {
        this.contentPage = owner;
    }

    public void addItem(Trace t, UiMQObject object) {
        if (this.explorerTable != null) {
            this.explorerTable.addTableItem(t, object);
        }
    }

    public void beginUpdate(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.beginUpdate(t);
        }
    }

    public void endUpdate(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.endUpdate(t);
        }
    }

    public void clearTable(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.removeAll(t);
        }
    }

    public UiMQObject getSelection(Trace t) {
        if (this.explorerTable != null) {
            return this.explorerTable.getSelectedItem(t);
        }
        return null;
    }

    public UiMQObjectFactory getFactoryClass() {
        return this.uiFactoryClass;
    }

    public void setSorting(boolean b) {
        this.sorting = b;
    }

    public void beginColumnUpdate(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.beginColumnUpdate(t);
        }
    }

    public void endColumnUpdate(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.endColumnUpdate(t);
        }
    }

    public void showColumn(Trace t, int attrId, boolean visible) {
        if (this.explorerTable != null) {
            this.explorerTable.showColumn(t, attrId, visible);
        }
    }

    public void updateLastRefreshText(Trace t) {
        if (this.statusBar) {
            this.explorerTable.updateLastRefreshText(t);
        }
    }

    public int getItemCount(Trace t) {
        int items = 0;
        if (this.explorerTable != null) {
            items = this.explorerTable.getItemCount(t);
        }
        return items;
    }

    public void expandAll(Trace t) {
        if (this.explorerTable != null && this.tableTree) {
            this.explorerTable.expandAll(t);
        }
    }

    public void collapseAll(Trace t) {
        if (this.explorerTable != null && this.tableTree) {
            this.explorerTable.collapseAll(t);
        }
    }

    public ArrayList<MQExtObject> getObjects(Trace t) {
        ArrayList objects = new ArrayList();
        if (this.explorerTable != null) {
            objects = this.explorerTable.getObjects(t);
        }
        return objects;
    }
}

