/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.preference;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class OamPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/preference/OamPreferencePage.java";
    private Button displayAsIconsButton = null;
    private Button displayAsTextButton = null;
    private Listener listener = null;
    private Composite buttonComposite = null;
    public static boolean displayAsText = false;

    protected Control createContents(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        UiPlugin.getHelpSystem().setHelp((Control)composite, "com.ibm.mq.explorer.oam.infopop.OAM_PreferencesPage");
        UiPlugin.getHelpSystem().setHelp(this.getControl(), "com.ibm.mq.explorer.oam.infopop.OAM_PreferencesPage");
        if (Trace.isTracing) {
            t.data(66, "OamPreferencePage.createContents", 300, "Setting preference page infopop id com.ibm.mq.explorer.oam.infopop.OAM_PreferencesPage");
        }
        Group accessibilityGroup = new Group(composite, 0);
        accessibilityGroup.setText(OamPlugin.oamMessages.getMessage("OAM.Accessibility"));
        gridLayout = new GridLayout();
        accessibilityGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        accessibilityGroup.setLayoutData((Object)gridData);
        this.buttonComposite = new Composite((Composite)accessibilityGroup, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        this.buttonComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.buttonComposite.setLayoutData((Object)gridData);
        this.createListener(t);
        this.displayAsIconsButton = new Button(this.buttonComposite, 16);
        this.displayAsIconsButton.setText(OamPlugin.oamMessages.getMessage("OAM.Preferences.Display.Icons"));
        gridData = new GridData(768);
        this.displayAsIconsButton.setLayoutData((Object)gridData);
        this.displayAsIconsButton.addListener(13, this.listener);
        this.displayAsTextButton = new Button(this.buttonComposite, 16);
        this.displayAsTextButton.setText(OamPlugin.oamMessages.getMessage("OAM.Preferences.Display.Text"));
        gridData = new GridData(768);
        this.displayAsTextButton.setLayoutData((Object)gridData);
        this.displayAsTextButton.addListener(13, this.listener);
        this.displayAsIconsButton.setSelection(!displayAsText);
        this.displayAsTextButton.setSelection(displayAsText);
        if (Trace.isTracing) {
            t.data(66, "OamPreferencePage.createContents", 300, "Setting display as icons to " + !displayAsText);
        }
        return composite;
    }

    protected void performDefaults() {
        displayAsText = false;
        this.displayAsIconsButton.setSelection(true);
        this.displayAsTextButton.setSelection(false);
        OamPreferencePage.getUiPreferenceStore().setValue("DisplayAuthoritiesAsText", false);
    }

    public boolean performOk() {
        Trace t = Trace.getDefault();
        displayAsText = this.displayAsTextButton.getSelection();
        OamPreferencePage.getUiPreferenceStore().setValue("DisplayAuthoritiesAsText", displayAsText);
        if (Trace.isTracing) {
            t.data(66, "OamPreferencePage.performOk", 300, "User setting display as icons to " + !displayAsText);
        }
        return super.performOk();
    }

    public static IPreferenceStore getUiPreferenceStore() {
        return UiPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
        Trace t = Trace.getDefault();
        OamPreferencePage.initialize(t);
    }

    private void createListener(Trace t) {
        this.listener = new Listener(){

            public void handleEvent(Event e) {
                Control[] children = OamPreferencePage.this.buttonComposite.getChildren();
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    if (child instanceof Button) {
                        ((Button)child).setSelection(false);
                    }
                    ++i;
                }
                ((Button)e.widget).setSelection(true);
            }
        };
    }

    public static void initialize(Trace t) {
        try {
            displayAsText = OamPreferencePage.getUiPreferenceStore().getBoolean("DisplayAuthoritiesAsText");
            if (Trace.isTracing) {
                t.data(66, "OamPreferencePage.initialize", 300, "Saved setting for display as icons is " + !displayAsText);
            }
        }
        catch (NullPointerException nullPointerException) {
            if (Trace.isTracing) {
                t.data(66, "OamPreferencePage.initialize", 300, "Error getting attribute for display as icons");
            }
            displayAsText = false;
            OamPreferencePage.getUiPreferenceStore().setDefault("DisplayAuthoritiesAsText", false);
            OamPreferencePage.getUiPreferenceStore().setValue("DisplayAuthoritiesAsText", false);
        }
    }
}

