/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.dialog.OamSimpleRoleBasedAuthoritiesDialog;
import com.ibm.mq.explorer.oam.internal.pcf.OamCommonPCF;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import com.ibm.mq.pcf.event.PCFQuery;
import java.io.IOException;
import org.eclipse.swt.widgets.Shell;

public class OamSetCreateRoleBasedAuthorities
extends OamCommonPCF {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/pcf/OamSetCreateRoleBasedAuthorities.java";
    OamSimpleRoleBasedAuthoritiesDialog threadDialog = null;
    int rc = 2149;
    private static final int[] PARAMETERS = new int[]{12, 1, 3, 8, 6, 2, 7, 9, 1014, 11, 5};
    private static final int[] TOPIC_FULLADMIN_AUTHS = new int[]{3, 6, 7, 8, 4, 17};
    private static final int[] QUEUE_FULLADMIN_AUTHS = new int[]{3, 6, 7, 8, 4};
    private static final int[] QUEUE_FULLADMIN_WITH_BROWSE_AUTHS = new int[]{3, 6, 7, 8, 4, 2};
    private static final int[] CHANNEL_FULLADMIN_AUTHS = new int[]{3, 6, 7, 8, 17, 18};
    private static final int[] SERVICE_LISTENER_FULLADMIN_AUTHS = new int[]{3, 6, 7, 8, 17};
    private static final int[] OTHER_PROFILES_FULLADMIN_AUTHS = new int[]{3, 6, 7, 8};
    private static final int[] AUTHS_FOR_MODEL_QUEUE = new int[]{8, 10, 9};
    private static final int[] AUTHS_FOR_ADMIN_QUEUE = new int[]{8, 10, 11};
    private static final int[] AUTHS_FOR_QMGR_READ_ONLY = new int[]{8, 10, 5};
    private static final int[] AUTHS_FOR_QMGR_FULL_ADMIN_PRE_710 = new int[]{10, 5, 3, 7, 8};
    private static final int[] AUTHS_FOR_QMGR_FULL_ADMIN_710 = new int[]{10, 5, 17, 3, 7, 8};

    public OamSetCreateRoleBasedAuthorities(Trace t, Shell _shell, DmAuthorityRecord _record, OamSimpleRoleBasedAuthoritiesDialog roleBasedAuthDialog) {
        super(t, _shell, _record);
        this.threadDialog = roleBasedAuthDialog;
    }

    public int executeCommands(Trace t, MQQueueManager queueManager, boolean isBrowse, String eName, boolean isGroup, boolean isFullAdmin) {
        String queueManagerName;
        PCFMessageAgent agent;
        block40: {
            agent = null;
            queueManagerName = null;
            try {
                queueManagerName = queueManager.getName();
                agent = new PCFMessageAgent(queueManager);
            }
            catch (MQException mqe) {
                if (!Trace.isTracing) break block40;
                t.data(65, "OamSetCreateRoleBasedAuthorities.executeCommands", 900, "Error extracting PCFMessage from MQException : " + mqe.toString());
            }
        }
        int entType = isGroup ? 3066 : 3065;
        int i = 0;
        while (i < PARAMETERS.length) {
            PCFMessage exeCmds;
            block42: {
                block41: {
                    if (Trace.isTracing) {
                        t.data(65, "OamSetCreateRoleBasedAuthorities.executeCommands", 300, "Creating PCFMessage to set the authorisations of **");
                    }
                    exeCmds = new PCFMessage(90);
                    exeCmds.addParameter(3067, "**");
                    exeCmds.addParameter(1016, PARAMETERS[i]);
                    if (!isFullAdmin) break block41;
                    if (Trace.isTracing) {
                        t.data(65, "OamSetCreateRoleBasedAuthorities.executeCommands", 300, "Adding full administrative access authoritities to object type " + PARAMETERS[i]);
                    }
                    switch (PARAMETERS[i]) {
                        case 8: {
                            exeCmds.addParameter(1116, TOPIC_FULLADMIN_AUTHS);
                            break;
                        }
                        case 1: {
                            if (isBrowse) {
                                exeCmds.addParameter(1116, QUEUE_FULLADMIN_WITH_BROWSE_AUTHS);
                                break;
                            }
                            exeCmds.addParameter(1116, QUEUE_FULLADMIN_AUTHS);
                            break;
                        }
                        case 6: {
                            exeCmds.addParameter(1116, CHANNEL_FULLADMIN_AUTHS);
                            break;
                        }
                        case 11: 
                        case 12: {
                            exeCmds.addParameter(1116, SERVICE_LISTENER_FULLADMIN_AUTHS);
                            break;
                        }
                        case 5: {
                            exeCmds.addParameter(3067, queueManagerName);
                            try {
                                if (queueManager.getCommandLevel() >= 710) {
                                    exeCmds.addParameter(1116, AUTHS_FOR_QMGR_FULL_ADMIN_710);
                                    break;
                                }
                                exeCmds.addParameter(1116, AUTHS_FOR_QMGR_FULL_ADMIN_PRE_710);
                            }
                            catch (MQException mQException) {
                                exeCmds.addParameter(1116, AUTHS_FOR_QMGR_FULL_ADMIN_PRE_710);
                            }
                            break block42;
                        }
                        default: {
                            exeCmds.addParameter(1116, OTHER_PROFILES_FULLADMIN_AUTHS);
                            break;
                        }
                    }
                    break block42;
                }
                if (Trace.isTracing) {
                    t.data(65, "OamSetCreateRoleBasedAuthorities.executeCommands", 300, "Adding read only access authoritities to object type " + PARAMETERS[i]);
                }
                switch (PARAMETERS[i]) {
                    case 1: {
                        if (isBrowse) {
                            exeCmds.addParameter(1116, new int[]{8, 2});
                            break;
                        }
                        exeCmds.addParameter(1116, new int[]{8});
                        break;
                    }
                    case 5: {
                        exeCmds.addParameter(3067, queueManagerName);
                        exeCmds.addParameter(1116, AUTHS_FOR_QMGR_READ_ONLY);
                        break;
                    }
                    default: {
                        exeCmds.addParameter(1116, new int[]{8});
                    }
                }
            }
            exeCmds.addParameter(entType, new String[]{eName});
            try {
                PCFMessage[] responseMsgs = agent.send(exeCmds);
                if (responseMsgs != null) {
                    if (Trace.isTracing) {
                        t.data(66, "OamSetCreateRoleBasedAuthorities.executeCommands", 300, String.valueOf(responseMsgs.length) + " response(s)");
                    }
                    PCFMessage message = responseMsgs[0];
                    this.rc = message.getReason();
                }
            }
            catch (IOException e) {
                if (Trace.isTracing) {
                    t.data(65, "OamSetCreateRoleBasedAuthorities.executeCommands", 900, "Error extracting PCFMessage from IOException : " + e.toString());
                }
            }
            catch (MQException mqe) {
                if (Trace.isTracing) {
                    t.data(65, "OamSetCreateRoleBasedAuthorities.executeCommands", 900, "PCF exception : " + mqe.toString());
                }
                this.rc = mqe.reasonCode;
                Trace t1 = Trace.getDefault();
                PCFQuery.traceMQRequest((Trace)t1, (PCFMessage)exeCmds);
                PCFQuery.traceMQException((Trace)t1, (MQException)mqe);
            }
            ++i;
        }
        if (Trace.isTracing) {
            t.data(65, "OamSetCreateRoleBasedAuthorities.executeCommands", 300, "Creating PCFMessage to set the authorisations of SYSTEM.MQEXPLORER.REPLY.MODEL");
        }
        PCFMessage execModelQueueCmd = new PCFMessage(90);
        execModelQueueCmd.addParameter(3067, "SYSTEM.MQEXPLORER.REPLY.MODEL");
        execModelQueueCmd.addParameter(1016, PARAMETERS[1]);
        if (Trace.isTracing) {
            t.data(65, "OamSetCreateRoleBasedAuthorities.executeCommands", 300, "Creating PCFMessage to set the authorisations of SYSTEM.ADMIN.COMMAND.QUEUE");
        }
        PCFMessage execAdminQueueCmd = new PCFMessage(90);
        execAdminQueueCmd.addParameter(3067, "SYSTEM.ADMIN.COMMAND.QUEUE");
        execAdminQueueCmd.addParameter(1016, PARAMETERS[1]);
        execModelQueueCmd.addParameter(1116, AUTHS_FOR_MODEL_QUEUE);
        execAdminQueueCmd.addParameter(1116, AUTHS_FOR_ADMIN_QUEUE);
        execModelQueueCmd.addParameter(entType, new String[]{eName});
        execAdminQueueCmd.addParameter(entType, new String[]{eName});
        try {
            PCFMessage message;
            PCFMessage[] responseMsg1 = agent.send(execModelQueueCmd);
            PCFMessage[] responseMsg2 = agent.send(execAdminQueueCmd);
            if (responseMsg1 != null) {
                if (Trace.isTracing) {
                    t.data(66, "OamSetCreateRoleBasedAuthorities.executeCommands", 300, String.valueOf(responseMsg1.length) + " response(s)");
                }
                message = responseMsg1[0];
                this.rc = message.getReason();
            }
            if (responseMsg2 != null) {
                if (Trace.isTracing) {
                    t.data(66, "OamSetCreateRoleBasedAuthorities.executeCommands", 300, String.valueOf(responseMsg2.length) + " response(s)");
                }
                message = responseMsg2[0];
                this.rc = message.getReason();
            }
        }
        catch (IOException e) {
            if (Trace.isTracing) {
                t.data(65, "OamSetCreateRoleBasedAuthorities.executeCommands", 900, "Error extracting PCFMessage from IOException : " + e.toString());
            }
        }
        catch (MQException mqe) {
            if (Trace.isTracing) {
                t.data(65, "OamSetCreateRoleBasedAuthorities.executeCommands", 900, "PCF exception : " + mqe.toString());
            }
            this.rc = mqe.reasonCode;
        }
        this.threadDialog.bdActionDone();
        return this.rc;
    }

    @Override
    public int apply(Trace t, String message) {
        this.entityName = this.threadDialog.getEntityName(t);
        this.entityType = this.threadDialog.getEntityType(t);
        this.reasonCode = this.rc;
        if (this.reasonCode != 0) {
            this.displayMessage(t);
        }
        return this.reasonCode;
    }

    @Override
    public void sendCommand(Trace t) {
    }
}

