/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.pcf;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.object.OamAuthorityButton;
import com.ibm.mq.explorer.oam.internal.pcf.OamCommonPCF;
import com.ibm.mq.explorer.oam.internal.pcf.OamGetObjects;
import com.ibm.mq.explorer.oam.internal.utils.OamEntity;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class OamSetCreateAuthority
extends OamCommonPCF {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/pcf/OamSetCreateAuthority.java";

    public OamSetCreateAuthority(Trace t, Shell _shell, DmAuthorityRecord _authRecord, boolean _create) {
        super(t, _shell, _authRecord);
        this.create = _create;
        this.dmQueueManager = _authRecord.getQueueManager();
    }

    @Override
    public int apply(Trace t, String message) {
        this.createAddandRemoveLists(t);
        if (this.numberOfResponses > 0) {
            if (this.promptToContinue(t) == 0) {
                this.busyDialog = new BusyDialog(this.parentShell, message);
                this.processLists(t);
                this.busyDialog.showDialog(t);
                if (this.dmActionEvent != null) {
                    this.reasonCode = this.errorException != null ? this.errorException.getReasonCode() : this.dmActionEvent.getReasonCode();
                    if (Trace.isTracing) {
                        t.data(66, "OamSetCreateAuthority.apply", 300, "Set crt authority reason code = " + this.reasonCode);
                    }
                    if (this.reasonCode != 0) {
                        this.displayMessage(t);
                    }
                } else if (Trace.isTracing) {
                    t.data(66, "OamSetCreateAuthority.apply", 900, "Invalid response from action");
                }
            } else {
                this.reasonCode = -3;
                if (Trace.isTracing) {
                    t.data(66, "OamSetCreateAuthority.apply", 300, "User chose not to over-write");
                }
            }
        } else {
            if (Trace.isTracing) {
                t.data(66, "OamSetCreateAuthority.apply", 300, "Lists are empty - nothing to process");
            }
            this.reasonCode = 0;
        }
        return this.reasonCode;
    }

    @Override
    public void sendCommand(Trace t) {
        if (this.create) {
            if (Trace.isTracing) {
                t.data(66, "OamSetCreateAuthority.sendCommand", 300, "Creating new crt authority");
            }
            this.dmAuthorityRecord.actionCreate(t, (DmActionListener)this, this.job);
        } else {
            if (Trace.isTracing) {
                t.data(66, "OamSetCreateAuthority.sendCommand", 300, "Adding/removing crt authorities");
            }
            this.dmAuthorityRecord.actionChange(t, (DmActionListener)this, this.job, true);
        }
    }

    private void createAddandRemoveLists(Trace t) {
        int i = 0;
        while (i < this.listOfButtons.size()) {
            OamAuthorityButton button = (OamAuthorityButton)this.listOfButtons.get(i);
            int auth = DmAuthorityRecord.getRealAuthority((int)button.getAttributeId());
            if (this.create) {
                if (button.isSelected(t)) {
                    this.addedList.add(auth);
                    ++this.numberOfResponses;
                } else {
                    this.removedList.add(auth);
                    ++this.numberOfResponses;
                }
            } else if (button.isAddAuthority(t)) {
                this.addedList.add(auth);
                ++this.numberOfResponses;
            } else if (button.isRemoveAuthority(t)) {
                this.removedList.add(auth);
                ++this.numberOfResponses;
            }
            ++i;
        }
        if (Trace.isTracing) {
            t.data(66, "OamSetCreateAuthority.createAddandRemoveLists", 300, "Response counter initial value =" + this.numberOfResponses);
        }
    }

    @Override
    public void dmActionDone(DmActionEvent event) {
        Trace t = Trace.getDefault();
        --this.numberOfResponses;
        this.dmActionEvent = event;
        if (event.getException() != null) {
            this.errorException = event.getException();
            if (Trace.isTracing) {
                t.data(66, "OamSetCreateAuthority.dmActionDone", 900, "PCF error, rc=" + this.errorException.getReasonCode());
            }
        }
        if (Trace.isTracing) {
            t.data(66, "OamSetCreateAuthority.dmActionDone", 300, "Response counter now =" + this.numberOfResponses);
        }
        if (this.numberOfResponses < 1 && this.busyDialog != null) {
            this.parentShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OamSetCreateAuthority.this.busyDialog.closeDialog(Trace.getDefault());
                    OamSetCreateAuthority.this.busyDialog = null;
                }
            });
        }
    }

    private int promptToContinue(Trace t) {
        String msg = null;
        int reply = 0;
        if (this.create && this.checkForExisting(t)) {
            msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4821");
            String title = OamPlugin.oamMessages.getMessage("OAM.Add.Authorities.Title");
            reply = MessageBox.showYesNoMessage((Trace)t, (Shell)this.parentShell, (String)title, (Image)Icons.get((String)Icons.iconkeyEntityName), (String)msg, (int)1, (String)"AMQ4821");
        }
        return reply;
    }

    private boolean checkForExisting(Trace t) {
        boolean exists = false;
        PCFFilter pcfFilter1 = null;
        DmObjectFilter dmObjectFilter1 = null;
        String eName = this.dmAuthorityRecord.getEntityName(t);
        int eType = this.dmAuthorityRecord.getEntityType(t);
        if (!this.dmQueueManager.isOamUseridsSupported() && eType == 1) {
            exists = this.checkForExisting(t, eName, eType);
        } else {
            pcfFilter1 = PCFFilter.getFilter((int)1115, (PCFFilter.Operation)PCFFilter.CONTAINS, (int)6);
            dmObjectFilter1 = new DmObjectFilter(t, 87, 1001, pcfFilter1);
            dmObjectFilter1.setAuthorityOptions(t, OamCommon.AUTH_OPTIONS_WILDCARD);
            OamGetObjects getQuery = new OamGetObjects(t, this.parentShell, this.dmQueueManager, dmObjectFilter1);
            getQuery.apply(t, OamPlugin.oamMessages.getMessage("OAM.Adding.Authority", this.dmQueueManager.getTitle()), false);
            ArrayList objects = getQuery.getObjects();
            if (objects != null && objects.size() > 0) {
                OamEntity entity1 = new OamEntity(t, eName, eType);
                int i = 0;
                while (i < objects.size()) {
                    OamEntity entity2;
                    IDmObject dmAuthRecord = (IDmObject)objects.get(i);
                    if (dmAuthRecord instanceof DmAuthorityRecord && entity1.equals(entity2 = new OamEntity(t, dmAuthRecord))) {
                        exists = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return exists;
    }

    private boolean checkForExisting(Trace t, String eName, int eType) {
        boolean exists = false;
        int objectType = 0;
        PCFFilter pcfFilter1 = null;
        DmObjectFilter dmObjectFilter1 = null;
        AttrTypeEnum attrType = (AttrTypeEnum)DmQueueManager.getAttributeType((Trace)t, (int)12004);
        if (attrType != null) {
            Integer[] listOfAuthorities = attrType.getEnumerationIds(t);
            int i = 0;
            while (i < listOfAuthorities.length) {
                objectType = this.getObjectType(t, listOfAuthorities[i]);
                pcfFilter1 = PCFFilter.getFilter((int)1115, (PCFFilter.Operation)PCFFilter.CONTAINS, (int)6);
                dmObjectFilter1 = new DmObjectFilter(t, OamCommon.getClassProfileName(this.dmQueueManager.getPlatform()), 87, objectType, pcfFilter1);
                dmObjectFilter1.setEntity(t, eName, eType, OamCommon.AUTH_OPTIONS_E);
                OamGetObjects getQuery = new OamGetObjects(t, this.parentShell, this.dmQueueManager, dmObjectFilter1);
                getQuery.apply(t, OamPlugin.oamMessages.getMessage("OAM.Adding.Authority", this.dmQueueManager.getTitle()), false);
                ArrayList objects = getQuery.getObjects();
                if (objects != null && objects.size() > 0) {
                    exists = true;
                    break;
                }
                ++i;
            }
        }
        return exists;
    }
}

