/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.pcf;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmEntityAuthority;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.object.OamAuthorityButton;
import com.ibm.mq.explorer.oam.internal.pcf.OamCommonPCF;
import com.ibm.mq.explorer.oam.internal.pcf.OamGetObjects;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class OamSetAuthority
extends OamCommonPCF {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/pcf/OamSetAuthority.java";

    public OamSetAuthority(Trace t, Shell _shell, DmAuthorityRecord _authRecord, boolean _create) {
        super(t, _shell, _authRecord);
        this.create = _create;
        this.dmQueueManager = _authRecord.getQueueManager();
    }

    @Override
    public int apply(Trace t, String message) {
        this.job = this.dmAuthorityRecord.beginUpdate(t);
        this.getEntityDetailsFromAuthRecord(t);
        this.addAuthorities(t);
        if (this.addedList.size() != 0 || this.removedList.size() != 0) {
            if (this.promptToContinue(t) == 0) {
                this.busyDialog = new BusyDialog(this.parentShell, message);
                this.sendCommand(t);
                this.busyDialog.showDialog(t);
                if (this.dmActionEvent != null) {
                    this.reasonCode = this.dmActionEvent.getReasonCode();
                    if (Trace.isTracing) {
                        t.data(66, "OamSetAuthority.apply", 300, "Set authority reason code = " + this.reasonCode);
                    }
                    if (this.reasonCode != 0) {
                        this.displayMessage(t);
                    }
                } else if (Trace.isTracing) {
                    t.data(66, "OamSetAuthority.apply", 900, "Invalid response from action");
                }
            } else {
                this.reasonCode = -3;
                if (Trace.isTracing) {
                    t.data(66, "OamSetAuthority.apply", 300, "User chose not to over-write");
                }
            }
        } else {
            if (Trace.isTracing) {
                t.data(66, "OamSetAuthority.apply", 300, "Lists are empty - nothing to process");
            }
            this.reasonCode = 0;
        }
        return this.reasonCode;
    }

    private void addAuthorities(Trace t) {
        int i = 0;
        while (i < this.listOfButtons.size()) {
            OamAuthorityButton button = (OamAuthorityButton)this.listOfButtons.get(i);
            int auth = DmAuthorityRecord.getRealAuthority((int)button.getAttributeId());
            if (this.create) {
                if (button.isSelected(t)) {
                    this.addedList.add(auth);
                } else {
                    this.removedList.add(auth);
                }
            } else if (button.isAddAuthority(t)) {
                this.addedList.add(auth);
            } else if (button.isRemoveAuthority(t)) {
                this.removedList.add(auth);
            }
            ++i;
        }
        if (this.addedList.size() > 0) {
            int[] adds = new int[this.addedList.size()];
            int i2 = 0;
            while (i2 < this.addedList.size()) {
                adds[i2] = (Integer)this.addedList.get(i2);
                ++i2;
            }
            if (Trace.isTracing) {
                t.data(66, "OamSetAuthority.addAuthorities", 300, "Authorities to add : " + adds);
            }
            this.dmAuthorityRecord.createAttribute(t, this.job, 1116, 0, (Object)adds);
        }
        if (this.removedList.size() > 0) {
            int[] removes = new int[this.removedList.size()];
            int i3 = 0;
            while (i3 < this.removedList.size()) {
                removes[i3] = (Integer)this.removedList.get(i3);
                ++i3;
            }
            if (Trace.isTracing) {
                t.data(66, "OamSetAuthority.addAuthorities", 300, "Authorities to remove : " + removes);
            }
            this.dmAuthorityRecord.createAttribute(t, this.job, 1117, 0, (Object)removes);
        }
    }

    @Override
    public void sendCommand(Trace t) {
        if (this.create) {
            if (Trace.isTracing) {
                t.data(66, "OamSetAuthority.sendCommand", 300, "Creating new authority");
            }
            this.dmAuthorityRecord.actionCreate(t, (DmActionListener)this, this.job);
        } else {
            if (Trace.isTracing) {
                t.data(66, "OamSetAuthority.sendCommand", 300, "Changing authorities");
            }
            this.dmAuthorityRecord.actionChange(t, (DmActionListener)this, this.job, true);
        }
    }

    private int promptToContinue(Trace t) {
        String msg = null;
        int reply = 0;
        if (this.create && this.checkForExistingAuths(t)) {
            msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4821");
            String title = OamPlugin.oamMessages.getMessage("OAM.Add.Authorities.Title");
            reply = MessageBox.showYesNoMessage((Trace)t, (Shell)this.parentShell, (String)title, (Image)Icons.get((String)Icons.iconkeyEntityName), (String)msg, (int)1, (String)"AMQ4821");
        }
        return reply;
    }

    private boolean checkForExistingAuths(Trace t) {
        DmObjectFilter checkFilter = null;
        boolean exists = false;
        String eName = this.dmAuthorityRecord.getEntityName(t);
        int eType = this.dmAuthorityRecord.getEntityType(t);
        int auths = OamCommon.AUTH_OPTIONS;
        if (!this.dmQueueManager.isOamUseridsSupported() && eType == 1) {
            auths = OamCommon.AUTH_OPTIONS_E;
        }
        checkFilter = this.dmAuthorityRecord.getProfileType(t) == 5 ? new DmObjectFilter(t, 87, this.dmAuthorityRecord.getProfileType(t)) : new DmObjectFilter(t, this.dmAuthorityRecord.getTitle(), 87, this.dmAuthorityRecord.getProfileType(t));
        checkFilter.setEntity(t, eName, eType, auths);
        OamGetObjects getQuery = new OamGetObjects(t, this.parentShell, this.dmQueueManager, checkFilter);
        getQuery.apply(t, OamPlugin.oamMessages.getMessage("OAM.Adding.Authority", this.dmQueueManager.getTitle()), false);
        ArrayList objects = getQuery.getObjects();
        if (objects != null && objects.size() > 0) {
            String profileName1 = this.dmAuthorityRecord.getTitle();
            if (this.dmAuthorityRecord.getProfileType(t) == 5) {
                profileName1 = "SELF";
            }
            int i = 0;
            while (i < objects.size()) {
                String profileName2;
                IDmObject dmAuthRecord = (IDmObject)objects.get(i);
                if (dmAuthRecord instanceof DmAuthorityRecord && profileName1.equalsIgnoreCase(profileName2 = ((DmAuthorityRecord)dmAuthRecord).getProfileName(t))) {
                    exists = true;
                    break;
                }
                ++i;
            }
        }
        if (!exists && !this.dmQueueManager.isOamUseridsSupported() && eType == 1 && OamCommon.isGenericName(this.dmAuthorityRecord.getTitle())) {
            exists = this.checkForExistingAccumulatedAuths(t);
        }
        return exists;
    }

    private boolean checkForExistingAccumulatedAuths(Trace t) {
        ArrayList i;
        Attr a;
        IDmObject dmAuthRecord;
        DmObjectFilter checkFilter = null;
        boolean exists = false;
        String eName = this.dmAuthorityRecord.getEntityName(t);
        int eType = this.dmAuthorityRecord.getEntityType(t);
        checkFilter = this.dmAuthorityRecord.getProfileType(t) == 5 ? new DmObjectFilter(t, 88, this.dmAuthorityRecord.getProfileType(t)) : new DmObjectFilter(t, this.dmAuthorityRecord.getTitle(), 88, this.dmAuthorityRecord.getProfileType(t));
        checkFilter.setEntity(t, eName, eType);
        OamGetObjects getQuery = new OamGetObjects(t, this.parentShell, this.dmQueueManager, checkFilter);
        getQuery.apply(t, OamPlugin.oamMessages.getMessage("OAM.Adding.Authority", this.dmQueueManager.getTitle()), false);
        ArrayList objects = getQuery.getObjects();
        if (objects != null && objects.size() > 0 && (dmAuthRecord = (IDmObject)objects.get(0)) instanceof DmEntityAuthority && (a = ((DmEntityAuthority)dmAuthRecord).getAttribute(t, 1115, 0)) != null && (i = (ArrayList)a.getValue(t)).size() > 0) {
            exists = true;
        }
        return exists;
    }
}

