/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.pcf;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.pcf.OamCommonPCF;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class OamRefreshSecurity
extends OamCommonPCF {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/pcf/OamRefreshSecurity.java";
    private int securityType = 0;
    private int securityClass = 0;

    public OamRefreshSecurity(Trace t, Shell _shell, DmQueueManager _qm, int _secType) {
        super(t, _shell, null);
        this.dmQueueManager = _qm;
        this.securityType = _secType;
    }

    public OamRefreshSecurity(Trace t, Shell _shell, DmQueueManager _qm, int _secType, int _secItem) {
        this(t, _shell, _qm, _secType);
        this.securityClass = _secItem;
    }

    @Override
    public int apply(Trace t, String busyMessage) {
        if (this.promptToRefresh(t) == 0) {
            this.busyDialog = new BusyDialog(this.parentShell, busyMessage);
            if (Trace.isTracing) {
                t.data(66, "OamRefreshSecurity.apply", 300, "Refreshing security on " + this.dmQueueManager.getTitle());
            }
            this.sendCommand(t);
            this.busyDialog.showDialog(t);
            if (this.dmActionEvent != null) {
                this.reasonCode = this.dmActionEvent.getReasonCode();
                if (Trace.isTracing) {
                    t.data(66, "OamRefreshSecurity.apply", 300, "Refresh security reason code = " + this.reasonCode);
                }
                if (this.reasonCode == 2033) {
                    switch (this.securityType) {
                        case 2: {
                            MessageBox.showSystemMessageById((Trace)t, (Shell)this.parentShell, (String)"AMQ4562");
                            break;
                        }
                        case 3: {
                            MessageBox.showSystemMessageById((Trace)t, (Shell)this.parentShell, (String)"AMQ4568");
                            break;
                        }
                        default: {
                            MessageBox.showSystemMessageById((Trace)t, (Shell)this.parentShell, (String)"AMQ4568");
                            break;
                        }
                    }
                } else if (this.reasonCode != 0) {
                    this.displayMessage(t);
                }
            } else if (Trace.isTracing) {
                t.data(66, "OamRefreshSecurity.apply", 900, "Unknown response from action - no DmActionEvent");
            }
        }
        return this.reasonCode;
    }

    @Override
    public void sendCommand(Trace t) {
        if (this.securityType == 3) {
            this.dmQueueManager.actionRefreshSecurity(t, (DmActionListener)this, this.securityType, this.securityClass);
        } else {
            this.dmQueueManager.actionRefreshSecurity(t, (DmActionListener)this, this.securityType);
        }
    }

    protected int promptToRefresh(Trace t) {
        String msg = null;
        String helpId = null;
        switch (this.securityType) {
            case 1: {
                msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4816");
                helpId = "AMQ4816";
                break;
            }
            case 4: {
                msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4833");
                helpId = "AMQ4833";
                break;
            }
            case 3: {
                msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4817");
                helpId = "AMQ4817";
                break;
            }
            case 2: {
                msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4813", (String)this.dmQueueManager.getTitle());
                helpId = "AMQ4813";
                break;
            }
            default: {
                msg = "";
                helpId = "";
            }
        }
        String title = OamPlugin.oamMessages.getMessage("OAM.Refresh.Security.Title");
        int reply = MessageBox.showYesNoMessage((Trace)t, (Shell)this.parentShell, (String)title, (Image)Icons.get((String)Icons.iconkeyEntityName), (String)msg, (int)1, (String)helpId);
        return reply;
    }
}

