/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.pcf;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.dialog.OamFindDialog;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.pcf.OamCommonPCF;
import com.ibm.mq.explorer.oam.internal.pcf.OamFilterFindObjects;
import com.ibm.mq.explorer.oam.internal.pcf.OamGetAccumulatedAuthority;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectFactory;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class OamGetFindObjects
extends OamCommonPCF {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/pcf/OamGetFindObjects.java";
    private ArrayList uiObjects = new ArrayList();
    private OamFindDialog dialog = null;
    private boolean isGenericProfile = false;
    private UiMQObjectFactory uiFactory = null;

    public OamGetFindObjects(Trace t, Shell _shell, DmQueueManager _qm, OamFindDialog _dialog, boolean _generic, UiMQObjectFactory _factory) {
        super(t, _shell, _qm, null);
        this.dialog = _dialog;
        this.isGenericProfile = _generic;
        this.uiFactory = _factory;
    }

    @Override
    public int apply(Trace t, String message) {
        this.dmObjectFilter = this.createFilter(t);
        if (this.dmObjectFilter != null) {
            this.busyDialog = new BusyDialog(this.parentShell, message);
            this.sendCommand(t);
            this.busyDialog.showDialog(t);
            if (this.dmObjectListEvent != null) {
                if (this.dialog.isRecordTypeAccumulated(t)) {
                    this.uiObjects = this.dmObjectListEvent.getList();
                } else {
                    ArrayList o1 = this.dmObjectListEvent.getList();
                    OamFilterFindObjects filter = new OamFilterFindObjects(t, this.profileName, this.isGenericProfile, false, this.entityName, this.dialog.getEntityType(t));
                    ArrayList<IDmObject> o2 = filter.filterResponse(t, o1);
                    this.uiObjects = this.createUiObjects(t, o2);
                }
                if (this.dmObjectListEvent.getException() != null) {
                    this.reasonCode = this.dmObjectListEvent.getException().getReasonCode();
                    if (this.reasonCode != 0) {
                        this.displayMessage(t);
                    }
                }
            }
        } else {
            this.reasonCode = 3208;
        }
        return this.reasonCode;
    }

    public ArrayList getObjects() {
        return this.uiObjects;
    }

    @Override
    public void sendCommand(Trace t) {
        if (this.dialog.isRecordTypeAccumulated(t)) {
            OamGetAccumulatedAuthority thread = new OamGetAccumulatedAuthority(t, this, this.parentShell, this.dmQueueManager, this.dmObjectFilter, this.uiFactory, this.isGenericProfile, this.profileName, this.entityName, this.dialog.getEntityType(t));
            thread.start();
        } else {
            this.dmQueueManager.getObjects(t, (DmObjectListListener)this, this.dmObjectFilter);
        }
    }

    private DmObjectFilter createFilter(Trace t) {
        this.entityName = this.dialog.getEntityName(t);
        int eType = this.dialog.getEntityType(t);
        this.entityType = this.getEntityType(t, eType);
        this.profileName = this.dialog.getProfileName(t);
        int profileType = this.dialog.getProfileType(t);
        if (Trace.isTracing) {
            t.data(66, "OamGetFindObjects.createFilter", 300, "Profile name : " + this.profileName + ", type : " + profileType + ", entity name : " + this.entityName + ", type : " + eType);
        }
        if (this.dmQueueManager.isOamUseridsSupported() && (eType == 2 || eType == 1) && !this.dialog.isRecordTypeAccumulated(t)) {
            this.pcfFilter = PCFFilter.getFilter((int)1118, (PCFFilter.Operation)PCFFilter.EQUAL_TO, (int)eType);
        }
        if (this.profileName.equalsIgnoreCase("") || this.profileName.endsWith("*")) {
            this.dmObjectFilter = new DmObjectFilter(t, 87, profileType, this.pcfFilter);
            this.dmObjectFilter.setAuthorityOptions(t, OamCommon.AUTH_OPTIONS_WILDCARD);
        } else {
            this.dmObjectFilter = new DmObjectFilter(t, this.profileName, 87, profileType, this.pcfFilter);
            this.dmObjectFilter.setAuthorityOptions(t, OamCommon.AUTH_OPTIONS);
        }
        if (!(this.entityName.equalsIgnoreCase("") || eType != 2 && eType != 1)) {
            this.dmObjectFilter.setEntity(t, this.entityName, eType);
            if (this.dialog.isRecordTypeAccumulated(t) && !this.profileName.equalsIgnoreCase("")) {
                this.dmObjectFilter.setAuthorityOptions(t, OamCommon.AUTH_OPTIONS_E);
                if (this.checkGenericName(t, this.profileName)) {
                    return null;
                }
            }
        }
        return this.dmObjectFilter;
    }

    private ArrayList createUiObjects(Trace t, ArrayList objects) {
        ArrayList<UiAuthorityRecord> uiListOfObjects = new ArrayList<UiAuthorityRecord>();
        if (Trace.isTracing) {
            t.data(66, "OamGetFindObjects.createUiObjects", 300, "Number of data model authority records : " + objects.size());
        }
        int i = 0;
        while (i < objects.size()) {
            IDmObject dmAuthRecord = (IDmObject)objects.get(i);
            if (dmAuthRecord instanceof DmAuthorityRecord) {
                UiAuthorityRecord uiAuthRecord = (UiAuthorityRecord)this.uiFactory.create(t, dmAuthRecord, null);
                uiListOfObjects.add(uiAuthRecord);
            } else if (Trace.isTracing) {
                t.data(66, "OamGetFindObjects.createUiObjects", 900, "Not a data model authority record : " + dmAuthRecord.getTitle());
            }
            ++i;
        }
        return uiListOfObjects;
    }

    private boolean checkGenericName(Trace t, String name) {
        String msg = null;
        boolean generic = false;
        if (OamCommon.isGenericName(name)) {
            generic = true;
            msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4822");
            MessageBox.showMessageFailure((Trace)t, (Shell)this.parentShell, (String)msg, (String)"AMQ4822", (Image)Icons.get((String)Icons.iconkeyEntityName));
        }
        return generic;
    }
}

