/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.pcf;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObjectLink;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import com.ibm.mq.explorer.oam.internal.object.UiAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.pcf.OamFilterFindObjects;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectFactory;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Shell;

public class OamGetAccumulatedAuthority
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/pcf/OamGetAccumulatedAuthority.java";
    public static final String MY_NAME = "IBM MQ get accumulated authorities";
    private ArrayList uiObjects = new ArrayList();
    private DmObjectFilter dmObjectFilter = null;
    private DmQueueManager dmQueueManager = null;
    private UiMQObjectFactory uiFactoryClass = null;
    private String profileName = null;
    private String entityName = null;
    private int entityType = 0;
    private boolean isGenericProfile = false;
    private DmObjectListListener listener = null;
    private DmCoreException dmCoreException = null;

    public OamGetAccumulatedAuthority(Trace t, DmObjectListListener _listener, Shell _shell, DmQueueManager _qm, DmObjectFilter _filter, UiMQObjectFactory _factory, boolean _generic, String _pName, String _eName, int _eType) {
        this.setName(MY_NAME);
        this.listener = _listener;
        this.dmObjectFilter = _filter;
        this.dmQueueManager = _qm;
        this.uiFactoryClass = _factory;
        this.isGenericProfile = _generic;
        this.profileName = _pName;
        this.entityName = _eName;
        this.entityType = _eType;
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        this.execute(t);
        DmObjectListEvent event = new DmObjectListEvent((Object)this, null, this.uiObjects, this.dmCoreException);
        this.listener.dmObjectListDone(event);
    }

    private void execute(Trace t) {
        try {
            ArrayList list = this.dmQueueManager.getObjects(t, this.dmObjectFilter);
            if (Trace.isTracing) {
                t.data(66, "OamGetAccumulatedAuthority.execute", 300, "Number of authority records from data model : " + list.size());
            }
            if (this.dmObjectFilter.getAuthorityOptions() == OamCommon.AUTH_OPTIONS_E) {
                if (list.size() > 0) {
                    this.createCumulativeObject(t, list, this.dmObjectFilter.getSubType(), this.profileName, this.entityName, this.dmObjectFilter.getEntityType());
                }
            } else {
                OamFilterFindObjects localFilter = new OamFilterFindObjects(t, this.profileName, this.isGenericProfile, true, this.entityName, this.entityType);
                ArrayList<IDmObject> filteredList = localFilter.filterResponse(t, list);
                if (Trace.isTracing) {
                    t.data(66, "OamGetAccumulatedAuthority.execute", 300, "Number of authority records after filter : " + filteredList.size());
                }
                this.processResponse(t, filteredList);
            }
        }
        catch (DmCoreException e) {
            if (Trace.isTracing) {
                t.data(66, "OamGetAccumulatedAuthority.execute", 900, "Error getting accumulated authorities\n" + (Object)((Object)e));
            }
            this.dmCoreException = e;
        }
    }

    private void processResponse(Trace t, ArrayList list) {
        try {
            int i = 0;
            while (i < list.size()) {
                IDmObject dmAuthRecord = (IDmObject)list.get(i);
                if (dmAuthRecord instanceof DmAuthorityRecord) {
                    String pName = dmAuthRecord.getAttributeValue(t, 3067, 0);
                    int pType = this.getProfileType(t, dmAuthRecord);
                    String eName = dmAuthRecord.getAttributeValue(t, 3068, 0);
                    int eType = this.getEntityType(t, dmAuthRecord);
                    if (eType == 2) {
                        eName = this.extractGroupName(t, eName);
                    }
                    if (Trace.isTracing) {
                        t.data(66, "OamGetAccumulatedAuthority.processResponse", 300, "Profile name : " + pName + ", type : " + pType + ", entity name : " + eName + ", type : " + eType);
                    }
                    if (pName != null && !pName.equalsIgnoreCase(OamCommon.getClassProfileName(dmAuthRecord.getQueueManager().getPlatform())) && !OamCommon.isGenericName(pName)) {
                        this.dmObjectFilter = pType == 5 ? new DmObjectFilter(t, 87, pType) : new DmObjectFilter(t, pName, 87, pType);
                        this.dmObjectFilter.setEntity(t, eName, eType, OamCommon.AUTH_OPTIONS_E);
                        ArrayList accumulatedList = this.dmQueueManager.getObjects(t, this.dmObjectFilter, false);
                        if (Trace.isTracing) {
                            t.data(66, "OamGetAccumulatedAuthority.processResponse", 300, "Number of accumulated authority records from data model : " + accumulatedList.size());
                        }
                        if (accumulatedList.size() > 0) {
                            this.createCumulativeObject(t, accumulatedList, pType, pName, eName, eType);
                        }
                    }
                }
                ++i;
            }
        }
        catch (DmCoreException e) {
            if (Trace.isTracing) {
                t.data(66, "OamGetAccumulatedAuthority.processResponse", 900, "Error getting accumulated authorities\n" + (Object)((Object)e));
            }
            this.dmCoreException = e;
        }
    }

    private int getProfileType(Trace t, IDmObject auth) {
        int pType;
        block2: {
            pType = 0;
            try {
                Integer objectType = (Integer)auth.getAttribute(t, 1016, 0).getValue(t);
                pType = objectType;
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block2;
                t.data(66, "OamGetAccumulatedAuthority.getProfileType", 900, "Error getting profile type for " + auth.getTitle() + "\n" + e);
            }
        }
        return pType;
    }

    private int getEntityType(Trace t, IDmObject auth) {
        int eType;
        block2: {
            eType = 0;
            try {
                Integer entityType = (Integer)auth.getAttribute(t, 1118, 0).getValue(t);
                eType = entityType;
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block2;
                t.data(66, "OamGetAccumulatedAuthority.getEntityType", 900, "Error getting entity type for " + auth.getTitle() + "\n" + e);
            }
        }
        return eType;
    }

    private void createCumulativeObject(Trace t, ArrayList objects, int profileType, String profileName, String entityName, int entityType) {
        ArrayList<Integer> cumulative = new ArrayList<Integer>();
        DmAuthorityRecord dmCumulativeAuthority = (DmAuthorityRecord)DmObjectFactory.create((Trace)t, (DmQueueManager)this.dmQueueManager, (int)87, (String)"Parent");
        if (Trace.isTracing) {
            t.data(66, "OamGetAccumulatedAuthority.createCumulativeObject", 300, "Number of accumulated authority records : " + objects.size());
        }
        int i = 0;
        while (i < objects.size()) {
            IDmObject dmAuthRecord = (IDmObject)objects.get(i);
            String pName = dmAuthRecord.getAttributeValue(t, 3067, 0);
            if (Trace.isTracing) {
                t.data(66, "OamGetAccumulatedAuthority.createCumulativeObject", 300, "Profile name : " + pName);
            }
            if (!pName.equalsIgnoreCase(OamCommon.getClassProfileName(dmAuthRecord.getQueueManager().getPlatform()))) {
                Attr authListAttr = dmAuthRecord.getAttribute(t, 1115, 0);
                ArrayList listOfAuthorities = (ArrayList)authListAttr.getValue(t);
                int j = 0;
                while (j < listOfAuthorities.size()) {
                    Integer value = (Integer)listOfAuthorities.get(j);
                    if (!cumulative.contains(value)) {
                        cumulative.add(value);
                    }
                    ++j;
                }
                UiAuthorityRecord uiAuthRecord = (UiAuthorityRecord)this.uiFactoryClass.create(t, dmAuthRecord, null);
                dmCumulativeAuthority.addChild(t, (IDmObjectLink)dmAuthRecord);
                this.uiObjects.add(uiAuthRecord);
            }
            ++i;
        }
        int[] authList = new int[cumulative.size()];
        int i2 = 0;
        while (i2 < cumulative.size()) {
            authList[i2] = (Integer)cumulative.get(i2);
            ++i2;
        }
        if (Trace.isTracing) {
            t.data(66, "OamGetAccumulatedAuthority.createCumulativeObject", 300, "Accumulated authorities : " + authList);
        }
        dmCumulativeAuthority.addAttr(t, 1115, 0, (Object)authList);
        dmCumulativeAuthority.addAttr(t, 1016, 0, (Object)profileType);
        dmCumulativeAuthority.addAttr(t, 3068, 0, (Object)entityName);
        dmCumulativeAuthority.addAttr(t, 1118, 0, (Object)entityType);
        dmCumulativeAuthority.addAttr(t, 3067, 0, (Object)profileName);
        dmCumulativeAuthority.initialize(t);
        UiAuthorityRecord uiCumulativeAuthority = (UiAuthorityRecord)this.uiFactoryClass.create(t, (DmObject)dmCumulativeAuthority, null);
        uiCumulativeAuthority.setAccumulated(true);
        this.uiObjects.add(uiCumulativeAuthority);
    }

    public ArrayList getUiObjects() {
        return this.uiObjects;
    }

    private String extractGroupName(Trace t, String name) {
        String groupName = name;
        int i = name.lastIndexOf("@");
        if (i != -1) {
            groupName = name.substring(0, i);
        }
        return groupName;
    }
}

