/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.pcf;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmEntityAuthority;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Shell;

public class OamGetAccumulatedAndConnect
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/pcf/OamGetAccumulatedAndConnect.java";
    public static final String MY_NAME = "IBM MQ get accumulated and connect";
    private ArrayList dmObjects = new ArrayList();
    private DmObjectFilter dmObjectFilter = null;
    private DmQueueManager dmQueueManager = null;
    private String entityName = null;
    private int entityType = 0;
    private DmObjectListListener listener = null;
    private DmCoreException dmCoreException = null;
    private boolean connectAuthority = false;
    private boolean connectAuthorityProblem = false;

    protected OamGetAccumulatedAndConnect(Trace t, DmObjectListListener _listener, Shell _shell, DmQueueManager _qm, DmObjectFilter _filter, String _eName, int _eType) {
        this.setName(MY_NAME);
        this.listener = _listener;
        this.dmObjectFilter = _filter;
        this.dmQueueManager = _qm;
        this.entityName = _eName;
        this.entityType = _eType;
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        this.execute(t);
        DmObjectListEvent event = new DmObjectListEvent((Object)this, null, this.dmObjects, this.dmCoreException);
        this.listener.dmObjectListDone(event);
    }

    private void execute(Trace t) {
        try {
            this.dmObjects = this.dmQueueManager.getObjects(t, this.dmObjectFilter);
        }
        catch (DmCoreException e) {
            if (Trace.isTracing) {
                t.data(66, "OamGetAccumulatedAndConnect.execute", 900, "Error getting accumulated authorities\n" + (Object)((Object)e));
            }
            this.dmCoreException = e;
        }
        if (this.dmCoreException == null) {
            this.getConnectAuthority(t);
        }
    }

    public ArrayList getDmObjects() {
        return this.dmObjects;
    }

    private void getConnectAuthority(Trace t) {
        if (Trace.isTracing) {
            t.data(66, "OamGetAccumulatedAndConnect.getConnectAuthority", 300, "Getting connect authority for " + this.entityName);
        }
        DmObjectFilter dmObjectFilter1 = new DmObjectFilter(t, 88, 5);
        dmObjectFilter1.setEntity(t, this.entityName, this.entityType);
        try {
            ArrayList objects = this.dmQueueManager.getObjects(t, dmObjectFilter1, false);
            if (Trace.isTracing) {
                t.data(66, "OamGetAccumulatedAndConnect.getConnectAuthority", 300, "Number of authority records : " + objects.size());
            }
            int i = 0;
            while (i < objects.size()) {
                DmEntityAuthority authRecord = (DmEntityAuthority)objects.get(i);
                authRecord.getAttributeValue(t, 3068, 0);
                Attr attr = authRecord.getAttribute(t, 14006, 0);
                if (attr != null) {
                    Boolean bb = (Boolean)attr.getValue(t);
                    if (bb.booleanValue()) {
                        this.connectAuthority = true;
                    }
                } else {
                    this.connectAuthorityProblem = true;
                    if (Trace.isTracing) {
                        t.data(66, "OamGetAccumulatedAndConnect.getConnectAuthority", 900, "Error getting connect authority attribute");
                    }
                }
                ++i;
            }
        }
        catch (DmCoreException e) {
            if (Trace.isTracing) {
                t.data(66, "OamGetAccumulatedAndConnect.getConnectAuthority", 900, "Error getting connect authority\n" + (Object)((Object)e));
            }
            this.connectAuthorityProblem = true;
        }
    }

    protected boolean hasConnectAuthority() {
        return this.connectAuthority;
    }

    protected boolean isConnectAuthorityProblem() {
        return this.connectAuthorityProblem;
    }
}

