/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.pcf;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.oam.internal.base.OamCommon;
import java.util.ArrayList;

public class OamFilterFindObjects {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/pcf/OamFilterFindObjects.java";
    private String profileName = null;
    private String entityName = null;
    private int entityType = 0;
    private boolean isGenericProfile = false;
    private boolean isAccumulated = false;

    public OamFilterFindObjects(Trace t, String _pname, boolean _generic, boolean _accumulated, String _eName, int _eType) {
        this.isGenericProfile = _generic;
        this.profileName = _pname;
        this.entityName = _eName;
        this.entityType = _eType;
        this.isAccumulated = _accumulated;
    }

    public ArrayList<IDmObject> filterResponse(Trace t, ArrayList objects) {
        ArrayList<IDmObject> filteredList = new ArrayList<IDmObject>();
        if (objects != null) {
            if (Trace.isTracing) {
                t.data(66, "OamFilterFindObjects.filterResponse", 300, "Number of authority records : " + objects.size());
            }
            int i = 0;
            while (i < objects.size()) {
                IDmObject dmAuthRecord = (IDmObject)objects.get(i);
                if (dmAuthRecord instanceof DmAuthorityRecord) {
                    String pName = ((DmAuthorityRecord)dmAuthRecord).getProfileName(t);
                    String eName = ((DmAuthorityRecord)dmAuthRecord).getEntityName(t);
                    int eType = ((DmAuthorityRecord)dmAuthRecord).getEntityType(t);
                    if (Trace.isTracing) {
                        t.data(66, "OamFilterFindObjects.filterResponse", 300, "Profile name : " + pName + ", entity name :" + eName + ", entity type" + eType);
                    }
                    if (!(pName == null || pName.equalsIgnoreCase(OamCommon.getClassProfileName(dmAuthRecord.getQueueManager().getPlatform())) || eType != this.entityType && this.entityType != -1)) {
                        if (this.addUsingLocalFilter(t, pName, eName)) {
                            filteredList.add(dmAuthRecord);
                        }
                    } else if (Trace.isTracing) {
                        t.data(66, "OamFilterFindObjects.filterResponse", 300, "Ignored profile name : " + pName + ", entity name :" + eName + ", entity type" + eType);
                    }
                } else if (Trace.isTracing) {
                    t.data(66, "OamFilterFindObjects.filterResponse", 900, "Not a data model authority record : " + dmAuthRecord.getTitle());
                }
                ++i;
            }
        }
        return filteredList;
    }

    private boolean addUsingLocalFilter(Trace t, String pName, String eName) {
        boolean add = true;
        if (!this.isGenericProfile) {
            if (this.isAccumulated || !OamCommon.isGenericName(pName)) {
                String profName;
                if (!this.profileName.equalsIgnoreCase("") && this.profileName.endsWith("*") && !pName.startsWith(profName = this.profileName.substring(0, this.profileName.length() - 1))) {
                    add = false;
                }
            } else {
                add = false;
            }
        } else if (!OamCommon.isGenericName(pName)) {
            add = false;
        }
        if (this.entityName != null && !this.entityName.equalsIgnoreCase("")) {
            if (this.entityName.indexOf("@") > 0) {
                if (!this.entityName.equalsIgnoreCase(eName)) {
                    add = false;
                }
            } else if (eName.toUpperCase().equals(this.entityName.toUpperCase())) {
                add = true;
            } else if (!eName.toUpperCase().startsWith(String.valueOf(this.entityName.toUpperCase()) + "@")) {
                add = false;
            }
        }
        return add;
    }
}

