/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.pcf;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.oam.internal.pcf.OamCommonPCF;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import org.eclipse.swt.widgets.Shell;

public class OamDeleteCreateAuthority
extends OamCommonPCF {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/pcf/OamDeleteCreateAuthority.java";

    public OamDeleteCreateAuthority(Trace t, Shell _shell, DmAuthorityRecord _authRecord) {
        super(t, _shell, _authRecord);
    }

    @Override
    public int apply(Trace t, String message) {
        if (this.promptToDelete(t, true) == 0) {
            this.createRemoveList(t);
            this.busyDialog = new BusyDialog(this.parentShell, message);
            this.processLists(t);
            this.busyDialog.showDialog(t);
            if (this.dmActionEvent != null) {
                this.reasonCode = this.errorException != null ? this.errorException.getReasonCode() : this.dmActionEvent.getReasonCode();
                if (Trace.isTracing) {
                    t.data(66, "OamDeleteCreateAuthority.apply", 300, "Delete crt authority reason code = " + this.reasonCode);
                }
                this.profileName = this.dmAuthorityRecord.getQueueManager().getTitle();
                this.displayMessage(t);
            } else if (Trace.isTracing) {
                t.data(66, "OamDeleteCreateAuthority.apply", 900, "Invalid response from action");
            }
        } else if (Trace.isTracing) {
            t.data(66, "OamDeleteCreateAuthority.apply", 300, "User chose not to delete");
        }
        return this.reasonCode;
    }

    @Override
    public void sendCommand(Trace t) {
        this.dmAuthorityRecord.actionChange(t, (DmActionListener)this, this.job, true);
    }

    @Override
    public void dmActionDone(DmActionEvent event) {
        Trace t = Trace.getDefault();
        --this.numberOfResponses;
        if (Trace.isTracing) {
            t.data(66, "OamDeleteCreateAuthority.dmActionDone", 300, "Response counter now =" + this.numberOfResponses);
        }
        this.dmActionEvent = event;
        if (event.getException() != null) {
            this.errorException = event.getException();
            if (Trace.isTracing) {
                t.data(66, "OamDeleteCreateAuthority.dmActionDone", 900, "PCF error, rc = " + this.errorException.getReasonCode());
            }
        }
        if (this.numberOfResponses < 1 && this.busyDialog != null) {
            this.parentShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OamDeleteCreateAuthority.this.busyDialog.closeDialog(Trace.getDefault());
                    OamDeleteCreateAuthority.this.busyDialog = null;
                }
            });
        }
    }

    private void createRemoveList(Trace t) {
        int[] authority = this.dmAuthorityRecord.getQueueManager().getValidCrtAuthorities(t);
        int i = 0;
        while (i < authority.length) {
            int auth = DmAuthorityRecord.getRealAuthority((int)authority[i]);
            this.removedList.add(auth);
            ++this.numberOfResponses;
            ++i;
        }
        if (Trace.isTracing) {
            t.data(66, "OamDeleteCreateAuthority.createRemoveList", 300, "Response counter initial value =" + this.numberOfResponses);
        }
    }
}

