/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.pcf;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;
import com.ibm.mq.explorer.oam.internal.base.OamPlugin;
import com.ibm.mq.explorer.oam.internal.object.OamAuthorityButton;
import com.ibm.mq.explorer.oam.internal.pcf.IOamCommonPCF;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public abstract class OamCommonPCF
implements DmActionListener,
DmObjectListListener,
IOamCommonPCF {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/pcf/OamCommonPCF.java";
    protected BusyDialog busyDialog = null;
    protected Shell parentShell = null;
    protected DmActionEvent dmActionEvent = null;
    protected DmObjectListEvent dmObjectListEvent = null;
    protected DmAuthorityRecord dmAuthorityRecord = null;
    protected Object job = null;
    protected String entityName = null;
    protected String entityType = null;
    protected String profileName = null;
    protected DmQueueManager dmQueueManager = null;
    protected DmObjectFilter dmObjectFilter = null;
    protected PCFFilter pcfFilter = null;
    protected int reasonCode = 0;
    protected int completionCode = 3238;
    protected ArrayList<Integer> addedList = new ArrayList();
    protected ArrayList<Integer> removedList = new ArrayList();
    protected ArrayList<OamAuthorityButton> listOfButtons = null;
    protected int numberOfResponses = 0;
    protected boolean create = false;
    protected DmCoreException errorException = null;

    public OamCommonPCF(Trace t, Shell _shell, DmAuthorityRecord _authRecord) {
        this.parentShell = _shell;
        this.dmAuthorityRecord = _authRecord;
    }

    public OamCommonPCF(Trace t, Shell _shell, DmQueueManager _qm, DmObjectFilter _filter) {
        this.parentShell = _shell;
        this.dmObjectFilter = _filter;
        this.dmQueueManager = _qm;
    }

    public void dmActionDone(DmActionEvent event) {
        this.dmActionEvent = event;
        if (this.busyDialog != null) {
            this.parentShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OamCommonPCF.this.busyDialog.closeDialog(Trace.getDefault());
                    OamCommonPCF.this.busyDialog = null;
                }
            });
        }
    }

    public void dmObjectListDone(DmObjectListEvent event) {
        this.dmObjectListEvent = event;
        if (this.busyDialog != null) {
            this.parentShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OamCommonPCF.this.busyDialog.closeDialog(Trace.getDefault());
                    OamCommonPCF.this.busyDialog = null;
                }
            });
        }
    }

    protected void getEntityDetailsFromAuthRecord(Trace t) {
        this.entityName = this.dmAuthorityRecord.getAttributeValue(t, 3068, 0);
        if (Trace.isTracing) {
            t.data(66, "OamCommonPCF.getEntityDetailsFromAuthRecord", 300, "Entity name is " + this.entityName);
        }
        int i = (Integer)((AttrInt)this.dmAuthorityRecord.getAttribute(t, 1118, 0)).getValue(t);
        String[] al = new String[]{this.entityName};
        switch (i) {
            case 2: {
                this.dmAuthorityRecord.createAttribute(t, this.job, 3066, 0, (Object)al);
                this.entityType = OamPlugin.oamMessages.getMessage("OAM.Group.Text");
                if (!Trace.isTracing) break;
                t.data(66, "OamCommonPCF.getEntityDetailsFromAuthRecord", 300, "Entity type is group");
                break;
            }
            case 1: {
                this.dmAuthorityRecord.createAttribute(t, this.job, 3065, 0, (Object)al);
                this.entityType = OamPlugin.oamMessages.getMessage("OAM.User.Text");
                if (!Trace.isTracing) break;
                t.data(66, "OamCommonPCF.getEntityDetailsFromAuthRecord", 300, "Entity type is user");
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(66, "OamCommonPCF.getEntityDetailsFromAuthRecord", 900, "Entity type " + i + " is unknown");
            }
        }
    }

    protected void displayMessage(Trace t) {
        String[] inserts = null;
        String msg = null;
        String msgId = null;
        switch (this.reasonCode) {
            case 0: {
                msgId = "AMQ4810";
                inserts = new String[]{this.entityName, this.profileName};
                break;
            }
            case 2085: {
                msgId = "AMQ4823";
                inserts = new String[]{this.profileName};
                break;
            }
            case 3170: {
                msgId = "AMQ4824";
                inserts = new String[]{this.profileName};
                break;
            }
            case 2063: 
            case 2292: {
                msgId = "AMQ4808";
                inserts = new String[]{this.entityType, this.entityName};
                break;
            }
            case 2035: 
            case 2149: 
            case 2322: 
            case 3081: {
                msg = ConvertReasonCode.getSystemMessage((Trace)t, (DmObject)this.dmQueueManager, (int)87, (int)this.reasonCode, (int)this.completionCode);
                break;
            }
            case 2281: 
            case 3095: {
                msgId = "AMQ4818";
                break;
            }
            case 3202: {
                msgId = "AMQ4826";
                break;
            }
            case 3201: {
                msgId = "AMQ4831";
                break;
            }
            case 3303: {
                msgId = "AMQ4832";
                break;
            }
            default: {
                msgId = "AMQ4999";
                inserts = new String[]{String.valueOf(this.reasonCode)};
            }
        }
        if (Trace.isTracing) {
            if (msg == null) {
                msg = CommonServices.getSystemMessage((String)msgId);
            }
            t.data(66, "OamCommonPCF.displayMessage", 300, "Error message = " + msg);
        }
        if (msg != null) {
            MessageBox.showMessageFailure((Trace)t, (Shell)this.parentShell, (String)msg, (Image)Icons.get((String)Icons.iconkeyEntityName));
        } else {
            MessageBox.showSystemMessageById((Trace)t, (Shell)this.parentShell, (String)msgId, (String[])inserts, (String)msgId, (Image)Icons.get((String)Icons.iconkeyEntityName));
        }
    }

    @Override
    public void setListOfButtons(ArrayList<OamAuthorityButton> list) {
        this.listOfButtons = list;
    }

    protected Integer getObjectType(Trace t, int authId) {
        int objectType = 0;
        if (Trace.isTracing) {
            t.data(66, "OamCommonPCF.getObjectType", 300, "Pseudo crt type = " + authId);
        }
        switch (authId) {
            case 14027: {
                objectType = 7;
                break;
            }
            case 14035: {
                objectType = 9;
                break;
            }
            case 14025: {
                objectType = 6;
                break;
            }
            case 14026: {
                objectType = 1014;
                break;
            }
            case 14028: {
                objectType = 11;
                break;
            }
            case 14022: {
                objectType = 2;
                break;
            }
            case 14023: {
                objectType = 3;
                break;
            }
            case 14024: {
                objectType = 5;
                break;
            }
            case 14021: {
                objectType = 1;
                break;
            }
            case 14036: {
                objectType = 1017;
                break;
            }
            case 14029: {
                objectType = 12;
                break;
            }
            case 14030: {
                objectType = 8;
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(66, "OamCommonPCF.getObjectType", 900, "Unknown auth type " + authId);
            }
        }
        if (Trace.isTracing) {
            t.data(66, "OamCommonPCF.getObjectType", 300, "WMQ object type = " + objectType);
        }
        return objectType;
    }

    protected void processLists(Trace t) {
        Integer i;
        while (this.addedList.size() > 0) {
            this.job = this.dmAuthorityRecord.beginUpdate(t);
            this.getEntityDetailsFromAuthRecord(t);
            int[] adds = new int[1];
            i = this.addedList.remove(0);
            adds[0] = 6;
            if (Trace.isTracing) {
                t.data(66, "OamCommonPCF.processLists", 300, "Authority to add : " + adds);
            }
            this.dmAuthorityRecord.createAttribute(t, this.job, 1116, 0, (Object)adds);
            this.dmAuthorityRecord.addAttr(t, 1016, 0, (Object)this.getObjectType(t, i));
            this.sendCommand(t);
        }
        while (this.removedList.size() > 0) {
            this.job = this.dmAuthorityRecord.beginUpdate(t);
            this.getEntityDetailsFromAuthRecord(t);
            int[] removes = new int[1];
            i = this.removedList.remove(0);
            removes[0] = 6;
            if (Trace.isTracing) {
                t.data(66, "OamCommonPCF.processLists", 300, "Authority to remove : " + removes);
            }
            this.dmAuthorityRecord.createAttribute(t, this.job, 1117, 0, (Object)removes);
            this.dmAuthorityRecord.addAttr(t, 1016, 0, (Object)this.getObjectType(t, i));
            this.sendCommand(t);
        }
    }

    protected int promptToDelete(Trace t, boolean crt) {
        String msg = null;
        String msgId = null;
        this.entityName = this.dmAuthorityRecord.getAttributeValue(t, 3068, 0);
        this.profileName = this.dmAuthorityRecord.getProfileType(t) == 5 ? this.dmAuthorityRecord.getQueueManager().getTitle() : this.dmAuthorityRecord.getTitle();
        if (crt) {
            msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4812", (String[])new String[]{this.entityName});
        } else {
            msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4809", (String[])new String[]{this.entityName, this.profileName});
            msgId = "AMQ4809";
        }
        int reply = MessageBox.showDeleteCancelMessage((Trace)t, (Shell)this.parentShell, (String)msg, (int)1, (String)msgId);
        return reply;
    }

    protected String getEntityType(Trace t, int eType) {
        String enType = "[not_defined]";
        switch (eType) {
            case 2: {
                enType = OamPlugin.oamMessages.getMessage("OAM.Group.Text");
                break;
            }
            case 1: {
                enType = OamPlugin.oamMessages.getMessage("OAM.User.Text");
                break;
            }
            default: {
                enType = OamPlugin.oamMessages.getMessage("OAM.Name.Text");
            }
        }
        return enType;
    }

    public void setProfileName(Trace t, String pName) {
        this.profileName = pName;
    }

    public void setEntityType(Trace t, int eType) {
        this.entityType = this.getEntityType(t, eType);
    }

    public void setEntityType(Trace t, String eType) {
        this.entityType = eType;
    }

    public void setEntityName(Trace t, String eName) {
        this.entityName = eName;
    }
}

