/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.object;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.oam.internal.object.OamAuthInfo;
import com.ibm.mq.explorer.oam.internal.object.OamChannel;
import com.ibm.mq.explorer.oam.internal.object.OamClientConnChannel;
import com.ibm.mq.explorer.oam.internal.object.OamCommInfo;
import com.ibm.mq.explorer.oam.internal.object.OamListener;
import com.ibm.mq.explorer.oam.internal.object.OamNamelist;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import com.ibm.mq.explorer.oam.internal.object.OamProcess;
import com.ibm.mq.explorer.oam.internal.object.OamQueue;
import com.ibm.mq.explorer.oam.internal.object.OamQueueManager;
import com.ibm.mq.explorer.oam.internal.object.OamRemoteQueueManagerName;
import com.ibm.mq.explorer.oam.internal.object.OamService;
import com.ibm.mq.explorer.oam.internal.object.OamTopic;
import java.util.Hashtable;

public class OamObjectFactory {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/object/OamObjectFactory.java";
    private static Hashtable<String, OamObject> table = new Hashtable(9);
    private static final String TEMPORARY_UUID = "<temp>";

    private OamObjectFactory() {
    }

    public static OamObject createOamObject(Trace t, String uuid, String name, String id) {
        OamObject oamObject = null;
        String key = String.valueOf(uuid) + "/" + id;
        if (id.compareTo("com.ibm.mq.explorer.treenode.queues") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.topics") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.channels") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.clientconns") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.listeners") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.authinfos") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.comminfos") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.namelists") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.services") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.procs") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.qmgrs") == 0) {
            name = "*";
        }
        if ((oamObject = table.get(key)) == null) {
            oamObject = OamObjectFactory.getOamObject(t, id);
            if (oamObject != null) {
                oamObject.setName(t, name);
                table.put(key, oamObject);
            }
        } else {
            oamObject.setName(t, name);
        }
        return oamObject;
    }

    public static OamObject createTempOamObject(Trace t, String name, String id) {
        return OamObjectFactory.createOamObject(t, "<temp>/" + id, name, id);
    }

    private static OamObject getOamObject(Trace t, String id) {
        OamObject oamObject = null;
        if (id.compareTo("com.ibm.mq.explorer.authinfo") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.authinfos") == 0 || id.compareTo("com.ibm.mq.explorer.oam.authinfo") == 0) {
            oamObject = new OamAuthInfo();
        } else if (id.compareTo("com.ibm.mq.explorer.comminfo") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.comminfos") == 0 || id.compareTo("com.ibm.mq.explorer.oam.comminfo") == 0) {
            oamObject = new OamCommInfo();
        } else if (id.compareTo("com.ibm.mq.explorer.clientconn") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.clientconns") == 0 || id.compareTo("com.ibm.mq.explorer.oam.clntconn.channel") == 0) {
            oamObject = new OamClientConnChannel();
        } else if (id.compareTo("com.ibm.mq.explorer.channel") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.channels") == 0 || id.compareTo("com.ibm.mq.explorer.oam.channel") == 0) {
            oamObject = new OamChannel();
        } else if (id.compareTo("com.ibm.mq.explorer.listener") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.listeners") == 0 || id.compareTo("com.ibm.mq.explorer.oam.listener") == 0) {
            oamObject = new OamListener();
        } else if (id.compareTo("com.ibm.mq.explorer.namelist") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.namelists") == 0 || id.compareTo("com.ibm.mq.explorer.oam.namelist") == 0) {
            oamObject = new OamNamelist();
        } else if (id.compareTo("com.ibm.mq.explorer.proc") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.procs") == 0 || id.compareTo("com.ibm.mq.explorer.oam.process") == 0) {
            oamObject = new OamProcess();
        } else if (id.compareTo("com.ibm.mq.explorer.queue") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.queues") == 0 || id.compareTo("com.ibm.mq.explorer.oam.queue") == 0) {
            oamObject = new OamQueue();
        } else if (id.compareTo("com.ibm.mq.explorer.topic") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.topics") == 0 || id.compareTo("com.ibm.mq.explorer.oam.topic") == 0) {
            oamObject = new OamTopic();
        } else if (id.compareTo("com.ibm.mq.explorer.queuemanager") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.qmgrs") == 0 || id.compareTo("com.ibm.mq.explorer.oam.queuemanager") == 0) {
            oamObject = new OamQueueManager();
        } else if (id.compareTo("com.ibm.mq.explorer.service") == 0 || id.compareTo("com.ibm.mq.explorer.treenode.services") == 0 || id.compareTo("com.ibm.mq.explorer.oam.service") == 0) {
            oamObject = new OamService();
        } else if (id.compareTo("com.ibm.mq.explorer.rqmname") == 0 || id.compareTo("com.ibm.mq.explorer.oam.rqmname") == 0) {
            oamObject = new OamRemoteQueueManagerName();
        } else if (Trace.isTracing) {
            t.data(66, "OamObjectFactory.getOamObject", 900, "Unknown key = " + id);
        }
        return oamObject;
    }
}

