/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.menuaction;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.oam.internal.object.OamObject;
import com.ibm.mq.explorer.oam.internal.object.OamObjectFactory;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;

public abstract class OamMenuAction
implements IActionDelegate {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/menuaction/OamMenuAction.java";
    private TreeNode selectedTreeNode = null;
    private MQExtObject selectedMQExtObject = null;
    private String mqObjectName = null;
    private String mqObjectTypeId = null;
    protected DmQueueManager dmQueueManager = null;
    private UiQueueManager uiQueueManager = null;
    protected OamObject oamObject = null;
    private DmObject dmObject = null;

    public abstract void run(IAction var1);

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object obj;
        Trace t = Trace.getDefault();
        if (selection != null && selection instanceof IStructuredSelection && (obj = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
            if (obj instanceof TreeNode) {
                this.selectedTreeNode = (TreeNode)obj;
                if (Trace.isTracing) {
                    t.data(66, "OamMenuAction.selectionChanged", 300, "Selected treenode id is " + this.selectedTreeNode.getId());
                }
                if (this.selectedTreeNode.getId().startsWith("com.ibm.mq.explorer.treenode.qm.")) {
                    Object treeNodeObj = this.selectedTreeNode.getObject();
                    if (treeNodeObj instanceof MQExtObject) {
                        this.selectedMQExtObject = (MQExtObject)treeNodeObj;
                        this.getMQQmgrExtObject(this.selectedMQExtObject);
                        if (Trace.isTracing) {
                            t.data(66, "OamMenuAction.selectionChanged", 300, "Selected MQ object id " + this.selectedMQExtObject.getObjectId());
                        }
                        this.mqObjectName = this.selectedMQExtObject.getName();
                        this.mqObjectTypeId = this.selectedMQExtObject.getMqType();
                    }
                } else {
                    this.mqObjectName = this.selectedTreeNode.toString();
                    this.mqObjectTypeId = this.selectedTreeNode.getTreeNodeId();
                    this.getMQQmgrExtObject((MQExtObject)this.selectedTreeNode.getObject());
                }
            } else if (obj instanceof MQExtObject) {
                this.selectedMQExtObject = (MQExtObject)obj;
                if (Trace.isTracing) {
                    t.data(66, "OamMenuAction.selectionChanged", 300, "Selected MQ object id " + this.selectedMQExtObject.getObjectId());
                }
                this.mqObjectName = this.selectedMQExtObject.getName();
                this.mqObjectTypeId = this.selectedMQExtObject.getMqType();
                this.getMQQmgrExtObject(this.selectedMQExtObject);
            }
            if (Trace.isTracing) {
                t.data(66, "OamMenuAction.selectionChanged", 300, "Selected MQ object name is " + this.mqObjectName);
            }
            this.oamObject = OamObjectFactory.createOamObject(t, this.dmQueueManager.getUUID(), this.mqObjectName, this.mqObjectTypeId);
            if (this.oamObject != null) {
                this.oamObject.setDmObject(this.dmObject);
                this.oamObject.setDmQueueManager(this.dmQueueManager);
                this.oamObject.setMqObjectName(this.mqObjectName);
                this.oamObject.setUiQueueManager(this.uiQueueManager);
            }
        }
    }

    private void getMQQmgrExtObject(MQExtObject mqExtObject) {
        MQQmgrExtObject mqQmgrExtObject = null;
        this.dmObject = (DmObject)((UiMQObject)mqExtObject.getInternalObject()).getDmObject();
        MQExtObject testObject = mqExtObject;
        do {
            if (!(testObject instanceof MQQmgrExtObject)) continue;
            mqQmgrExtObject = (MQQmgrExtObject)testObject;
            break;
        } while ((testObject = testObject.getParent()) != null);
        if (mqQmgrExtObject != null) {
            this.uiQueueManager = (UiQueueManager)mqQmgrExtObject.getInternalObject();
            this.dmQueueManager = (DmQueueManager)this.uiQueueManager.getDmObject();
        }
    }
}

