/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.internal.filter;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.ui.IActionFilter;

public class OamRefreshSecurityMenuActionFilter
implements IActionFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam/src/com/ibm/mq/explorer/oam/internal/filter/OamRefreshSecurityMenuActionFilter.java";
    private DmQueueManager dmQueueManager = null;

    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        boolean result = false;
        if (name.compareTo("OamTreeNodeRefreshSecurity") == 0) {
            result = this.filterTreeNode(t, target, value);
        } else if (name.compareTo("OamContentPageObjectRefreshSecurity") == 0) {
            result = this.filterContentPage(t, target, value);
        }
        return result;
    }

    private boolean filterTreeNode(Trace t, Object target, String value) {
        boolean result;
        block7: {
            result = false;
            try {
                TreeNode selectedTreeNode = (TreeNode)target;
                if (selectedTreeNode.getId().startsWith("com.ibm.mq.explorer.treenode.qm.")) {
                    Object treeNodeObj = selectedTreeNode.getObject();
                    if (treeNodeObj instanceof MQExtObject) {
                        MQExtObject selectedMQExtObject = (MQExtObject)treeNodeObj;
                        this.dmQueueManager = this.getMQQmgrExtObject(t, selectedMQExtObject);
                        if (Trace.isTracing) {
                            t.data(66, "OamRefreshSecurityMenuActionFilter.filterTreeNode", 300, "Selected MQ object id " + selectedMQExtObject.getObjectId());
                        }
                    }
                } else {
                    this.dmQueueManager = this.getMQQmgrExtObject(t, (MQExtObject)selectedTreeNode.getObject());
                }
                if (this.dmQueueManager != null) {
                    result = this.dmQueueManager.getCommandLevel() < 700 ? true : this.addContextMenu(t, value);
                }
            }
            catch (ClassCastException cce) {
                if (!Trace.isTracing) break block7;
                t.data(66, "OamRefreshSecurityMenuActionFilter.filterTreeNode", 900, cce.toString());
            }
        }
        return result;
    }

    private boolean filterContentPage(Trace t, Object target, String value) {
        boolean result = false;
        MQExtObject selectedMQExtObject = (MQExtObject)target;
        this.dmQueueManager = this.getMQQmgrExtObject(t, selectedMQExtObject);
        if (this.dmQueueManager != null) {
            result = this.dmQueueManager.getCommandLevel() < 700 ? true : this.addContextMenu(t, value);
        }
        return result;
    }

    private DmQueueManager getMQQmgrExtObject(Trace t, MQExtObject mqExtObject) {
        MQQmgrExtObject mqQmgrExtObject = null;
        MQExtObject testObject = mqExtObject;
        do {
            if (!(testObject instanceof MQQmgrExtObject)) continue;
            mqQmgrExtObject = (MQQmgrExtObject)testObject;
            break;
        } while ((testObject = testObject.getParent()) != null);
        if (mqQmgrExtObject != null) {
            UiQueueManager uiQueueManager = (UiQueueManager)mqQmgrExtObject.getInternalObject();
            this.dmQueueManager = (DmQueueManager)uiQueueManager.getDmObject();
        }
        return this.dmQueueManager;
    }

    private boolean addContextMenu(Trace t, String value) {
        boolean add = false;
        Attr a = this.dmQueueManager.getAttribute(t, 141, 0);
        if (a != null) {
            Integer i = (Integer)a.getValue(t);
            switch (i) {
                case 1: {
                    if (!value.equals("com.ibm.mq.explorer.oam.treenode.queuemanager.menuaction.RefreshSecurityMixedClassesAdmin") && !value.equals("com.ibm.mq.explorer.oam.treenode.queuemanager.menuaction.RefreshSecurityMixedClassesNamelist") && !value.equals("com.ibm.mq.explorer.oam.treenode.queuemanager.menuaction.RefreshSecurityMixedClassesProcess") && !value.equals("com.ibm.mq.explorer.oam.treenode.queuemanager.menuaction.RefreshSecurityMixedClassesQueue") && !value.equals("com.ibm.mq.explorer.oam.treenode.queuemanager.menuaction.RefreshSecurityMixedClassesTopic") && !value.equals("com.ibm.mq.explorer.oam.treenode.queuemanager.menuaction.RefreshSecurityMixedClassesAll")) break;
                    add = true;
                    break;
                }
                case 0: {
                    if (!value.equals("com.ibm.mq.explorer.oam.treenode.queuemanager.refreshClasses") && !value.equals("com.ibm.mq.explorer.oam.treenode.queuemanager.menuaction.RefreshSecurityMixedClassesTopic")) break;
                    add = true;
                }
            }
        }
        return add;
    }
}

